/* gio-2.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "G", lower_case_cprefix = "g_")]
namespace GLib {
	[CCode (cheader_filename = "gio/gio.h")]
	public class AppLaunchContext : GLib.Object {
		public virtual unowned string get_display (GLib.AppInfo info, GLib.List files);
		public virtual unowned string get_startup_notify_id (GLib.AppInfo info, GLib.List files);
		public virtual void launch_failed (string startup_notify_id);
		[CCode (has_construct_function = false)]
		public AppLaunchContext ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class BufferedInputStream : GLib.FilterInputStream {
		public virtual ssize_t fill (ssize_t count, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void fill_async (ssize_t count, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual ssize_t fill_finish (GLib.AsyncResult _result) throws GLib.Error;
		public size_t get_available ();
		public size_t get_buffer_size ();
		[CCode (type = "GInputStream*", has_construct_function = false)]
		public BufferedInputStream (GLib.InputStream base_stream);
		public size_t peek (void* buffer, size_t offset, size_t count);
		public void* peek_buffer (size_t count);
		public int read_byte (GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_buffer_size (size_t size);
		[CCode (type = "GInputStream*", has_construct_function = false)]
		public BufferedInputStream.sized (GLib.InputStream base_stream, size_t size);
		public uint buffer_size { get; set construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class BufferedOutputStream : GLib.FilterOutputStream {
		public bool get_auto_grow ();
		public size_t get_buffer_size ();
		[CCode (type = "GOutputStream*", has_construct_function = false)]
		public BufferedOutputStream (GLib.OutputStream base_stream);
		public void set_auto_grow (bool auto_grow);
		public void set_buffer_size (size_t size);
		[CCode (type = "GOutputStream*", has_construct_function = false)]
		public BufferedOutputStream.sized (GLib.OutputStream base_stream, size_t size);
		public bool auto_grow { get; set; }
		public uint buffer_size { get; set construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class Cancellable : GLib.Object {
		public void cancel ();
		public static unowned GLib.Cancellable get_current ();
		public int get_fd ();
		public bool is_cancelled ();
		public void make_pollfd (GLib.PollFD pollfd);
		[CCode (has_construct_function = false)]
		public Cancellable ();
		public void pop_current ();
		public void push_current ();
		public void reset ();
		public bool set_error_if_cancelled () throws GLib.Error;
		public virtual signal void cancelled ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DataInputStream : GLib.BufferedInputStream {
		public GLib.DataStreamByteOrder get_byte_order ();
		public GLib.DataStreamNewlineType get_newline_type ();
		[CCode (has_construct_function = false)]
		public DataInputStream (GLib.InputStream base_stream);
		public uchar read_byte (GLib.Cancellable? cancellable) throws GLib.Error;
		public int16 read_int16 (GLib.Cancellable? cancellable) throws GLib.Error;
		public int32 read_int32 (GLib.Cancellable? cancellable) throws GLib.Error;
		public int64 read_int64 (GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned string read_line (out size_t length, GLib.Cancellable? cancellable) throws GLib.Error;
		public void read_line_async (int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public unowned string read_line_finish (GLib.AsyncResult _result, size_t length) throws GLib.Error;
		public uint16 read_uint16 (GLib.Cancellable? cancellable) throws GLib.Error;
		public uint32 read_uint32 (GLib.Cancellable? cancellable) throws GLib.Error;
		public uint64 read_uint64 (GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned string read_until (string stop_chars, out size_t length, GLib.Cancellable? cancellable) throws GLib.Error;
		public void read_until_async (string stop_chars, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public unowned string read_until_finish (GLib.AsyncResult _result, size_t length) throws GLib.Error;
		public void set_byte_order (GLib.DataStreamByteOrder order);
		public void set_newline_type (GLib.DataStreamNewlineType type);
		public GLib.DataStreamByteOrder byte_order { get; set; }
		public GLib.DataStreamNewlineType newline_type { get; set; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class DataOutputStream : GLib.FilterOutputStream {
		public GLib.DataStreamByteOrder get_byte_order ();
		[CCode (has_construct_function = false)]
		public DataOutputStream (GLib.OutputStream base_stream);
		public bool put_byte (uchar data, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool put_int16 (int16 data, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool put_int32 (int32 data, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool put_int64 (int64 data, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool put_string (string str, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool put_uint16 (uint16 data, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool put_uint32 (uint32 data, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool put_uint64 (uint64 data, GLib.Cancellable? cancellable) throws GLib.Error;
		public void set_byte_order (GLib.DataStreamByteOrder order);
		public GLib.DataStreamByteOrder byte_order { get; set; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class Emblem : GLib.Object, GLib.Icon {
		public unowned GLib.Icon get_icon ();
		public GLib.EmblemOrigin get_origin ();
		[CCode (has_construct_function = false)]
		public Emblem (GLib.Icon icon);
		[CCode (has_construct_function = false)]
		public Emblem.with_origin (GLib.Icon icon, GLib.EmblemOrigin origin);
		public GLib.Object icon { get; construct; }
		public GLib.EmblemOrigin origin { get; construct; }
	}
	[Compact]
	[CCode (cheader_filename = "gio/gio.h")]
	public class EmblemClass {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class EmblemedIcon : GLib.Object, GLib.Icon {
		public void add_emblem (GLib.Emblem emblem);
		public unowned GLib.List get_emblems ();
		public unowned GLib.Icon get_icon ();
		[CCode (type = "GIcon*", has_construct_function = false)]
		public EmblemedIcon (GLib.Icon icon, GLib.Emblem emblem);
	}
	[Compact]
	[CCode (cheader_filename = "gio/gio.h")]
	public class EmblemedIconClass {
	}
	[Compact]
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileAttributeInfo {
		public GLib.FileAttributeInfoFlags flags;
		public weak string name;
		public GLib.FileAttributeType type;
	}
	[Compact]
	[CCode (ref_function = "g_file_attribute_info_list_ref", unref_function = "g_file_attribute_info_list_unref", type_id = "G_TYPE_FILE_ATTRIBUTE_INFO_LIST", cheader_filename = "gio/gio.h")]
	public class FileAttributeInfoList {
		public weak GLib.FileAttributeInfo infos;
		public int n_infos;
		public void add (string name, GLib.FileAttributeType type, GLib.FileAttributeInfoFlags flags);
		public unowned GLib.FileAttributeInfoList dup ();
		public unowned GLib.FileAttributeInfo lookup (string name);
		[CCode (has_construct_function = false)]
		public FileAttributeInfoList ();
	}
	[Compact]
	[CCode (ref_function = "g_file_attribute_matcher_ref", unref_function = "g_file_attribute_matcher_unref", cheader_filename = "gio/gio.h")]
	public class FileAttributeMatcher {
		public bool enumerate_namespace (string ns);
		public unowned string enumerate_next ();
		public bool matches (string attribute);
		public bool matches_only (string attribute);
		[CCode (has_construct_function = false)]
		public FileAttributeMatcher (string attributes);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileEnumerator : GLib.Object {
		public bool close (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void close_async (int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual bool close_finish (GLib.AsyncResult _result) throws GLib.Error;
		[NoWrapper]
		public virtual bool close_fn (GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned GLib.File get_container ();
		public bool has_pending ();
		public bool is_closed ();
		public virtual GLib.FileInfo next_file (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void next_files_async (int num_files, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual GLib.List<GLib.FileInfo> next_files_finish (GLib.AsyncResult _result) throws GLib.Error;
		public void set_pending (bool pending);
		public GLib.File container { construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileIcon : GLib.Object, GLib.LoadableIcon, GLib.Icon {
		public unowned GLib.File get_file ();
		[CCode (type = "GIcon*", has_construct_function = false)]
		public FileIcon (GLib.File file);
		public GLib.File file { get; construct; }
	}
	[Compact]
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileIconClass {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileInfo : GLib.Object {
		public void clear_status ();
		public void copy_into (GLib.FileInfo dest_info);
		public unowned GLib.FileInfo dup ();
		public unowned string get_attribute_as_string (string attribute);
		public bool get_attribute_boolean (string attribute);
		public unowned string get_attribute_byte_string (string attribute);
		public bool get_attribute_data (string attribute, GLib.FileAttributeType? type, void* value_pp, GLib.FileAttributeStatus? status);
		public int32 get_attribute_int32 (string attribute);
		public int64 get_attribute_int64 (string attribute);
		public unowned GLib.Object get_attribute_object (string attribute);
		public GLib.FileAttributeStatus get_attribute_status (string attribute);
		public unowned string get_attribute_string (string attribute);
		public GLib.FileAttributeType get_attribute_type (string attribute);
		public uint32 get_attribute_uint32 (string attribute);
		public uint64 get_attribute_uint64 (string attribute);
		public unowned string get_content_type ();
		public unowned string get_display_name ();
		public unowned string get_edit_name ();
		public unowned string get_etag ();
		public GLib.FileType get_file_type ();
		public unowned GLib.Icon get_icon ();
		public bool get_is_backup ();
		public bool get_is_hidden ();
		public bool get_is_symlink ();
		public void get_modification_time (GLib.TimeVal _result);
		public unowned string get_name ();
		public int64 get_size ();
		public int32 get_sort_order ();
		public unowned string get_symlink_target ();
		public bool has_attribute (string attribute);
		public unowned string list_attributes (string name_space);
		[CCode (has_construct_function = false)]
		public FileInfo ();
		public void remove_attribute (string attribute);
		public void set_attribute (string attribute, GLib.FileAttributeType type, void* value_p);
		public void set_attribute_boolean (string attribute, bool attr_value);
		public void set_attribute_byte_string (string attribute, string attr_value);
		public void set_attribute_int32 (string attribute, int32 attr_value);
		public void set_attribute_int64 (string attribute, int64 attr_value);
		public void set_attribute_mask (GLib.FileAttributeMatcher mask);
		public void set_attribute_object (string attribute, GLib.Object attr_value);
		public void set_attribute_string (string attribute, string attr_value);
		public void set_attribute_uint32 (string attribute, uint32 attr_value);
		public void set_attribute_uint64 (string attribute, uint64 attr_value);
		public void set_content_type (string content_type);
		public void set_display_name (string display_name);
		public void set_edit_name (string edit_name);
		public void set_file_type (GLib.FileType type);
		public void set_icon (GLib.Icon icon);
		public void set_is_hidden (bool is_hidden);
		public void set_is_symlink (bool is_symlink);
		public void set_modification_time (GLib.TimeVal mtime);
		public void set_name (string name);
		public void set_size (int64 size);
		public void set_sort_order (int32 sort_order);
		public void set_symlink_target (string symlink_target);
		public void unset_attribute_mask ();
	}
	[Compact]
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileInfoClass {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileInputStream : GLib.InputStream, GLib.Seekable {
		[NoWrapper]
		public virtual bool can_seek ();
		public virtual unowned GLib.FileInfo query_info (string attributes, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void query_info_async (string attributes, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual unowned GLib.FileInfo query_info_finish (GLib.AsyncResult _result) throws GLib.Error;
		[NoWrapper]
		public virtual bool seek (int64 offset, GLib.SeekType type, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public virtual int64 tell ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileMonitor : GLib.Object {
		public virtual bool cancel ();
		public static unowned GLib.FileMonitor directory (GLib.File file, GLib.FileMonitorFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public void emit_event (GLib.File child, GLib.File other_file, GLib.FileMonitorEvent event_type);
		public static unowned GLib.FileMonitor file (GLib.File file, GLib.FileMonitorFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool is_cancelled ();
		public void set_rate_limit (int limit_msecs);
		[NoAccessorMethod]
		public bool cancelled { get; }
		[NoAccessorMethod]
		public int rate_limit { get; set; }
		public virtual signal void changed (GLib.File file, GLib.File? other_file, GLib.FileMonitorEvent event_type);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FileOutputStream : GLib.OutputStream, GLib.Seekable {
		[NoWrapper]
		public virtual bool can_seek ();
		[NoWrapper]
		public virtual bool can_truncate ();
		public virtual unowned string get_etag ();
		public virtual unowned GLib.FileInfo query_info (string attributes, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void query_info_async (string attributes, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual unowned GLib.FileInfo query_info_finish (GLib.AsyncResult _result) throws GLib.Error;
		[NoWrapper]
		public virtual bool seek (int64 offset, GLib.SeekType type, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public virtual int64 tell ();
		[NoWrapper]
		public virtual bool truncate_fn (int64 size, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FilenameCompleter : GLib.Object {
		public unowned string get_completion_suffix (string initial_text);
		public unowned string get_completions (string initial_text);
		[CCode (has_construct_function = false)]
		public FilenameCompleter ();
		public void set_dirs_only (bool dirs_only);
		public virtual signal void got_completion_data ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FilterInputStream : GLib.InputStream {
		public unowned GLib.InputStream get_base_stream ();
		public bool get_close_base_stream ();
		public void set_close_base_stream (bool close_base);
		public GLib.InputStream base_stream { get; construct; }
		public bool close_base_stream { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class FilterOutputStream : GLib.OutputStream {
		public unowned GLib.OutputStream get_base_stream ();
		public bool get_close_base_stream ();
		public void set_close_base_stream (bool close_base);
		public GLib.OutputStream base_stream { get; construct; }
		public bool close_base_stream { get; construct; }
	}
	[Compact]
	[CCode (cheader_filename = "gio/gio.h")]
	public class IOExtension {
		public unowned string get_name ();
		public int get_priority ();
		public GLib.Type get_type ();
		public unowned GLib.TypeClass ref_class ();
	}
	[Compact]
	[CCode (cheader_filename = "gio/gio.h")]
	public class IOExtensionPoint {
		public unowned GLib.IOExtension get_extension_by_name (string name);
		public unowned GLib.List get_extensions ();
		public GLib.Type get_required_type ();
		public static unowned GLib.IOExtension implement (string extension_point_name, GLib.Type type, string extension_name, int priority);
		public static unowned GLib.IOExtensionPoint lookup (string name);
		public static unowned GLib.IOExtensionPoint register (string name);
		public void set_required_type (GLib.Type type);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class IOModule : GLib.TypeModule, GLib.TypePlugin {
		public void load ();
		[CCode (has_construct_function = false)]
		public IOModule (string filename);
		public void unload ();
	}
	[Compact]
	[CCode (cheader_filename = "gio/gio.h")]
	public class IOModuleClass {
	}
	[Compact]
	[CCode (cheader_filename = "gio/gio.h")]
	public class IOSchedulerJob {
		public bool send_to_mainloop (GLib.SourceFunc func, GLib.DestroyNotify? notify);
		public void send_to_mainloop_async (GLib.SourceFunc func, GLib.DestroyNotify? notify);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class InetAddress : GLib.Object {
		[CCode (has_construct_function = false)]
		public InetAddress.any (GLib.SocketFamily family);
		[CCode (has_construct_function = false)]
		public InetAddress.from_bytes (uchar bytes, GLib.SocketFamily family);
		[CCode (has_construct_function = false)]
		public InetAddress.from_string (string str);
		public GLib.SocketFamily get_family ();
		public bool get_is_any ();
		public bool get_is_link_local ();
		public bool get_is_loopback ();
		public bool get_is_mc_global ();
		public bool get_is_mc_link_local ();
		public bool get_is_mc_node_local ();
		public bool get_is_mc_org_local ();
		public bool get_is_mc_site_local ();
		public bool get_is_multicast ();
		public bool get_is_site_local ();
		[CCode (has_construct_function = false)]
		public InetAddress.loopback (GLib.SocketFamily family);
		public virtual uchar to_bytes ();
		public virtual unowned string to_string ();
		[NoAccessorMethod]
		public void* bytes { get; construct; }
		public GLib.SocketFamily family { get; construct; }
		public bool is_any { get; }
		public bool is_link_local { get; }
		public bool is_loopback { get; }
		public bool is_mc_global { get; }
		public bool is_mc_link_local { get; }
		public bool is_mc_node_local { get; }
		public bool is_mc_org_local { get; }
		public bool is_mc_site_local { get; }
		public bool is_multicast { get; }
		public bool is_site_local { get; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class InetSocketAddress : GLib.SocketAddress, GLib.SocketConnectable {
		public unowned GLib.InetAddress get_address ();
		public uint16 get_port ();
		[CCode (type = "GSocketAddress*", has_construct_function = false)]
		public InetSocketAddress (GLib.InetAddress address, uint16 port);
		public GLib.InetAddress address { get; construct; }
		public uint port { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class InputStream : GLib.Object {
		public void clear_pending ();
		public bool close (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void close_async (int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual bool close_finish (GLib.AsyncResult _result) throws GLib.Error;
		[NoWrapper]
		public virtual bool close_fn (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool has_pending ();
		public bool is_closed ();
		public ssize_t read (void* buffer, size_t count, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool read_all (void* buffer, size_t count, out size_t bytes_read, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void read_async (void* buffer, size_t count, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual ssize_t read_finish (GLib.AsyncResult _result) throws GLib.Error;
		[NoWrapper]
		public virtual ssize_t read_fn (void* buffer, size_t count, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_pending () throws GLib.Error;
		public virtual ssize_t skip (size_t count, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void skip_async (size_t count, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual ssize_t skip_finish (GLib.AsyncResult _result) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class MemoryInputStream : GLib.InputStream, GLib.Seekable {
		public void add_data (void* data, ssize_t len, GLib.DestroyNotify? destroy);
		[CCode (type = "GInputStream*", has_construct_function = false)]
		public MemoryInputStream.from_data (void* data, ssize_t len, GLib.DestroyNotify? destroy);
		[CCode (type = "GInputStream*", has_construct_function = false)]
		public MemoryInputStream ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class MemoryOutputStream : GLib.OutputStream, GLib.Seekable {
		public void* get_data ();
		public size_t get_data_size ();
		public size_t get_size ();
		[CCode (type = "GOutputStream*", has_construct_function = false)]
		public MemoryOutputStream (void* data, size_t len, GLib.ReallocFunc realloc_fn, GLib.DestroyNotify? destroy);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class MountOperation : GLib.Object {
		public bool get_anonymous ();
		public int get_choice ();
		public unowned string get_domain ();
		public unowned string get_password ();
		public GLib.PasswordSave get_password_save ();
		public unowned string get_username ();
		[CCode (has_construct_function = false)]
		public MountOperation ();
		public void set_anonymous (bool anonymous);
		public void set_choice (int choice);
		public void set_domain (string domain);
		public void set_password (string password);
		public void set_password_save (GLib.PasswordSave save);
		public void set_username (string username);
		public bool anonymous { get; set; }
		public int choice { get; set; }
		public string domain { get; set; }
		public string password { get; set; }
		public GLib.PasswordSave password_save { get; set; }
		public string username { get; set; }
		public virtual signal void aborted ();
		public virtual signal void ask_password (string message, string default_user, string default_domain, GLib.AskPasswordFlags flags);
		public virtual signal void ask_question (string message, string[] choices);
		[HasEmitter]
		public virtual signal void reply (GLib.MountOperationResult result);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class NativeVolumeMonitor : GLib.VolumeMonitor {
		[NoWrapper]
		public virtual unowned GLib.Mount get_mount_for_mount_path (string mount_path, GLib.Cancellable? cancellable);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class NetworkAddress : GLib.Object, GLib.SocketConnectable {
		public unowned string get_hostname ();
		public uint16 get_port ();
		[CCode (type = "GSocketConnectable*", has_construct_function = false)]
		public NetworkAddress (string hostname, uint16 port);
		public string hostname { get; construct; }
		public uint port { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class NetworkService : GLib.Object, GLib.SocketConnectable {
		public unowned string get_domain ();
		public unowned string get_protocol ();
		public unowned string get_service ();
		[CCode (type = "GSocketConnectable*", has_construct_function = false)]
		public NetworkService (string service, string protocol, string domain);
		public string domain { get; construct; }
		public string protocol { get; construct; }
		public string service { get; construct; }
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class OutputStream : GLib.Object {
		public void clear_pending ();
		public bool close (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void close_async (int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual bool close_finish (GLib.AsyncResult _result) throws GLib.Error;
		[NoWrapper]
		public virtual bool close_fn (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual bool flush (GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void flush_async (int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual bool flush_finish (GLib.AsyncResult _result) throws GLib.Error;
		public bool has_pending ();
		public bool is_closed ();
		public bool set_pending () throws GLib.Error;
		public virtual ssize_t splice (GLib.InputStream source, GLib.OutputStreamSpliceFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void splice_async (GLib.InputStream source, GLib.OutputStreamSpliceFlags flags, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual ssize_t splice_finish (GLib.AsyncResult _result) throws GLib.Error;
		public ssize_t write (void* buffer, size_t count, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool write_all (void* buffer, size_t count, out size_t bytes_written, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void write_async (void* buffer, size_t count, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual ssize_t write_finish (GLib.AsyncResult _result) throws GLib.Error;
		[NoWrapper]
		public virtual ssize_t write_fn (void* buffer, size_t count, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class Resolver : GLib.Object {
		public static GLib.Quark error_quark ();
		public static void free_addresses (GLib.List addresses);
		public static void free_targets (GLib.List targets);
		public static unowned GLib.Resolver get_default ();
		public virtual unowned string lookup_by_address (GLib.InetAddress address, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void lookup_by_address_async (GLib.InetAddress address, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual unowned string lookup_by_address_finish (GLib.AsyncResult _result) throws GLib.Error;
		public virtual unowned GLib.List lookup_by_name (string hostname, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void lookup_by_name_async (string hostname, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual unowned GLib.List lookup_by_name_finish (GLib.AsyncResult _result) throws GLib.Error;
		public virtual unowned GLib.List lookup_service (string service, string protocol, string domain, GLib.Cancellable? cancellable) throws GLib.Error;
		public virtual void lookup_service_async (string service, string protocol, string domain, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public virtual unowned GLib.List lookup_service_finish (GLib.AsyncResult _result) throws GLib.Error;
		public void set_default ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SimpleAsyncResult : GLib.Object, GLib.AsyncResult {
		public void complete ();
		public void complete_in_idle ();
		[CCode (has_construct_function = false)]
		public SimpleAsyncResult.error (GLib.Object source_object, GLib.AsyncReadyCallback callback, GLib.Quark domain, int code, string format);
		[CCode (has_construct_function = false)]
		public SimpleAsyncResult.from_error (GLib.Object source_object, GLib.AsyncReadyCallback callback, GLib.Error error);
		public bool get_op_res_gboolean ();
		public void* get_op_res_gpointer ();
		public ssize_t get_op_res_gssize ();
		public void* get_source_tag ();
		public static bool is_valid (GLib.AsyncResult _result, GLib.Object source, void* source_tag);
		[CCode (has_construct_function = false)]
		public SimpleAsyncResult (GLib.Object source_object, GLib.AsyncReadyCallback callback, void* source_tag);
		public bool propagate_error () throws GLib.Error;
		public void run_in_thread (GLib.SimpleAsyncThreadFunc func, int io_priority, GLib.Cancellable? cancellable);
		public void set_error (GLib.Quark domain, int code, string format);
		public void set_error_va (GLib.Quark domain, int code, string format, void* args);
		public void set_from_error (GLib.Error error);
		public void set_handle_cancellation (bool handle_cancellation);
		public void set_op_res_gboolean (bool op_res);
		public void set_op_res_gpointer (void* op_res, GLib.DestroyNotify destroy_op_res);
		public void set_op_res_gssize (ssize_t op_res);
	}
	[Compact]
	[CCode (cheader_filename = "gio/gio.h")]
	public class SimpleAsyncResultClass {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class SocketAddress : GLib.Object, GLib.SocketConnectable {
		[CCode (has_construct_function = false)]
		public SocketAddress.from_native (void* native, size_t len);
		public virtual GLib.SocketFamily get_family ();
		public virtual ssize_t get_native_size ();
		public virtual bool to_native (void* dest, size_t destlen);
		public GLib.SocketFamily family { get; }
	}
	[Compact]
	[CCode (copy_function = "g_srv_target_copy", type_id = "G_TYPE_SRV_TARGET", cheader_filename = "gio/gio.h")]
	public class SrvTarget {
		public unowned GLib.SrvTarget copy ();
		public ulong get_expires ();
		public unowned string get_hostname ();
		public uint16 get_port ();
		public uint16 get_priority ();
		public uint16 get_weight ();
		public static unowned GLib.List list_sort (GLib.List targets);
		[CCode (has_construct_function = false)]
		public SrvTarget (string hostname, uint16 port, uint16 priority, uint16 weight, ulong expires);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class ThemedIcon : GLib.Object, GLib.Icon {
		public void append_name (string iconname);
		[CCode (type = "GIcon*", has_construct_function = false)]
		public ThemedIcon.from_names (string[] iconnames);
		[CCode (array_length = false)]
		public unowned string[] get_names ();
		[CCode (type = "GIcon*", has_construct_function = false)]
		public ThemedIcon (string iconname);
		public void prepend_name (string iconname);
		[CCode (type = "GIcon*", has_construct_function = false)]
		public ThemedIcon.with_default_fallbacks (string iconname);
		public string name { construct; }
		public string[] names { get; construct; }
		[NoAccessorMethod]
		public bool use_default_fallbacks { get; construct; }
	}
	[Compact]
	[CCode (cheader_filename = "gio/gio.h")]
	public class ThemedIconClass {
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class Vfs : GLib.Object {
		public static unowned GLib.Vfs get_default ();
		public virtual unowned GLib.File get_file_for_path (string path);
		public virtual unowned GLib.File get_file_for_uri (string uri);
		public static unowned GLib.Vfs get_local ();
		public virtual unowned string get_supported_uri_schemes ();
		public virtual bool is_active ();
		public virtual unowned GLib.File parse_name (string parse_name);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public class VolumeMonitor : GLib.Object {
		public virtual unowned GLib.Volume adopt_orphan_mount (GLib.Mount mount);
		public static unowned GLib.VolumeMonitor get ();
		public virtual unowned GLib.List get_connected_drives ();
		public virtual unowned GLib.Mount get_mount_for_uuid (string uuid);
		public virtual unowned GLib.List get_mounts ();
		public virtual unowned GLib.Volume get_volume_for_uuid (string uuid);
		public virtual unowned GLib.List get_volumes ();
		[NoWrapper]
		public virtual bool is_supported ();
		public virtual signal void drive_changed (GLib.Drive drive);
		public virtual signal void drive_connected (GLib.Drive drive);
		public virtual signal void drive_disconnected (GLib.Drive drive);
		public virtual signal void drive_eject_button (GLib.Drive drive);
		public virtual signal void mount_added (GLib.Mount mount);
		public virtual signal void mount_changed (GLib.Mount mount);
		public virtual signal void mount_pre_unmount (GLib.Mount mount);
		public virtual signal void mount_removed (GLib.Mount mount);
		public virtual signal void volume_added (GLib.Volume volume);
		public virtual signal void volume_changed (GLib.Volume volume);
		public virtual signal void volume_removed (GLib.Volume volume);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface AppInfo : GLib.Object {
		public abstract bool add_supports_type (string content_type) throws GLib.Error;
		public abstract bool can_delete ();
		public abstract bool can_remove_supports_type ();
		public static unowned GLib.AppInfo create_from_commandline (string commandline, string application_name, GLib.AppInfoCreateFlags flags) throws GLib.Error;
		public bool @delete ();
		[NoWrapper]
		public abstract bool do_delete ();
		public abstract unowned GLib.AppInfo dup ();
		public abstract bool equal (GLib.AppInfo appinfo2);
		public static unowned GLib.List get_all ();
		public static unowned GLib.List get_all_for_type (string content_type);
		public abstract unowned string get_commandline ();
		public static unowned GLib.AppInfo get_default_for_type (string content_type, bool must_support_uris);
		public static unowned GLib.AppInfo get_default_for_uri_scheme (string uri_scheme);
		public abstract unowned string get_description ();
		public abstract unowned string get_executable ();
		public abstract unowned GLib.Icon get_icon ();
		public abstract unowned string get_id ();
		public abstract unowned string get_name ();
		public abstract bool launch (GLib.List? files, GLib.AppLaunchContext launch_context) throws GLib.Error;
		public static bool launch_default_for_uri (string uri, GLib.AppLaunchContext? launch_context) throws GLib.Error;
		public abstract bool launch_uris (GLib.List? uris, GLib.AppLaunchContext launch_context) throws GLib.Error;
		public abstract bool remove_supports_type (string content_type) throws GLib.Error;
		public static void reset_type_associations (string content_type);
		public abstract bool set_as_default_for_extension (string extension) throws GLib.Error;
		public abstract bool set_as_default_for_type (string content_type) throws GLib.Error;
		public abstract bool should_show ();
		public abstract bool supports_files ();
		public abstract bool supports_uris ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface AsyncResult : GLib.Object {
		public abstract unowned GLib.Object get_source_object ();
		public abstract void* get_user_data ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Drive : GLib.Object {
		public abstract bool can_eject ();
		public abstract bool can_poll_for_media ();
		public abstract void eject (GLib.MountUnmountFlags flags, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback? callback);
		public abstract bool eject_finish (GLib.AsyncResult _result) throws GLib.Error;
		public abstract unowned string enumerate_identifiers ();
		public abstract unowned GLib.Icon get_icon ();
		public abstract unowned string get_identifier (string kind);
		public abstract unowned string get_name ();
		public abstract unowned GLib.List get_volumes ();
		public abstract bool has_media ();
		public abstract bool has_volumes ();
		public abstract bool is_media_check_automatic ();
		public abstract bool is_media_removable ();
		public abstract void poll_for_media (GLib.Cancellable? cancellable, GLib.AsyncReadyCallback? callback);
		public abstract bool poll_for_media_finish (GLib.AsyncResult _result) throws GLib.Error;
		public virtual signal void changed ();
		public virtual signal void disconnected ();
		public virtual signal void eject_button ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface File : GLib.Object {
		public abstract GLib.FileOutputStream append_to (GLib.FileCreateFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void append_to_async (GLib.FileCreateFlags flags, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract GLib.FileOutputStream append_to_finish (GLib.AsyncResult res) throws GLib.Error;
		public abstract bool copy (GLib.File destination, GLib.FileCopyFlags flags, GLib.Cancellable? cancellable, GLib.FileProgressCallback? progress_callback) throws GLib.Error;
		public abstract void copy_async (GLib.File destination, GLib.FileCopyFlags flags, int io_priority, GLib.Cancellable? cancellable, GLib.FileProgressCallback? progress_callback, GLib.AsyncReadyCallback callback);
		public bool copy_attributes (GLib.File destination, GLib.FileCopyFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract bool copy_finish (GLib.AsyncResult res) throws GLib.Error;
		public abstract GLib.FileOutputStream create (GLib.FileCreateFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void create_async (GLib.FileCreateFlags flags, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract GLib.FileOutputStream create_finish (GLib.AsyncResult res) throws GLib.Error;
		public bool @delete (GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public abstract bool delete_file (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract unowned GLib.File dup ();
		public abstract void eject_mountable (GLib.MountUnmountFlags flags, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback? callback);
		public abstract bool eject_mountable_finish (GLib.AsyncResult _result) throws GLib.Error;
		public abstract GLib.FileEnumerator enumerate_children (string attributes, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void enumerate_children_async (string attributes, GLib.FileQueryInfoFlags flags, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract GLib.FileEnumerator enumerate_children_finish (GLib.AsyncResult res) throws GLib.Error;
		public abstract bool equal (GLib.File file2);
		public abstract GLib.Mount find_enclosing_mount (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void find_enclosing_mount_async (int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract GLib.Mount find_enclosing_mount_finish (GLib.AsyncResult res) throws GLib.Error;
		public abstract string? get_basename ();
		public GLib.File get_child (string name);
		public abstract GLib.File get_child_for_display_name (string display_name) throws GLib.Error;
		public abstract GLib.File? get_parent ();
		public abstract string get_parse_name ();
		public abstract string? get_path ();
		public abstract string? get_relative_path (GLib.File descendant);
		public abstract string get_uri ();
		public abstract string get_uri_scheme ();
		public bool has_prefix (GLib.File prefix);
		public abstract bool has_uri_scheme (string uri_scheme);
		public abstract uint hash (void* file);
		public abstract bool is_native ();
		public bool load_contents (GLib.Cancellable? cancellable, out string contents, out size_t length, out string etag_out) throws GLib.Error;
		public void load_contents_async (GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public bool load_contents_finish (GLib.AsyncResult res, out string contents, out size_t length, out string etag_out) throws GLib.Error;
		public void load_partial_contents_async (GLib.Cancellable? cancellable, GLib.FileReadMoreCallback read_more_callback, GLib.AsyncReadyCallback callback);
		public bool load_partial_contents_finish (GLib.AsyncResult res, out string contents, out size_t length, out string etag_out) throws GLib.Error;
		public abstract bool make_directory (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool make_directory_with_parents (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract bool make_symbolic_link (string symlink_value, GLib.Cancellable? cancellable) throws GLib.Error;
		public unowned GLib.FileMonitor monitor (GLib.FileMonitorFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public abstract unowned GLib.FileMonitor monitor_dir (GLib.FileMonitorFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		[NoWrapper]
		public abstract unowned GLib.FileMonitor monitor_file (GLib.FileMonitorFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void mount_enclosing_volume (GLib.MountMountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback? callback);
		public abstract bool mount_enclosing_volume_finish (GLib.AsyncResult _result) throws GLib.Error;
		public abstract void mount_mountable (GLib.MountMountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback? callback);
		public abstract unowned GLib.File mount_mountable_finish (GLib.AsyncResult _result) throws GLib.Error;
		public abstract bool move (GLib.File destination, GLib.FileCopyFlags flags, GLib.Cancellable? cancellable, GLib.FileProgressCallback? progress_callback) throws GLib.Error;
		public static GLib.File new_for_commandline_arg (string arg);
		public static GLib.File new_for_path (string path);
		public static GLib.File new_for_uri (string uri);
		public static unowned GLib.File parse_name (string parse_name);
		[NoWrapper]
		public abstract bool prefix_matches (GLib.File file);
		public GLib.AppInfo query_default_handler (GLib.Cancellable? cancellable) throws GLib.Error;
		public bool query_exists (GLib.Cancellable? cancellable);
		public GLib.FileType query_file_type (GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable);
		public abstract unowned GLib.FileInfo query_filesystem_info (string attributes, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void query_filesystem_info_async (string attributes, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract unowned GLib.FileInfo query_filesystem_info_finish (GLib.AsyncResult res) throws GLib.Error;
		public abstract GLib.FileInfo query_info (string attributes, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void query_info_async (string attributes, GLib.FileQueryInfoFlags flags, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract GLib.FileInfo query_info_finish (GLib.AsyncResult res) throws GLib.Error;
		public abstract unowned GLib.FileAttributeInfoList query_settable_attributes (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract unowned GLib.FileAttributeInfoList query_writable_namespaces (GLib.Cancellable? cancellable) throws GLib.Error;
		public GLib.FileInputStream read (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void read_async (int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract GLib.FileInputStream read_finish (GLib.AsyncResult res) throws GLib.Error;
		[NoWrapper]
		public abstract unowned GLib.FileInputStream read_fn (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract GLib.FileOutputStream replace (string? etag, bool make_backup, GLib.FileCreateFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void replace_async (string? etag, bool make_backup, GLib.FileCreateFlags flags, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public bool replace_contents (string contents, size_t length, string? etag, bool make_backup, GLib.FileCreateFlags flags, out unowned string new_etag, GLib.Cancellable? cancellable) throws GLib.Error;
		public void replace_contents_async (string contents, size_t length, string? etag, bool make_backup, GLib.FileCreateFlags flags, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public bool replace_contents_finish (GLib.AsyncResult res, out unowned string new_etag) throws GLib.Error;
		public abstract GLib.FileOutputStream replace_finish (GLib.AsyncResult res) throws GLib.Error;
		public abstract GLib.File resolve_relative_path (string relative_path);
		public abstract bool set_attribute (string attribute, GLib.FileAttributeType type, void* value_p, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_attribute_byte_string (string attribute, string value, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_attribute_int32 (string attribute, int32 value, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_attribute_int64 (string attribute, int64 value, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_attribute_string (string attribute, string value, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_attribute_uint32 (string attribute, uint32 value, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool set_attribute_uint64 (string attribute, uint64 value, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void set_attributes_async (GLib.FileInfo info, GLib.FileQueryInfoFlags flags, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract bool set_attributes_finish (GLib.AsyncResult _result, out unowned GLib.FileInfo info) throws GLib.Error;
		public abstract bool set_attributes_from_info (GLib.FileInfo info, GLib.FileQueryInfoFlags flags, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract unowned GLib.File set_display_name (string display_name, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void set_display_name_async (string display_name, int io_priority, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract unowned GLib.File set_display_name_finish (GLib.AsyncResult res) throws GLib.Error;
		public abstract bool trash (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void unmount_mountable (GLib.MountUnmountFlags flags, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback? callback);
		public abstract bool unmount_mountable_finish (GLib.AsyncResult _result) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Icon : GLib.Object {
		public abstract bool equal (GLib.Icon icon2);
		[NoWrapper]
		public abstract unowned GLib.Icon from_tokens (string tokens, int num_tokens, int version) throws GLib.Error;
		public abstract uint hash (void* icon);
		public static unowned GLib.Icon new_for_string (string str) throws GLib.Error;
		public unowned string to_string ();
		[NoWrapper]
		public abstract bool to_tokens (GLib.PtrArray tokens, int out_version);
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface LoadableIcon : GLib.Icon, GLib.Object {
		public abstract unowned GLib.InputStream load (int size, out unowned string? type, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void load_async (int size, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract unowned GLib.InputStream load_finish (GLib.AsyncResult res, out unowned string? type) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Mount : GLib.Object {
		public abstract bool can_eject ();
		public abstract bool can_unmount ();
		public abstract void eject (GLib.MountUnmountFlags flags, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback? callback);
		public abstract bool eject_finish (GLib.AsyncResult _result) throws GLib.Error;
		public abstract unowned GLib.Drive get_drive ();
		public abstract unowned GLib.Icon get_icon ();
		public abstract unowned string get_name ();
		public abstract unowned GLib.File get_root ();
		public abstract unowned string get_uuid ();
		public abstract unowned GLib.Volume get_volume ();
		public abstract void guess_content_type (bool force_rescan, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract unowned string guess_content_type_finish (GLib.AsyncResult _result) throws GLib.Error;
		public abstract unowned string guess_content_type_sync (bool force_rescan, GLib.Cancellable? cancellable) throws GLib.Error;
		public bool is_shadowed ();
		public abstract void remount (GLib.MountMountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback? callback);
		public abstract bool remount_finish (GLib.AsyncResult _result) throws GLib.Error;
		public void shadow ();
		public abstract void unmount (GLib.MountUnmountFlags flags, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback? callback);
		public abstract bool unmount_finish (GLib.AsyncResult _result) throws GLib.Error;
		public void unshadow ();
		public virtual signal void changed ();
		public virtual signal void unmounted ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Seekable : GLib.Object {
		public abstract bool can_seek ();
		public abstract bool can_truncate ();
		public abstract bool seek (int64 offset, GLib.SeekType type, GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract int64 tell ();
		[CCode (vfunc_name = "truncate_fn")]
		public abstract bool truncate (int64 offset, GLib.Cancellable? cancellable) throws GLib.Error;
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface SocketConnectable : GLib.Object {
		public abstract unowned GLib.SocketAddress get_next (GLib.Cancellable? cancellable) throws GLib.Error;
		public abstract void get_next_async (GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract unowned GLib.SocketAddress get_next_finish (GLib.AsyncResult _result) throws GLib.Error;
		public abstract void reset ();
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public interface Volume : GLib.Object {
		public abstract bool can_eject ();
		public abstract bool can_mount ();
		public abstract void eject (GLib.MountUnmountFlags flags, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback? callback);
		public abstract bool eject_finish (GLib.AsyncResult _result) throws GLib.Error;
		public abstract unowned string enumerate_identifiers ();
		public abstract unowned GLib.File get_activation_root ();
		public abstract unowned GLib.Drive get_drive ();
		public abstract unowned GLib.Icon get_icon ();
		public abstract unowned string get_identifier (string kind);
		public abstract unowned GLib.Mount get_mount ();
		public abstract unowned string get_name ();
		public abstract unowned string get_uuid ();
		public void mount (GLib.MountMountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback? callback);
		public abstract bool mount_finish (GLib.AsyncResult _result) throws GLib.Error;
		[NoWrapper]
		public abstract void mount_fn (GLib.MountMountFlags flags, GLib.MountOperation? mount_operation, GLib.Cancellable? cancellable, GLib.AsyncReadyCallback callback);
		public abstract bool should_automount ();
		public virtual signal void changed ();
		public virtual signal void removed ();
	}
	[CCode (cprefix = "G_APP_INFO_CREATE_", cheader_filename = "gio/gio.h")]
	[Flags]
	public enum AppInfoCreateFlags {
		NONE,
		NEEDS_TERMINAL,
		SUPPORTS_URIS
	}
	[CCode (cprefix = "G_ASK_PASSWORD_", cheader_filename = "gio/gio.h")]
	[Flags]
	public enum AskPasswordFlags {
		NEED_PASSWORD,
		NEED_USERNAME,
		NEED_DOMAIN,
		SAVING_SUPPORTED,
		ANONYMOUS_SUPPORTED
	}
	[CCode (cprefix = "G_DATA_STREAM_BYTE_ORDER_", cheader_filename = "gio/gio.h")]
	public enum DataStreamByteOrder {
		BIG_ENDIAN,
		LITTLE_ENDIAN,
		HOST_ENDIAN
	}
	[CCode (cprefix = "G_DATA_STREAM_NEWLINE_TYPE_", cheader_filename = "gio/gio.h")]
	public enum DataStreamNewlineType {
		LF,
		CR,
		CR_LF,
		ANY
	}
	[CCode (cprefix = "G_EMBLEM_ORIGIN_", cheader_filename = "gio/gio.h")]
	public enum EmblemOrigin {
		UNKNOWN,
		DEVICE,
		LIVEMETADATA,
		TAG
	}
	[CCode (cprefix = "G_FILE_ATTRIBUTE_INFO_", cheader_filename = "gio/gio.h")]
	[Flags]
	public enum FileAttributeInfoFlags {
		NONE,
		COPY_WITH_FILE,
		COPY_WHEN_MOVED
	}
	[CCode (cprefix = "G_FILE_ATTRIBUTE_STATUS_", cheader_filename = "gio/gio.h")]
	public enum FileAttributeStatus {
		UNSET,
		SET,
		ERROR_SETTING
	}
	[CCode (cprefix = "G_FILE_ATTRIBUTE_TYPE_", cheader_filename = "gio/gio.h")]
	public enum FileAttributeType {
		INVALID,
		STRING,
		BYTE_STRING,
		BOOLEAN,
		UINT32,
		INT32,
		UINT64,
		INT64,
		OBJECT
	}
	[CCode (cprefix = "G_FILE_COPY_", cheader_filename = "gio/gio.h")]
	[Flags]
	public enum FileCopyFlags {
		NONE,
		OVERWRITE,
		BACKUP,
		NOFOLLOW_SYMLINKS,
		ALL_METADATA,
		NO_FALLBACK_FOR_MOVE,
		TARGET_DEFAULT_PERMS
	}
	[CCode (cprefix = "G_FILE_CREATE_", cheader_filename = "gio/gio.h")]
	[Flags]
	public enum FileCreateFlags {
		NONE,
		PRIVATE,
		REPLACE_DESTINATION
	}
	[CCode (cprefix = "G_FILE_MONITOR_EVENT_", cheader_filename = "gio/gio.h")]
	public enum FileMonitorEvent {
		CHANGED,
		CHANGES_DONE_HINT,
		DELETED,
		CREATED,
		ATTRIBUTE_CHANGED,
		PRE_UNMOUNT,
		UNMOUNTED
	}
	[CCode (cprefix = "G_FILE_MONITOR_", cheader_filename = "gio/gio.h")]
	[Flags]
	public enum FileMonitorFlags {
		NONE,
		WATCH_MOUNTS
	}
	[CCode (cprefix = "G_FILE_QUERY_INFO_", cheader_filename = "gio/gio.h")]
	[Flags]
	public enum FileQueryInfoFlags {
		NONE,
		NOFOLLOW_SYMLINKS
	}
	[CCode (cprefix = "G_FILE_TYPE_", cheader_filename = "gio/gio.h")]
	public enum FileType {
		UNKNOWN,
		REGULAR,
		DIRECTORY,
		SYMBOLIC_LINK,
		SPECIAL,
		SHORTCUT,
		MOUNTABLE
	}
	[CCode (cprefix = "G_FILESYSTEM_PREVIEW_TYPE_", cheader_filename = "gio/gio.h")]
	public enum FilesystemPreviewType {
		IF_ALWAYS,
		IF_LOCAL,
		NEVER
	}
	[CCode (cprefix = "G_MOUNT_MOUNT_", cheader_filename = "gio/gio.h")]
	public enum MountMountFlags {
		NONE
	}
	[CCode (cprefix = "G_MOUNT_OPERATION_", cheader_filename = "gio/gio.h")]
	public enum MountOperationResult {
		HANDLED,
		ABORTED,
		UNHANDLED
	}
	[CCode (cprefix = "G_MOUNT_UNMOUNT_", cheader_filename = "gio/gio.h")]
	[Flags]
	public enum MountUnmountFlags {
		NONE,
		FORCE
	}
	[CCode (cprefix = "G_OUTPUT_STREAM_SPLICE_", cheader_filename = "gio/gio.h")]
	[Flags]
	public enum OutputStreamSpliceFlags {
		NONE,
		CLOSE_SOURCE,
		CLOSE_TARGET
	}
	[CCode (cprefix = "G_PASSWORD_SAVE_", cheader_filename = "gio/gio.h")]
	public enum PasswordSave {
		NEVER,
		FOR_SESSION,
		PERMANENTLY
	}
	[CCode (cprefix = "G_RESOLVER_ERROR_", cheader_filename = "gio/gio.h")]
	public enum ResolverError {
		NOT_FOUND,
		TEMPORARY_FAILURE,
		INTERNAL
	}
	[CCode (cprefix = "G_SOCKET_FAMILY_", cheader_filename = "gio/gio.h")]
	public enum SocketFamily {
		INVALID,
		IPV4,
		IPV6,
		UNIX
	}
	[CCode (cprefix = "G_IO_ERROR_", cheader_filename = "gio/gio.h")]
	public errordomain IOError {
		FAILED,
		NOT_FOUND,
		EXISTS,
		IS_DIRECTORY,
		NOT_DIRECTORY,
		NOT_EMPTY,
		NOT_REGULAR_FILE,
		NOT_SYMBOLIC_LINK,
		NOT_MOUNTABLE_FILE,
		FILENAME_TOO_LONG,
		INVALID_FILENAME,
		TOO_MANY_LINKS,
		NO_SPACE,
		INVALID_ARGUMENT,
		PERMISSION_DENIED,
		NOT_SUPPORTED,
		NOT_MOUNTED,
		ALREADY_MOUNTED,
		CLOSED,
		CANCELLED,
		PENDING,
		READ_ONLY,
		CANT_CREATE_BACKUP,
		WRONG_ETAG,
		TIMED_OUT,
		WOULD_RECURSE,
		BUSY,
		WOULD_BLOCK,
		HOST_NOT_FOUND,
		WOULD_MERGE,
		FAILED_HANDLED,
		TOO_MANY_OPEN_FILES,
	}
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate void AsyncReadyCallback (GLib.Object source_object, GLib.AsyncResult res);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate void FileProgressCallback (int64 current_num_bytes, int64 total_num_bytes);
	[CCode (cheader_filename = "gio/gio.h")]
	public static delegate bool FileReadMoreCallback (string file_contents, int64 file_size, void* callback_data);
	[CCode (cheader_filename = "gio/gio.h")]
	public delegate bool IOSchedulerJobFunc (GLib.IOSchedulerJob job, GLib.Cancellable cancellable);
	[CCode (cheader_filename = "gio/gio.h")]
	public static delegate void* ReallocFunc (void* data, size_t size);
	[CCode (cheader_filename = "gio/gio.h")]
	public static delegate void SimpleAsyncThreadFunc (GLib.SimpleAsyncResult res, GLib.Object object, GLib.Cancellable cancellable);
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ACCESS_CAN_DELETE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ACCESS_CAN_EXECUTE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ACCESS_CAN_READ;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ACCESS_CAN_RENAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ACCESS_CAN_TRASH;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ACCESS_CAN_WRITE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_DOS_IS_ARCHIVE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_DOS_IS_SYSTEM;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ETAG_VALUE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_FILESYSTEM_FREE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_FILESYSTEM_READONLY;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_FILESYSTEM_SIZE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_FILESYSTEM_TYPE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_FILESYSTEM_USE_PREVIEW;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_GVFS_BACKEND;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ID_FILE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_ID_FILESYSTEM;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_CAN_EJECT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_CAN_MOUNT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_CAN_UNMOUNT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_HAL_UDI;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_MOUNTABLE_UNIX_DEVICE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_OWNER_GROUP;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_OWNER_USER;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_OWNER_USER_REAL;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_PREVIEW_ICON;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_SELINUX_CONTEXT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_ALLOCATED_SIZE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_COPY_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_DESCRIPTION;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_EDIT_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_FAST_CONTENT_TYPE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_ICON;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_IS_BACKUP;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_IS_HIDDEN;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_IS_SYMLINK;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_IS_VIRTUAL;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_SIZE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_SORT_ORDER;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_SYMLINK_TARGET;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_TARGET_URI;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_STANDARD_TYPE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_THUMBNAILING_FAILED;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_THUMBNAIL_PATH;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_ACCESS;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_ACCESS_USEC;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_CHANGED;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_CHANGED_USEC;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_CREATED;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_CREATED_USEC;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_MODIFIED;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TIME_MODIFIED_USEC;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_TRASH_ITEM_COUNT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_BLOCKS;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_BLOCK_SIZE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_DEVICE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_GID;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_INODE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_IS_MOUNTPOINT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_MODE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_NLINK;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_RDEV;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string FILE_ATTRIBUTE_UNIX_UID;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string NATIVE_VOLUME_MONITOR_EXTENSION_POINT_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VFS_EXTENSION_POINT_NAME;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VOLUME_IDENTIFIER_KIND_HAL_UDI;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VOLUME_IDENTIFIER_KIND_LABEL;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VOLUME_IDENTIFIER_KIND_NFS_MOUNT;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VOLUME_IDENTIFIER_KIND_UNIX_DEVICE;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VOLUME_IDENTIFIER_KIND_UUID;
	[CCode (cheader_filename = "gio/gio.h")]
	public const string VOLUME_MONITOR_EXTENSION_POINT_NAME;
	[CCode (cname = "g_content_type_can_be_executable", cheader_filename = "gio/gio.h")]
	public static bool g_content_type_can_be_executable (string type);
	[CCode (cname = "g_content_type_equals", cheader_filename = "gio/gio.h")]
	public static bool g_content_type_equals (string type1, string type2);
	[CCode (cname = "g_content_type_from_mime_type", cheader_filename = "gio/gio.h")]
	public static unowned string g_content_type_from_mime_type (string mime_type);
	[CCode (cname = "g_content_type_get_description", cheader_filename = "gio/gio.h")]
	public static unowned string g_content_type_get_description (string type);
	[CCode (cname = "g_content_type_get_icon", cheader_filename = "gio/gio.h")]
	public static unowned GLib.Icon g_content_type_get_icon (string type);
	[CCode (cname = "g_content_type_get_mime_type", cheader_filename = "gio/gio.h")]
	public static unowned string g_content_type_get_mime_type (string type);
	[CCode (cname = "g_content_type_guess", cheader_filename = "gio/gio.h")]
	public static unowned string g_content_type_guess (string filename, uchar[] data, out bool result_uncertain);
	[CCode (cname = "g_content_type_guess_for_tree", cheader_filename = "gio/gio.h")]
	public static unowned string g_content_type_guess_for_tree (GLib.File root);
	[CCode (cname = "g_content_type_is_a", cheader_filename = "gio/gio.h")]
	public static bool g_content_type_is_a (string type, string supertype);
	[CCode (cname = "g_content_type_is_unknown", cheader_filename = "gio/gio.h")]
	public static bool g_content_type_is_unknown (string type);
	[CCode (cname = "g_content_types_get_registered", cheader_filename = "gio/gio.h")]
	public static unowned GLib.List g_content_types_get_registered ();
	[CCode (cname = "g_io_error_from_errno", cheader_filename = "gio/gio.h")]
	public static unowned GLib.IOError g_io_error_from_errno (int err_no);
	[CCode (cname = "g_io_error_quark", cheader_filename = "gio/gio.h")]
	public static GLib.Quark g_io_error_quark ();
	[CCode (cname = "g_io_modules_load_all_in_directory", cheader_filename = "gio/gio.h")]
	public static unowned GLib.List g_io_modules_load_all_in_directory (string dirname);
	[CCode (cname = "g_io_scheduler_cancel_all_jobs", cheader_filename = "gio/gio.h")]
	public static void g_io_scheduler_cancel_all_jobs ();
	[CCode (cname = "g_io_scheduler_push_job", cheader_filename = "gio/gio.h")]
	public static void g_io_scheduler_push_job (GLib.IOSchedulerJobFunc job_func, GLib.DestroyNotify? notify, int io_priority, GLib.Cancellable? cancellable);
	[CCode (cname = "g_simple_async_report_error_in_idle", cheader_filename = "gio/gio.h")]
	public static void g_simple_async_report_error_in_idle (GLib.Object object, GLib.AsyncReadyCallback callback, GLib.Quark domain, int code, string format);
	[CCode (cname = "g_simple_async_report_gerror_in_idle", cheader_filename = "gio/gio.h")]
	public static void g_simple_async_report_gerror_in_idle (GLib.Object object, GLib.AsyncReadyCallback callback, GLib.Error error);
}
