/* valareferencetransferexpression.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valareferencetransferexpression.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valamemberaccess.h>
#include <vala/valaelementaccess.h>
#include <vala/valareport.h>
#include <vala/valadatatype.h>
#include <vala/valapointertype.h>




struct _ValaReferenceTransferExpressionPrivate {
	ValaExpression* _inner;
};

#define VALA_REFERENCE_TRANSFER_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, ValaReferenceTransferExpressionPrivate))
enum  {
	VALA_REFERENCE_TRANSFER_EXPRESSION_DUMMY_PROPERTY
};
static void vala_reference_transfer_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_reference_transfer_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_reference_transfer_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gboolean vala_reference_transfer_expression_real_is_pure (ValaExpression* base);
static gboolean vala_reference_transfer_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static void vala_reference_transfer_expression_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection);
static void vala_reference_transfer_expression_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection);
static gpointer vala_reference_transfer_expression_parent_class = NULL;
static void vala_reference_transfer_expression_finalize (ValaCodeNode* obj);



/**
 * Creates a new reference transfer expression.
 *
 * @param inner variable whose reference is to be transferred
 * @return      newly created reference transfer expression
 */
ValaReferenceTransferExpression* vala_reference_transfer_expression_construct (GType object_type, ValaExpression* inner, ValaSourceReference* source_reference) {
	ValaReferenceTransferExpression* self;
	g_return_val_if_fail (inner != NULL, NULL);
	self = (ValaReferenceTransferExpression*) g_type_create_instance (object_type);
	vala_reference_transfer_expression_set_inner (self, inner);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaReferenceTransferExpression* vala_reference_transfer_expression_new (ValaExpression* inner, ValaSourceReference* source_reference) {
	return vala_reference_transfer_expression_construct (VALA_TYPE_REFERENCE_TRANSFER_EXPRESSION, inner, source_reference);
}


static void vala_reference_transfer_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaReferenceTransferExpression * self;
	self = (ValaReferenceTransferExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_reference_transfer_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void vala_reference_transfer_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaReferenceTransferExpression * self;
	self = (ValaReferenceTransferExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_reference_transfer_expression_get_inner (self), visitor);
}


static void vala_reference_transfer_expression_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaReferenceTransferExpression * self;
	self = (ValaReferenceTransferExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	if (vala_reference_transfer_expression_get_inner (self) == old_node) {
		vala_reference_transfer_expression_set_inner (self, new_node);
	}
}


static gboolean vala_reference_transfer_expression_real_is_pure (ValaExpression* base) {
	ValaReferenceTransferExpression * self;
	self = (ValaReferenceTransferExpression*) base;
	return FALSE;
}


static gboolean vala_reference_transfer_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaReferenceTransferExpression * self;
	gboolean _tmp2;
	gboolean _tmp4;
	ValaDataType* _tmp6;
	self = (ValaReferenceTransferExpression*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_expression_set_lvalue (vala_reference_transfer_expression_get_inner (self), TRUE);
	vala_code_node_check ((ValaCodeNode*) vala_reference_transfer_expression_get_inner (self), analyzer);
	if (vala_code_node_get_error ((ValaCodeNode*) vala_reference_transfer_expression_get_inner (self))) {
		/* if there was an error in the inner expression, skip type check */
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		return FALSE;
	}
	_tmp2 = FALSE;
	if (VALA_IS_MEMBER_ACCESS (vala_reference_transfer_expression_get_inner (self))) {
		_tmp2 = TRUE;
	} else {
		_tmp2 = VALA_IS_ELEMENT_ACCESS (vala_reference_transfer_expression_get_inner (self));
	}
	if (!(_tmp2)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Reference transfer not supported for this expression");
		return FALSE;
	}
	_tmp4 = FALSE;
	if (!vala_data_type_is_disposable (vala_expression_get_value_type (vala_reference_transfer_expression_get_inner (self)))) {
		_tmp4 = !(VALA_IS_POINTER_TYPE (vala_expression_get_value_type (vala_reference_transfer_expression_get_inner (self))));
	} else {
		_tmp4 = FALSE;
	}
	if (_tmp4) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "No reference to be transferred");
		return FALSE;
	}
	_tmp6 = NULL;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp6 = vala_data_type_copy (vala_expression_get_value_type (vala_reference_transfer_expression_get_inner (self))));
	(_tmp6 == NULL) ? NULL : (_tmp6 = (vala_code_node_unref (_tmp6), NULL));
	vala_data_type_set_value_owned (vala_expression_get_value_type ((ValaExpression*) self), TRUE);
	return !vala_code_node_get_error ((ValaCodeNode*) self);
}


static void vala_reference_transfer_expression_real_get_defined_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaReferenceTransferExpression * self;
	self = (ValaReferenceTransferExpression*) base;
	g_return_if_fail (collection != NULL);
	vala_code_node_get_defined_variables ((ValaCodeNode*) vala_reference_transfer_expression_get_inner (self), collection);
}


static void vala_reference_transfer_expression_real_get_used_variables (ValaCodeNode* base, GeeCollection* collection) {
	ValaReferenceTransferExpression * self;
	self = (ValaReferenceTransferExpression*) base;
	g_return_if_fail (collection != NULL);
	vala_code_node_get_used_variables ((ValaCodeNode*) vala_reference_transfer_expression_get_inner (self), collection);
}


ValaExpression* vala_reference_transfer_expression_get_inner (ValaReferenceTransferExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_inner;
}


void vala_reference_transfer_expression_set_inner (ValaReferenceTransferExpression* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL)), _tmp2);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_inner, (ValaCodeNode*) self);
}


static void vala_reference_transfer_expression_class_init (ValaReferenceTransferExpressionClass * klass) {
	vala_reference_transfer_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_reference_transfer_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaReferenceTransferExpressionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_reference_transfer_expression_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_reference_transfer_expression_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_reference_transfer_expression_real_replace_expression;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_reference_transfer_expression_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->check = vala_reference_transfer_expression_real_check;
	VALA_CODE_NODE_CLASS (klass)->get_defined_variables = vala_reference_transfer_expression_real_get_defined_variables;
	VALA_CODE_NODE_CLASS (klass)->get_used_variables = vala_reference_transfer_expression_real_get_used_variables;
}


static void vala_reference_transfer_expression_instance_init (ValaReferenceTransferExpression * self) {
	self->priv = VALA_REFERENCE_TRANSFER_EXPRESSION_GET_PRIVATE (self);
}


static void vala_reference_transfer_expression_finalize (ValaCodeNode* obj) {
	ValaReferenceTransferExpression * self;
	self = VALA_REFERENCE_TRANSFER_EXPRESSION (obj);
	(self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL));
	VALA_CODE_NODE_CLASS (vala_reference_transfer_expression_parent_class)->finalize (obj);
}


GType vala_reference_transfer_expression_get_type (void) {
	static GType vala_reference_transfer_expression_type_id = 0;
	if (vala_reference_transfer_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaReferenceTransferExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_reference_transfer_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReferenceTransferExpression), 0, (GInstanceInitFunc) vala_reference_transfer_expression_instance_init, NULL };
		vala_reference_transfer_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaReferenceTransferExpression", &g_define_type_info, 0);
	}
	return vala_reference_transfer_expression_type_id;
}




