/* valaphifunction.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAPHIFUNCTION_H__
#define __VALA_VALAPHIFUNCTION_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <vala/valalocalvariable.h>

G_BEGIN_DECLS


#define VALA_TYPE_PHI_FUNCTION (vala_phi_function_get_type ())
#define VALA_PHI_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_PHI_FUNCTION, ValaPhiFunction))
#define VALA_PHI_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_PHI_FUNCTION, ValaPhiFunctionClass))
#define VALA_IS_PHI_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_PHI_FUNCTION))
#define VALA_IS_PHI_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_PHI_FUNCTION))
#define VALA_PHI_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_PHI_FUNCTION, ValaPhiFunctionClass))

typedef struct _ValaPhiFunction ValaPhiFunction;
typedef struct _ValaPhiFunctionClass ValaPhiFunctionClass;
typedef struct _ValaPhiFunctionPrivate ValaPhiFunctionPrivate;
typedef struct _ValaParamSpecPhiFunction ValaParamSpecPhiFunction;

struct _ValaPhiFunction {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaPhiFunctionPrivate * priv;
};

struct _ValaPhiFunctionClass {
	GTypeClass parent_class;
	void (*finalize) (ValaPhiFunction *self);
};

struct _ValaParamSpecPhiFunction {
	GParamSpec parent_instance;
};


ValaPhiFunction* vala_phi_function_construct (GType object_type, ValaLocalVariable* variable, gint num_of_ops);
ValaPhiFunction* vala_phi_function_new (ValaLocalVariable* variable, gint num_of_ops);
ValaLocalVariable* vala_phi_function_get_original_variable (ValaPhiFunction* self);
GeeList* vala_phi_function_get_operands (ValaPhiFunction* self);
GParamSpec* vala_param_spec_phi_function (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer vala_value_get_phi_function (const GValue* value);
void vala_value_set_phi_function (GValue* value, gpointer v_object);
GType vala_phi_function_get_type (void);
gpointer vala_phi_function_ref (gpointer instance);
void vala_phi_function_unref (gpointer instance);


G_END_DECLS

#endif
