/* valadelegate.vala
 *
 * Copyright (C) 2006-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALADELEGATE_H__
#define __VALA_VALADELEGATE_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gee/list.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_DELEGATE (vala_delegate_get_type ())
#define VALA_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DELEGATE, ValaDelegate))
#define VALA_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DELEGATE, ValaDelegateClass))
#define VALA_IS_DELEGATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DELEGATE))
#define VALA_IS_DELEGATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DELEGATE))
#define VALA_DELEGATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DELEGATE, ValaDelegateClass))

typedef struct _ValaDelegatePrivate ValaDelegatePrivate;

/**
 * Represents a function callback type.
 */
struct _ValaDelegate {
	ValaTypeSymbol parent_instance;
	ValaDelegatePrivate * priv;
};

struct _ValaDelegateClass {
	ValaTypeSymbolClass parent_class;
};


ValaDelegate* vala_delegate_construct (GType object_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
ValaDelegate* vala_delegate_new (const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
void vala_delegate_add_type_parameter (ValaDelegate* self, ValaTypeParameter* p);
void vala_delegate_add_parameter (ValaDelegate* self, ValaFormalParameter* param);
GeeList* vala_delegate_get_parameters (ValaDelegate* self);
gboolean vala_delegate_matches_method (ValaDelegate* self, ValaMethod* m);
void vala_delegate_set_cname (ValaDelegate* self, const char* cname);
void vala_delegate_process_attributes (ValaDelegate* self);
char* vala_delegate_get_prototype_string (ValaDelegate* self, const char* name);
ValaDataType* vala_delegate_get_return_type (ValaDelegate* self);
void vala_delegate_set_return_type (ValaDelegate* self, ValaDataType* value);
gboolean vala_delegate_get_has_target (ValaDelegate* self);
void vala_delegate_set_has_target (ValaDelegate* self, gboolean value);
double vala_delegate_get_cinstance_parameter_position (ValaDelegate* self);
void vala_delegate_set_cinstance_parameter_position (ValaDelegate* self, double value);
double vala_delegate_get_carray_length_parameter_position (ValaDelegate* self);
void vala_delegate_set_carray_length_parameter_position (ValaDelegate* self, double value);
double vala_delegate_get_cdelegate_target_parameter_position (ValaDelegate* self);
void vala_delegate_set_cdelegate_target_parameter_position (ValaDelegate* self, double value);
gboolean vala_delegate_get_no_array_length (ValaDelegate* self);
void vala_delegate_set_no_array_length (ValaDelegate* self, gboolean value);
gboolean vala_delegate_get_array_null_terminated (ValaDelegate* self);
void vala_delegate_set_array_null_terminated (ValaDelegate* self, gboolean value);
GType vala_delegate_get_type (void);


G_END_DECLS

#endif
