/* valaconditionalexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaconditionalexpression.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valablock.h>
#include <vala/valareport.h>
#include <vala/valalocalvariable.h>
#include <vala/valadatatype.h>
#include <vala/valadeclarationstatement.h>
#include <vala/valasymbol.h>
#include <vala/valastatement.h>
#include <vala/valaifstatement.h>
#include <vala/valaexpressionstatement.h>
#include <vala/valaassignment.h>
#include <vala/valamemberaccess.h>




struct _ValaConditionalExpressionPrivate {
	ValaExpression* _condition;
	ValaExpression* _true_expression;
	ValaExpression* _false_expression;
};

#define VALA_CONDITIONAL_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionPrivate))
enum  {
	VALA_CONDITIONAL_EXPRESSION_DUMMY_PROPERTY
};
static void vala_conditional_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_conditional_expression_real_is_pure (ValaExpression* base);
static gboolean vala_conditional_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static gpointer vala_conditional_expression_parent_class = NULL;
static void vala_conditional_expression_finalize (ValaCodeNode* obj);



/**
 * Creates a new conditional expression.
 *
 * @param cond       a condition
 * @param true_expr  expression to be evaluated if condition is true
 * @param false_expr expression to be evaluated if condition is false
 * @return           newly created conditional expression
 */
ValaConditionalExpression* vala_conditional_expression_construct (GType object_type, ValaExpression* cond, ValaExpression* true_expr, ValaExpression* false_expr, ValaSourceReference* source) {
	ValaConditionalExpression* self;
	g_return_val_if_fail (cond != NULL, NULL);
	g_return_val_if_fail (true_expr != NULL, NULL);
	g_return_val_if_fail (false_expr != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (ValaConditionalExpression*) g_type_create_instance (object_type);
	vala_conditional_expression_set_condition (self, cond);
	vala_conditional_expression_set_true_expression (self, true_expr);
	vala_conditional_expression_set_false_expression (self, false_expr);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaConditionalExpression* vala_conditional_expression_new (ValaExpression* cond, ValaExpression* true_expr, ValaExpression* false_expr, ValaSourceReference* source) {
	return vala_conditional_expression_construct (VALA_TYPE_CONDITIONAL_EXPRESSION, cond, true_expr, false_expr, source);
}


static void vala_conditional_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaConditionalExpression * self;
	self = (ValaConditionalExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_conditional_expression_get_condition (self), visitor);
	vala_code_node_accept ((ValaCodeNode*) vala_conditional_expression_get_true_expression (self), visitor);
	vala_code_node_accept ((ValaCodeNode*) vala_conditional_expression_get_false_expression (self), visitor);
	vala_code_visitor_visit_conditional_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static gboolean vala_conditional_expression_real_is_pure (ValaExpression* base) {
	ValaConditionalExpression * self;
	gboolean _tmp0;
	gboolean _tmp1;
	self = (ValaConditionalExpression*) base;
	_tmp0 = FALSE;
	_tmp1 = FALSE;
	if (vala_expression_is_pure (vala_conditional_expression_get_condition (self))) {
		_tmp1 = vala_expression_is_pure (vala_conditional_expression_get_true_expression (self));
	} else {
		_tmp1 = FALSE;
	}
	if (_tmp1) {
		_tmp0 = vala_expression_is_pure (vala_conditional_expression_get_false_expression (self));
	} else {
		_tmp0 = FALSE;
	}
	return _tmp0;
}


static gboolean vala_conditional_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaConditionalExpression * self;
	ValaBlock* _tmp2;
	ValaBlock* old_insert_block;
	ValaBlock* _tmp3;
	char* temp_name;
	ValaLocalVariable* local;
	ValaDeclarationStatement* decl;
	ValaLocalVariable* true_local;
	ValaBlock* true_block;
	ValaDeclarationStatement* true_decl;
	ValaLocalVariable* false_local;
	ValaBlock* false_block;
	ValaDeclarationStatement* false_decl;
	ValaIfStatement* if_stmt;
	ValaBlock* _tmp6;
	ValaBlock* _tmp5;
	gboolean _tmp10;
	ValaAssignment* _tmp12;
	ValaMemberAccess* _tmp11;
	ValaExpressionStatement* _tmp13;
	ValaExpressionStatement* true_stmt;
	ValaAssignment* _tmp15;
	ValaMemberAccess* _tmp14;
	ValaExpressionStatement* _tmp16;
	ValaExpressionStatement* false_stmt;
	ValaMemberAccess* ma;
	gboolean _tmp17;
	self = (ValaConditionalExpression*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	if (!(VALA_IS_BLOCK (vala_semantic_analyzer_get_current_symbol (analyzer)))) {
		vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) self), "Conditional expressions may only be used in blocks");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		return FALSE;
	}
	_tmp2 = NULL;
	old_insert_block = (_tmp2 = analyzer->insert_block, (_tmp2 == NULL) ? NULL : vala_code_node_ref (_tmp2));
	_tmp3 = NULL;
	analyzer->insert_block = (_tmp3 = vala_expression_prepare_condition_split ((ValaExpression*) self, analyzer), (analyzer->insert_block == NULL) ? NULL : (analyzer->insert_block = (vala_code_node_unref (analyzer->insert_block), NULL)), _tmp3);
	/* convert ternary expression into if statement
	 required for flow analysis and exception handling*/
	temp_name = vala_code_node_get_temp_name ((ValaCodeNode*) self);
	vala_expression_set_target_type (vala_conditional_expression_get_true_expression (self), vala_expression_get_target_type ((ValaExpression*) self));
	vala_expression_set_target_type (vala_conditional_expression_get_false_expression (self), vala_expression_get_target_type ((ValaExpression*) self));
	local = vala_local_variable_new (NULL, temp_name, NULL, vala_code_node_get_source_reference ((ValaCodeNode*) self));
	decl = vala_declaration_statement_new ((ValaSymbol*) local, vala_code_node_get_source_reference ((ValaCodeNode*) self));
	true_local = vala_local_variable_new (NULL, temp_name, vala_conditional_expression_get_true_expression (self), vala_code_node_get_source_reference ((ValaCodeNode*) vala_conditional_expression_get_true_expression (self)));
	true_block = vala_block_new (vala_code_node_get_source_reference ((ValaCodeNode*) vala_conditional_expression_get_true_expression (self)));
	true_decl = vala_declaration_statement_new ((ValaSymbol*) true_local, vala_code_node_get_source_reference ((ValaCodeNode*) vala_conditional_expression_get_true_expression (self)));
	vala_block_add_statement (true_block, (ValaStatement*) true_decl);
	false_local = vala_local_variable_new (NULL, temp_name, vala_conditional_expression_get_false_expression (self), vala_code_node_get_source_reference ((ValaCodeNode*) vala_conditional_expression_get_false_expression (self)));
	false_block = vala_block_new (vala_code_node_get_source_reference ((ValaCodeNode*) vala_conditional_expression_get_false_expression (self)));
	false_decl = vala_declaration_statement_new ((ValaSymbol*) false_local, vala_code_node_get_source_reference ((ValaCodeNode*) vala_conditional_expression_get_false_expression (self)));
	vala_block_add_statement (false_block, (ValaStatement*) false_decl);
	if_stmt = vala_if_statement_new (vala_conditional_expression_get_condition (self), true_block, false_block, vala_code_node_get_source_reference ((ValaCodeNode*) self));
	vala_expression_insert_statement ((ValaExpression*) self, analyzer->insert_block, (ValaStatement*) decl);
	vala_expression_insert_statement ((ValaExpression*) self, analyzer->insert_block, (ValaStatement*) if_stmt);
	if (!vala_code_node_check ((ValaCodeNode*) if_stmt, analyzer)) {
		gboolean _tmp4;
		return (_tmp4 = FALSE, (old_insert_block == NULL) ? NULL : (old_insert_block = (vala_code_node_unref (old_insert_block), NULL)), temp_name = (g_free (temp_name), NULL), (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), (decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL)), (true_local == NULL) ? NULL : (true_local = (vala_code_node_unref (true_local), NULL)), (true_block == NULL) ? NULL : (true_block = (vala_code_node_unref (true_block), NULL)), (true_decl == NULL) ? NULL : (true_decl = (vala_code_node_unref (true_decl), NULL)), (false_local == NULL) ? NULL : (false_local = (vala_code_node_unref (false_local), NULL)), (false_block == NULL) ? NULL : (false_block = (vala_code_node_unref (false_block), NULL)), (false_decl == NULL) ? NULL : (false_decl = (vala_code_node_unref (false_decl), NULL)), (if_stmt == NULL) ? NULL : (if_stmt = (vala_code_node_unref (if_stmt), NULL)), _tmp4);
	}
	_tmp6 = NULL;
	_tmp5 = NULL;
	analyzer->insert_block = (_tmp6 = (_tmp5 = old_insert_block, (_tmp5 == NULL) ? NULL : vala_code_node_ref (_tmp5)), (analyzer->insert_block == NULL) ? NULL : (analyzer->insert_block = (vala_code_node_unref (analyzer->insert_block), NULL)), _tmp6);
	vala_conditional_expression_set_true_expression (self, vala_local_variable_get_initializer (true_local));
	vala_conditional_expression_set_false_expression (self, vala_local_variable_get_initializer (false_local));
	vala_block_remove_local_variable (true_block, true_local);
	vala_block_remove_local_variable (false_block, false_local);
	if (vala_data_type_compatible (vala_expression_get_value_type (vala_conditional_expression_get_false_expression (self)), vala_expression_get_value_type (vala_conditional_expression_get_true_expression (self)))) {
		ValaDataType* _tmp7;
		_tmp7 = NULL;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp7 = vala_data_type_copy (vala_expression_get_value_type (vala_conditional_expression_get_true_expression (self))));
		(_tmp7 == NULL) ? NULL : (_tmp7 = (vala_code_node_unref (_tmp7), NULL));
	} else {
		if (vala_data_type_compatible (vala_expression_get_value_type (vala_conditional_expression_get_true_expression (self)), vala_expression_get_value_type (vala_conditional_expression_get_false_expression (self)))) {
			ValaDataType* _tmp8;
			_tmp8 = NULL;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp8 = vala_data_type_copy (vala_expression_get_value_type (vala_conditional_expression_get_false_expression (self))));
			(_tmp8 == NULL) ? NULL : (_tmp8 = (vala_code_node_unref (_tmp8), NULL));
		} else {
			gboolean _tmp9;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			vala_report_error (vala_code_node_get_source_reference ((ValaCodeNode*) vala_conditional_expression_get_condition (self)), "Incompatible expressions");
			return (_tmp9 = FALSE, (old_insert_block == NULL) ? NULL : (old_insert_block = (vala_code_node_unref (old_insert_block), NULL)), temp_name = (g_free (temp_name), NULL), (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), (decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL)), (true_local == NULL) ? NULL : (true_local = (vala_code_node_unref (true_local), NULL)), (true_block == NULL) ? NULL : (true_block = (vala_code_node_unref (true_block), NULL)), (true_decl == NULL) ? NULL : (true_decl = (vala_code_node_unref (true_decl), NULL)), (false_local == NULL) ? NULL : (false_local = (vala_code_node_unref (false_local), NULL)), (false_block == NULL) ? NULL : (false_block = (vala_code_node_unref (false_block), NULL)), (false_decl == NULL) ? NULL : (false_decl = (vala_code_node_unref (false_decl), NULL)), (if_stmt == NULL) ? NULL : (if_stmt = (vala_code_node_unref (if_stmt), NULL)), _tmp9);
		}
	}
	_tmp10 = FALSE;
	if (vala_data_type_get_value_owned (vala_expression_get_value_type (vala_conditional_expression_get_true_expression (self)))) {
		_tmp10 = TRUE;
	} else {
		_tmp10 = vala_data_type_get_value_owned (vala_expression_get_value_type (vala_conditional_expression_get_false_expression (self)));
	}
	vala_data_type_set_value_owned (vala_expression_get_value_type ((ValaExpression*) self), (_tmp10));
	vala_local_variable_set_variable_type (local, vala_expression_get_value_type ((ValaExpression*) self));
	vala_code_node_check ((ValaCodeNode*) decl, analyzer);
	vala_expression_set_target_type (vala_conditional_expression_get_true_expression (self), vala_expression_get_value_type ((ValaExpression*) self));
	vala_expression_set_target_type (vala_conditional_expression_get_false_expression (self), vala_expression_get_value_type ((ValaExpression*) self));
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp13 = NULL;
	true_stmt = (_tmp13 = vala_expression_statement_new ((ValaExpression*) (_tmp12 = vala_assignment_new ((ValaExpression*) (_tmp11 = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), vala_code_node_get_source_reference ((ValaCodeNode*) vala_conditional_expression_get_true_expression (self)))), vala_conditional_expression_get_true_expression (self), VALA_ASSIGNMENT_OPERATOR_SIMPLE, vala_code_node_get_source_reference ((ValaCodeNode*) vala_conditional_expression_get_true_expression (self)))), vala_code_node_get_source_reference ((ValaCodeNode*) vala_conditional_expression_get_true_expression (self))), (_tmp12 == NULL) ? NULL : (_tmp12 = (vala_code_node_unref (_tmp12), NULL)), (_tmp11 == NULL) ? NULL : (_tmp11 = (vala_code_node_unref (_tmp11), NULL)), _tmp13);
	vala_code_node_check ((ValaCodeNode*) true_stmt, analyzer);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp16 = NULL;
	false_stmt = (_tmp16 = vala_expression_statement_new ((ValaExpression*) (_tmp15 = vala_assignment_new ((ValaExpression*) (_tmp14 = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), vala_code_node_get_source_reference ((ValaCodeNode*) vala_conditional_expression_get_false_expression (self)))), vala_conditional_expression_get_false_expression (self), VALA_ASSIGNMENT_OPERATOR_SIMPLE, vala_code_node_get_source_reference ((ValaCodeNode*) vala_conditional_expression_get_false_expression (self)))), vala_code_node_get_source_reference ((ValaCodeNode*) vala_conditional_expression_get_false_expression (self))), (_tmp15 == NULL) ? NULL : (_tmp15 = (vala_code_node_unref (_tmp15), NULL)), (_tmp14 == NULL) ? NULL : (_tmp14 = (vala_code_node_unref (_tmp14), NULL)), _tmp16);
	vala_code_node_check ((ValaCodeNode*) false_stmt, analyzer);
	vala_block_replace_statement (true_block, (ValaStatement*) true_decl, (ValaStatement*) true_stmt);
	vala_block_replace_statement (false_block, (ValaStatement*) false_decl, (ValaStatement*) false_stmt);
	ma = vala_member_access_new_simple (vala_symbol_get_name ((ValaSymbol*) local), vala_code_node_get_source_reference ((ValaCodeNode*) self));
	vala_expression_set_target_type ((ValaExpression*) ma, vala_expression_get_target_type ((ValaExpression*) self));
	vala_code_node_check ((ValaCodeNode*) ma, analyzer);
	vala_code_node_replace_expression (vala_code_node_get_parent_node ((ValaCodeNode*) self), (ValaExpression*) self, (ValaExpression*) ma);
	return (_tmp17 = TRUE, (old_insert_block == NULL) ? NULL : (old_insert_block = (vala_code_node_unref (old_insert_block), NULL)), temp_name = (g_free (temp_name), NULL), (local == NULL) ? NULL : (local = (vala_code_node_unref (local), NULL)), (decl == NULL) ? NULL : (decl = (vala_code_node_unref (decl), NULL)), (true_local == NULL) ? NULL : (true_local = (vala_code_node_unref (true_local), NULL)), (true_block == NULL) ? NULL : (true_block = (vala_code_node_unref (true_block), NULL)), (true_decl == NULL) ? NULL : (true_decl = (vala_code_node_unref (true_decl), NULL)), (false_local == NULL) ? NULL : (false_local = (vala_code_node_unref (false_local), NULL)), (false_block == NULL) ? NULL : (false_block = (vala_code_node_unref (false_block), NULL)), (false_decl == NULL) ? NULL : (false_decl = (vala_code_node_unref (false_decl), NULL)), (if_stmt == NULL) ? NULL : (if_stmt = (vala_code_node_unref (if_stmt), NULL)), (true_stmt == NULL) ? NULL : (true_stmt = (vala_code_node_unref (true_stmt), NULL)), (false_stmt == NULL) ? NULL : (false_stmt = (vala_code_node_unref (false_stmt), NULL)), (ma == NULL) ? NULL : (ma = (vala_code_node_unref (ma), NULL)), _tmp17);
}


ValaExpression* vala_conditional_expression_get_condition (ValaConditionalExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_condition;
}


void vala_conditional_expression_set_condition (ValaConditionalExpression* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_condition = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_condition == NULL) ? NULL : (self->priv->_condition = (vala_code_node_unref (self->priv->_condition), NULL)), _tmp2);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_condition, (ValaCodeNode*) self);
}


ValaExpression* vala_conditional_expression_get_true_expression (ValaConditionalExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_true_expression;
}


void vala_conditional_expression_set_true_expression (ValaConditionalExpression* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_true_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_true_expression == NULL) ? NULL : (self->priv->_true_expression = (vala_code_node_unref (self->priv->_true_expression), NULL)), _tmp2);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_true_expression, (ValaCodeNode*) self);
}


ValaExpression* vala_conditional_expression_get_false_expression (ValaConditionalExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_false_expression;
}


void vala_conditional_expression_set_false_expression (ValaConditionalExpression* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_false_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_false_expression == NULL) ? NULL : (self->priv->_false_expression = (vala_code_node_unref (self->priv->_false_expression), NULL)), _tmp2);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_false_expression, (ValaCodeNode*) self);
}


static void vala_conditional_expression_class_init (ValaConditionalExpressionClass * klass) {
	vala_conditional_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_conditional_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaConditionalExpressionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_conditional_expression_real_accept;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_conditional_expression_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->check = vala_conditional_expression_real_check;
}


static void vala_conditional_expression_instance_init (ValaConditionalExpression * self) {
	self->priv = VALA_CONDITIONAL_EXPRESSION_GET_PRIVATE (self);
}


static void vala_conditional_expression_finalize (ValaCodeNode* obj) {
	ValaConditionalExpression * self;
	self = VALA_CONDITIONAL_EXPRESSION (obj);
	(self->priv->_condition == NULL) ? NULL : (self->priv->_condition = (vala_code_node_unref (self->priv->_condition), NULL));
	(self->priv->_true_expression == NULL) ? NULL : (self->priv->_true_expression = (vala_code_node_unref (self->priv->_true_expression), NULL));
	(self->priv->_false_expression == NULL) ? NULL : (self->priv->_false_expression = (vala_code_node_unref (self->priv->_false_expression), NULL));
	VALA_CODE_NODE_CLASS (vala_conditional_expression_parent_class)->finalize (obj);
}


GType vala_conditional_expression_get_type (void) {
	static GType vala_conditional_expression_type_id = 0;
	if (vala_conditional_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaConditionalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_conditional_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaConditionalExpression), 0, (GInstanceInitFunc) vala_conditional_expression_instance_init, NULL };
		vala_conditional_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaConditionalExpression", &g_define_type_info, 0);
	}
	return vala_conditional_expression_type_id;
}




