/* valayieldstatement.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAYIELDSTATEMENT_H__
#define __VALA_VALAYIELDSTATEMENT_H__

#include <glib.h>
#include <glib-object.h>
#include <vala/valacodenode.h>
#include <vala/valastatement.h>

G_BEGIN_DECLS


#define VALA_TYPE_YIELD_STATEMENT (vala_yield_statement_get_type ())
#define VALA_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatement))
#define VALA_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))
#define VALA_IS_YIELD_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_YIELD_STATEMENT))
#define VALA_IS_YIELD_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_YIELD_STATEMENT))
#define VALA_YIELD_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_YIELD_STATEMENT, ValaYieldStatementClass))

typedef struct _ValaYieldStatementPrivate ValaYieldStatementPrivate;

/**
 * Represents a yield statement in the source code.
 */
struct _ValaYieldStatement {
	ValaCodeNode parent_instance;
	ValaYieldStatementPrivate * priv;
};

struct _ValaYieldStatementClass {
	ValaCodeNodeClass parent_class;
};


ValaYieldStatement* vala_yield_statement_construct (GType object_type, ValaExpression* yield_expression, ValaSourceReference* source_reference);
ValaYieldStatement* vala_yield_statement_new (ValaExpression* yield_expression, ValaSourceReference* source_reference);
ValaExpression* vala_yield_statement_get_yield_expression (ValaYieldStatement* self);
void vala_yield_statement_set_yield_expression (ValaYieldStatement* self, ValaExpression* value);
GType vala_yield_statement_get_type (void);


G_END_DECLS

#endif
