/* valatypeofexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valatypeofexpression.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valasourcefile.h>




struct _ValaTypeofExpressionPrivate {
	ValaDataType* _data_type;
};

#define VALA_TYPEOF_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPEOF_EXPRESSION, ValaTypeofExpressionPrivate))
enum  {
	VALA_TYPEOF_EXPRESSION_DUMMY_PROPERTY
};
static void vala_typeof_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_typeof_expression_real_is_pure (ValaExpression* base);
static void vala_typeof_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static gboolean vala_typeof_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer);
static gpointer vala_typeof_expression_parent_class = NULL;
static void vala_typeof_expression_finalize (ValaCodeNode* obj);



/**
 * Creates a new typeof expression.
 *
 * @param type   a data type
 * @param source reference to source code
 * @return       newly created typeof expression
 */
ValaTypeofExpression* vala_typeof_expression_construct (GType object_type, ValaDataType* type, ValaSourceReference* source) {
	ValaTypeofExpression* self;
	g_return_val_if_fail (type != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (ValaTypeofExpression*) g_type_create_instance (object_type);
	vala_typeof_expression_set_type_reference (self, type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaTypeofExpression* vala_typeof_expression_new (ValaDataType* type, ValaSourceReference* source) {
	return vala_typeof_expression_construct (VALA_TYPE_TYPEOF_EXPRESSION, type, source);
}


static void vala_typeof_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaTypeofExpression * self;
	self = (ValaTypeofExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept ((ValaCodeNode*) vala_typeof_expression_get_type_reference (self), visitor);
	vala_code_visitor_visit_typeof_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static gboolean vala_typeof_expression_real_is_pure (ValaExpression* base) {
	ValaTypeofExpression * self;
	self = (ValaTypeofExpression*) base;
	return TRUE;
}


static void vala_typeof_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaTypeofExpression * self;
	self = (ValaTypeofExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	if (vala_typeof_expression_get_type_reference (self) == old_type) {
		vala_typeof_expression_set_type_reference (self, new_type);
	}
}


static gboolean vala_typeof_expression_real_check (ValaCodeNode* base, ValaSemanticAnalyzer* analyzer) {
	ValaTypeofExpression * self;
	self = (ValaTypeofExpression*) base;
	g_return_val_if_fail (analyzer != NULL, FALSE);
	if (vala_code_node_get_checked ((ValaCodeNode*) self)) {
		return !vala_code_node_get_error ((ValaCodeNode*) self);
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	vala_code_node_check ((ValaCodeNode*) vala_typeof_expression_get_type_reference (self), analyzer);
	vala_expression_set_value_type ((ValaExpression*) self, analyzer->type_type);
	vala_source_file_add_type_dependency (vala_semantic_analyzer_get_current_source_file (analyzer), vala_typeof_expression_get_type_reference (self), VALA_SOURCE_FILE_DEPENDENCY_TYPE_SOURCE);
	return !vala_code_node_get_error ((ValaCodeNode*) self);
}


ValaDataType* vala_typeof_expression_get_type_reference (ValaTypeofExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_data_type;
}


void vala_typeof_expression_set_type_reference (ValaTypeofExpression* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_data_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_code_node_ref (_tmp1)), (self->priv->_data_type == NULL) ? NULL : (self->priv->_data_type = (vala_code_node_unref (self->priv->_data_type), NULL)), _tmp2);
	vala_code_node_set_parent_node ((ValaCodeNode*) self->priv->_data_type, (ValaCodeNode*) self);
}


static void vala_typeof_expression_class_init (ValaTypeofExpressionClass * klass) {
	vala_typeof_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_typeof_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaTypeofExpressionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_typeof_expression_real_accept;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_typeof_expression_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_typeof_expression_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->check = vala_typeof_expression_real_check;
}


static void vala_typeof_expression_instance_init (ValaTypeofExpression * self) {
	self->priv = VALA_TYPEOF_EXPRESSION_GET_PRIVATE (self);
}


static void vala_typeof_expression_finalize (ValaCodeNode* obj) {
	ValaTypeofExpression * self;
	self = VALA_TYPEOF_EXPRESSION (obj);
	(self->priv->_data_type == NULL) ? NULL : (self->priv->_data_type = (vala_code_node_unref (self->priv->_data_type), NULL));
	VALA_CODE_NODE_CLASS (vala_typeof_expression_parent_class)->finalize (obj);
}


GType vala_typeof_expression_get_type (void) {
	static GType vala_typeof_expression_type_id = 0;
	if (vala_typeof_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeofExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeof_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeofExpression), 0, (GInstanceInitFunc) vala_typeof_expression_instance_init, NULL };
		vala_typeof_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaTypeofExpression", &g_define_type_info, 0);
	}
	return vala_typeof_expression_type_id;
}




