/* valascanner.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALASCANNER_H__
#define __VALA_VALASCANNER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valatokentype.h>
#include <vala/valasourcefile.h>
#include <vala/valasourcelocation.h>

G_BEGIN_DECLS


#define VALA_TYPE_SCANNER (vala_scanner_get_type ())
#define VALA_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SCANNER, ValaScanner))
#define VALA_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SCANNER, ValaScannerClass))
#define VALA_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SCANNER))
#define VALA_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SCANNER))
#define VALA_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SCANNER, ValaScannerClass))

typedef struct _ValaScanner ValaScanner;
typedef struct _ValaScannerClass ValaScannerClass;
typedef struct _ValaScannerPrivate ValaScannerPrivate;
typedef struct _ValaParamSpecScanner ValaParamSpecScanner;

/**
 * Lexical scanner for Vala source files.
 */
struct _ValaScanner {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaScannerPrivate * priv;
};

struct _ValaScannerClass {
	GTypeClass parent_class;
	void (*finalize) (ValaScanner *self);
};

struct _ValaParamSpecScanner {
	GParamSpec parent_instance;
};


ValaScanner* vala_scanner_construct (GType object_type, ValaSourceFile* source_file);
ValaScanner* vala_scanner_new (ValaSourceFile* source_file);
ValaTokenType vala_scanner_read_token (ValaScanner* self, ValaSourceLocation* token_begin, ValaSourceLocation* token_end);
char* vala_scanner_pop_comment (ValaScanner* self);
ValaSourceFile* vala_scanner_get_source_file (ValaScanner* self);
GParamSpec* vala_param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
gpointer vala_value_get_scanner (const GValue* value);
void vala_value_set_scanner (GValue* value, gpointer v_object);
GType vala_scanner_get_type (void);
gpointer vala_scanner_ref (gpointer instance);
void vala_scanner_unref (gpointer instance);


G_END_DECLS

#endif
