/* valadynamicsignal.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALADYNAMICSIGNAL_H__
#define __VALA_VALADYNAMICSIGNAL_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valasignal.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <vala/valasemanticanalyzer.h>
#include <vala/valaexpression.h>

G_BEGIN_DECLS


#define VALA_TYPE_DYNAMIC_SIGNAL (vala_dynamic_signal_get_type ())
#define VALA_DYNAMIC_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal))
#define VALA_DYNAMIC_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignalClass))
#define VALA_IS_DYNAMIC_SIGNAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_DYNAMIC_SIGNAL))
#define VALA_IS_DYNAMIC_SIGNAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_DYNAMIC_SIGNAL))
#define VALA_DYNAMIC_SIGNAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignalClass))

typedef struct _ValaDynamicSignal ValaDynamicSignal;
typedef struct _ValaDynamicSignalClass ValaDynamicSignalClass;
typedef struct _ValaDynamicSignalPrivate ValaDynamicSignalPrivate;

/**
 * Represents a late bound signal.
 */
struct _ValaDynamicSignal {
	ValaSignal parent_instance;
	ValaDynamicSignalPrivate * priv;
};

struct _ValaDynamicSignalClass {
	ValaSignalClass parent_class;
};


ValaDynamicSignal* vala_dynamic_signal_construct (GType object_type, ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
ValaDynamicSignal* vala_dynamic_signal_new (ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference);
ValaDataType* vala_dynamic_signal_get_dynamic_type (ValaDynamicSignal* self);
void vala_dynamic_signal_set_dynamic_type (ValaDynamicSignal* self, ValaDataType* value);
ValaExpression* vala_dynamic_signal_get_handler (ValaDynamicSignal* self);
void vala_dynamic_signal_set_handler (ValaDynamicSignal* self, ValaExpression* value);
GType vala_dynamic_signal_get_type (void);


G_END_DECLS

#endif
