/* valaccodeparenthesizedexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeparenthesizedexpression.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeParenthesizedExpressionPrivate {
	ValaCCodeExpression* _inner;
};

#define VALA_CCODE_PARENTHESIZED_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_PARENTHESIZED_EXPRESSION, ValaCCodeParenthesizedExpressionPrivate))
enum  {
	VALA_CCODE_PARENTHESIZED_EXPRESSION_DUMMY_PROPERTY
};
static void vala_ccode_parenthesized_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_parenthesized_expression_parent_class = NULL;
static void vala_ccode_parenthesized_expression_finalize (ValaCCodeNode* obj);



ValaCCodeParenthesizedExpression* vala_ccode_parenthesized_expression_construct (GType object_type, ValaCCodeExpression* expr) {
	ValaCCodeParenthesizedExpression* self;
	g_return_val_if_fail (expr != NULL, NULL);
	self = (ValaCCodeParenthesizedExpression*) g_type_create_instance (object_type);
	vala_ccode_parenthesized_expression_set_inner (self, expr);
	return self;
}


ValaCCodeParenthesizedExpression* vala_ccode_parenthesized_expression_new (ValaCCodeExpression* expr) {
	return vala_ccode_parenthesized_expression_construct (VALA_TYPE_CCODE_PARENTHESIZED_EXPRESSION, expr);
}


static void vala_ccode_parenthesized_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeParenthesizedExpression * self;
	self = (ValaCCodeParenthesizedExpression*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, "(");
	vala_ccode_node_write ((ValaCCodeNode*) self->priv->_inner, writer);
	vala_ccode_writer_write_string (writer, ")");
}


ValaCCodeExpression* vala_ccode_parenthesized_expression_get_inner (ValaCCodeParenthesizedExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_inner;
}


void vala_ccode_parenthesized_expression_set_inner (ValaCCodeParenthesizedExpression* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : vala_ccode_node_ref (_tmp1)), (self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_ccode_node_unref (self->priv->_inner), NULL)), _tmp2);
}


static void vala_ccode_parenthesized_expression_class_init (ValaCCodeParenthesizedExpressionClass * klass) {
	vala_ccode_parenthesized_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_parenthesized_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeParenthesizedExpressionPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_parenthesized_expression_real_write;
}


static void vala_ccode_parenthesized_expression_instance_init (ValaCCodeParenthesizedExpression * self) {
	self->priv = VALA_CCODE_PARENTHESIZED_EXPRESSION_GET_PRIVATE (self);
}


static void vala_ccode_parenthesized_expression_finalize (ValaCCodeNode* obj) {
	ValaCCodeParenthesizedExpression * self;
	self = VALA_CCODE_PARENTHESIZED_EXPRESSION (obj);
	(self->priv->_inner == NULL) ? NULL : (self->priv->_inner = (vala_ccode_node_unref (self->priv->_inner), NULL));
	VALA_CCODE_NODE_CLASS (vala_ccode_parenthesized_expression_parent_class)->finalize (obj);
}


GType vala_ccode_parenthesized_expression_get_type (void) {
	static GType vala_ccode_parenthesized_expression_type_id = 0;
	if (vala_ccode_parenthesized_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeParenthesizedExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_parenthesized_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeParenthesizedExpression), 0, (GInstanceInitFunc) vala_ccode_parenthesized_expression_instance_init, NULL };
		vala_ccode_parenthesized_expression_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeParenthesizedExpression", &g_define_type_info, 0);
	}
	return vala_ccode_parenthesized_expression_type_id;
}




