/* valaccodefunctiondeclarator.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodefunctiondeclarator.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <gee/iterable.h>
#include <gee/iterator.h>




struct _ValaCCodeFunctionDeclaratorPrivate {
	char* _name;
	GeeList* parameters;
};

#define VALA_CCODE_FUNCTION_DECLARATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FUNCTION_DECLARATOR, ValaCCodeFunctionDeclaratorPrivate))
enum  {
	VALA_CCODE_FUNCTION_DECLARATOR_DUMMY_PROPERTY
};
static void vala_ccode_function_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static void vala_ccode_function_declarator_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_function_declarator_parent_class = NULL;
static void vala_ccode_function_declarator_finalize (ValaCCodeNode* obj);



ValaCCodeFunctionDeclarator* vala_ccode_function_declarator_construct (GType object_type, const char* name) {
	ValaCCodeFunctionDeclarator* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaCCodeFunctionDeclarator*) g_type_create_instance (object_type);
	vala_ccode_function_declarator_set_name (self, name);
	return self;
}


ValaCCodeFunctionDeclarator* vala_ccode_function_declarator_new (const char* name) {
	return vala_ccode_function_declarator_construct (VALA_TYPE_CCODE_FUNCTION_DECLARATOR, name);
}


/**
 * Appends the specified parameter to the list of function parameters.
 *
 * @param param a formal parameter
 */
void vala_ccode_function_declarator_add_parameter (ValaCCodeFunctionDeclarator* self, ValaCCodeFormalParameter* param) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	gee_collection_add ((GeeCollection*) self->priv->parameters, param);
}


static void vala_ccode_function_declarator_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeFunctionDeclarator * self;
	self = (ValaCCodeFunctionDeclarator*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_node_write_declaration ((ValaCCodeNode*) self, writer);
}


static void vala_ccode_function_declarator_real_write_declaration (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeFunctionDeclarator * self;
	gboolean first;
	self = (ValaCCodeFunctionDeclarator*) base;
	g_return_if_fail (writer != NULL);
	vala_ccode_writer_write_string (writer, "(*");
	vala_ccode_writer_write_string (writer, self->priv->_name);
	vala_ccode_writer_write_string (writer, ") (");
	first = TRUE;
	{
		GeeIterator* _param_it;
		_param_it = gee_iterable_iterator ((GeeIterable*) self->priv->parameters);
		while (gee_iterator_next (_param_it)) {
			ValaCCodeFormalParameter* param;
			param = (ValaCCodeFormalParameter*) gee_iterator_get (_param_it);
			if (!first) {
				vala_ccode_writer_write_string (writer, ", ");
			} else {
				first = FALSE;
			}
			vala_ccode_node_write ((ValaCCodeNode*) param, writer);
			(param == NULL) ? NULL : (param = (vala_ccode_node_unref (param), NULL));
		}
		(_param_it == NULL) ? NULL : (_param_it = (gee_collection_object_unref (_param_it), NULL));
	}
	vala_ccode_writer_write_string (writer, ")");
}


const char* vala_ccode_function_declarator_get_name (ValaCCodeFunctionDeclarator* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_name;
}


void vala_ccode_function_declarator_set_name (ValaCCodeFunctionDeclarator* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_strdup (_tmp1)), self->priv->_name = (g_free (self->priv->_name), NULL), _tmp2);
}


static void vala_ccode_function_declarator_class_init (ValaCCodeFunctionDeclaratorClass * klass) {
	vala_ccode_function_declarator_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_function_declarator_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeFunctionDeclaratorPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_function_declarator_real_write;
	VALA_CCODE_NODE_CLASS (klass)->write_declaration = vala_ccode_function_declarator_real_write_declaration;
}


static void vala_ccode_function_declarator_instance_init (ValaCCodeFunctionDeclarator * self) {
	self->priv = VALA_CCODE_FUNCTION_DECLARATOR_GET_PRIVATE (self);
	self->priv->parameters = (GeeList*) gee_array_list_new (VALA_TYPE_CCODE_FORMAL_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, vala_ccode_node_unref, g_direct_equal);
}


static void vala_ccode_function_declarator_finalize (ValaCCodeNode* obj) {
	ValaCCodeFunctionDeclarator * self;
	self = VALA_CCODE_FUNCTION_DECLARATOR (obj);
	self->priv->_name = (g_free (self->priv->_name), NULL);
	(self->priv->parameters == NULL) ? NULL : (self->priv->parameters = (gee_collection_object_unref (self->priv->parameters), NULL));
	VALA_CCODE_NODE_CLASS (vala_ccode_function_declarator_parent_class)->finalize (obj);
}


GType vala_ccode_function_declarator_get_type (void) {
	static GType vala_ccode_function_declarator_type_id = 0;
	if (vala_ccode_function_declarator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeFunctionDeclaratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_function_declarator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeFunctionDeclarator), 0, (GInstanceInitFunc) vala_ccode_function_declarator_instance_init, NULL };
		vala_ccode_function_declarator_type_id = g_type_register_static (VALA_TYPE_CCODE_DECLARATOR, "ValaCCodeFunctionDeclarator", &g_define_type_info, 0);
	}
	return vala_ccode_function_declarator_type_id;
}




