/* valapostfixexpression.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valapostfixexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaPostfixExpressionPrivate {
	ValaExpression* _inner;
	gboolean _increment;
};

#define VALA_POSTFIX_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_POSTFIX_EXPRESSION, ValaPostfixExpressionPrivate))
enum  {
	VALA_POSTFIX_EXPRESSION_DUMMY_PROPERTY
};
static void vala_postfix_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_postfix_expression_real_is_pure (ValaExpression* base);
static gpointer vala_postfix_expression_parent_class = NULL;
static void vala_postfix_expression_finalize (ValaCodeNode* obj);



/**
 * Creates a new postfix expression.
 *
 * @param inner  operand expression
 * @param inc    true for increment, false for decrement
 * @param source reference to source code
 * @return newly created postfix expression
 */
ValaPostfixExpression* vala_postfix_expression_construct (GType object_type, ValaExpression* _inner, gboolean inc, ValaSourceReference* source) {
	ValaPostfixExpression* self;
	g_return_val_if_fail (_inner != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = ((ValaPostfixExpression*) (g_type_create_instance (object_type)));
	vala_postfix_expression_set_inner (self, _inner);
	vala_postfix_expression_set_increment (self, inc);
	vala_code_node_set_source_reference (((ValaCodeNode*) (self)), source);
	return self;
}


ValaPostfixExpression* vala_postfix_expression_new (ValaExpression* _inner, gboolean inc, ValaSourceReference* source) {
	return vala_postfix_expression_construct (VALA_TYPE_POSTFIX_EXPRESSION, _inner, inc, source);
}


static void vala_postfix_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaPostfixExpression * self;
	self = ((ValaPostfixExpression*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept (((ValaCodeNode*) (self->priv->_inner)), visitor);
	vala_code_visitor_visit_postfix_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, ((ValaExpression*) (self)));
}


static gboolean vala_postfix_expression_real_is_pure (ValaExpression* base) {
	ValaPostfixExpression * self;
	self = ((ValaPostfixExpression*) (base));
	return FALSE;
}


ValaExpression* vala_postfix_expression_get_inner (ValaPostfixExpression* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_inner;
}


void vala_postfix_expression_set_inner (ValaPostfixExpression* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL))), _tmp2);
}


gboolean vala_postfix_expression_get_increment (ValaPostfixExpression* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_increment;
}


void vala_postfix_expression_set_increment (ValaPostfixExpression* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_increment = value;
}


static void vala_postfix_expression_class_init (ValaPostfixExpressionClass * klass) {
	vala_postfix_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_postfix_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaPostfixExpressionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_postfix_expression_real_accept;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_postfix_expression_real_is_pure;
}


static void vala_postfix_expression_instance_init (ValaPostfixExpression * self) {
	self->priv = VALA_POSTFIX_EXPRESSION_GET_PRIVATE (self);
}


static void vala_postfix_expression_finalize (ValaCodeNode* obj) {
	ValaPostfixExpression * self;
	self = VALA_POSTFIX_EXPRESSION (obj);
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (vala_code_node_unref (self->priv->_inner), NULL)));
	VALA_CODE_NODE_CLASS (vala_postfix_expression_parent_class)->finalize (obj);
}


GType vala_postfix_expression_get_type (void) {
	static GType vala_postfix_expression_type_id = 0;
	if (vala_postfix_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPostfixExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_postfix_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaPostfixExpression), 0, (GInstanceInitFunc) vala_postfix_expression_instance_init, NULL };
		vala_postfix_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaPostfixExpression", &g_define_type_info, 0);
	}
	return vala_postfix_expression_type_id;
}




