/* valaexpressionstatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaexpressionstatement.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valaproperty.h>
#include <vala/valaassignment.h>
#include <vala/valamemberaccess.h>




struct _ValaExpressionStatementPrivate {
	ValaExpression* _expression;
};

#define VALA_EXPRESSION_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_EXPRESSION_STATEMENT, ValaExpressionStatementPrivate))
enum  {
	VALA_EXPRESSION_STATEMENT_DUMMY_PROPERTY
};
static void vala_expression_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_expression_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node);
static gpointer vala_expression_statement_parent_class = NULL;
static ValaStatementIface* vala_expression_statement_vala_statement_parent_iface = NULL;
static void vala_expression_statement_finalize (ValaCodeNode* obj);



/**
 * Creates a new expression statement.
 *
 * @param expr   expression to evaluate
 * @param source reference to source code
 * @return       newly created expression statement
 */
ValaExpressionStatement* vala_expression_statement_construct (GType object_type, ValaExpression* expression, ValaSourceReference* source_reference) {
	ValaExpressionStatement* self;
	g_return_val_if_fail (expression != NULL, NULL);
	self = ((ValaExpressionStatement*) (g_type_create_instance (object_type)));
	vala_code_node_set_source_reference (((ValaCodeNode*) (self)), source_reference);
	vala_expression_statement_set_expression (self, expression);
	return self;
}


ValaExpressionStatement* vala_expression_statement_new (ValaExpression* expression, ValaSourceReference* source_reference) {
	return vala_expression_statement_construct (VALA_TYPE_EXPRESSION_STATEMENT, expression, source_reference);
}


static void vala_expression_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaExpressionStatement * self;
	self = ((ValaExpressionStatement*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_node_accept (((ValaCodeNode*) (vala_expression_statement_get_expression (self))), visitor);
	vala_code_visitor_visit_expression_statement (visitor, self);
}


static void vala_expression_statement_real_replace_expression (ValaCodeNode* base, ValaExpression* old_node, ValaExpression* new_node) {
	ValaExpressionStatement * self;
	self = ((ValaExpressionStatement*) (base));
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	if (vala_expression_statement_get_expression (self) == old_node) {
		vala_expression_statement_set_expression (self, new_node);
	}
}


/**
 * Returns the property this statement sets, if any.
 *
 * @return the property this statement sets, or null if it doesn't set
 *         a property
 */
ValaProperty* vala_expression_statement_assigned_property (ValaExpressionStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	if (VALA_IS_ASSIGNMENT (vala_expression_statement_get_expression (self))) {
		ValaAssignment* _tmp0;
		ValaAssignment* assign;
		_tmp0 = NULL;
		assign = (_tmp0 = VALA_ASSIGNMENT (vala_expression_statement_get_expression (self)), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		if (VALA_IS_MEMBER_ACCESS (vala_assignment_get_left (assign))) {
			ValaMemberAccess* _tmp1;
			ValaMemberAccess* ma;
			_tmp1 = NULL;
			ma = (_tmp1 = VALA_MEMBER_ACCESS (vala_assignment_get_left (assign)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
			if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) (ma))))) {
				ValaProperty* _tmp2;
				ValaProperty* _tmp3;
				_tmp2 = NULL;
				_tmp3 = NULL;
				return (_tmp3 = (_tmp2 = VALA_PROPERTY (vala_expression_get_symbol_reference (((ValaExpression*) (ma)))), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2))), (ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL))), (assign == NULL ? NULL : (assign = (vala_code_node_unref (assign), NULL))), _tmp3);
			}
			(ma == NULL ? NULL : (ma = (vala_code_node_unref (ma), NULL)));
		}
		(assign == NULL ? NULL : (assign = (vala_code_node_unref (assign), NULL)));
	}
	return NULL;
}


ValaExpression* vala_expression_statement_get_expression (ValaExpressionStatement* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_expression;
}


void vala_expression_statement_set_expression (ValaExpressionStatement* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_expression == NULL ? NULL : (self->priv->_expression = (vala_code_node_unref (self->priv->_expression), NULL))), _tmp2);
	vala_code_node_set_parent_node (((ValaCodeNode*) (self->priv->_expression)), ((ValaCodeNode*) (self)));
}


static void vala_expression_statement_class_init (ValaExpressionStatementClass * klass) {
	vala_expression_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_expression_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaExpressionStatementPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_expression_statement_real_accept;
	VALA_CODE_NODE_CLASS (klass)->replace_expression = vala_expression_statement_real_replace_expression;
}


static void vala_expression_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_expression_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_expression_statement_instance_init (ValaExpressionStatement * self) {
	self->priv = VALA_EXPRESSION_STATEMENT_GET_PRIVATE (self);
}


static void vala_expression_statement_finalize (ValaCodeNode* obj) {
	ValaExpressionStatement * self;
	self = VALA_EXPRESSION_STATEMENT (obj);
	(self->priv->_expression == NULL ? NULL : (self->priv->_expression = (vala_code_node_unref (self->priv->_expression), NULL)));
	VALA_CODE_NODE_CLASS (vala_expression_statement_parent_class)->finalize (obj);
}


GType vala_expression_statement_get_type (void) {
	static GType vala_expression_statement_type_id = 0;
	if (vala_expression_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaExpressionStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_expression_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaExpressionStatement), 0, (GInstanceInitFunc) vala_expression_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_expression_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_expression_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaExpressionStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_expression_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_expression_statement_type_id;
}




