/* valaerrorcode.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaerrorcode.h>
#include <vala/valaexpression.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valasymbol.h>
#include <vala/valaerrordomain.h>




struct _ValaErrorCodePrivate {
	ValaExpression* _value;
	char* cname;
};

#define VALA_ERROR_CODE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ERROR_CODE, ValaErrorCodePrivate))
enum  {
	VALA_ERROR_CODE_DUMMY_PROPERTY
};
static void vala_error_code_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_error_code_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_error_code_real_get_cname (ValaTypeSymbol* base, gboolean const_type);
static gpointer vala_error_code_parent_class = NULL;
static void vala_error_code_finalize (ValaCodeNode* obj);



/**
 * Creates a new enum value.
 *
 * @param name enum value name
 * @return     newly created enum value
 */
ValaErrorCode* vala_error_code_construct (GType object_type, const char* name, ValaSourceReference* source_reference) {
	ValaErrorCode* self;
	g_return_val_if_fail (name != NULL, NULL);
	self = ((ValaErrorCode*) (g_type_create_instance (object_type)));
	self = ((ValaErrorCode*) (vala_typesymbol_construct (object_type, name, source_reference)));
	return self;
}


ValaErrorCode* vala_error_code_new (const char* name, ValaSourceReference* source_reference) {
	return vala_error_code_construct (VALA_TYPE_ERROR_CODE, name, source_reference);
}


/**
 * Creates a new enum value with the specified numerical representation.
 *
 * @param name  enum value name
 * @param value numerical representation
 * @return      newly created enum value
 */
ValaErrorCode* vala_error_code_construct_with_value (GType object_type, const char* name, ValaExpression* value, ValaSourceReference* source_reference) {
	ValaErrorCode* self;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (value != NULL, NULL);
	self = ((ValaErrorCode*) (g_type_create_instance (object_type)));
	self = ((ValaErrorCode*) (vala_error_code_construct (object_type, name, source_reference)));
	vala_error_code_set_value (self, value);
	return self;
}


ValaErrorCode* vala_error_code_new_with_value (const char* name, ValaExpression* value, ValaSourceReference* source_reference) {
	return vala_error_code_construct_with_value (VALA_TYPE_ERROR_CODE, name, value, source_reference);
}


static void vala_error_code_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaErrorCode * self;
	self = ((ValaErrorCode*) (base));
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_error_code (visitor, self);
}


static void vala_error_code_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaErrorCode * self;
	self = ((ValaErrorCode*) (base));
	g_return_if_fail (visitor != NULL);
	if (self->priv->_value != NULL) {
		vala_code_node_accept (((ValaCodeNode*) (self->priv->_value)), visitor);
	}
}


static char* vala_error_code_real_get_cname (ValaTypeSymbol* base, gboolean const_type) {
	ValaErrorCode * self;
	const char* _tmp3;
	self = ((ValaErrorCode*) (base));
	if (self->priv->cname == NULL) {
		ValaErrorDomain* _tmp0;
		ValaErrorDomain* edomain;
		char* _tmp2;
		char* _tmp1;
		_tmp0 = NULL;
		edomain = (_tmp0 = VALA_ERROR_DOMAIN (vala_symbol_get_parent_symbol (((ValaSymbol*) (self)))), (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
		_tmp2 = NULL;
		_tmp1 = NULL;
		self->priv->cname = (_tmp2 = g_strdup_printf ("%s%s", (_tmp1 = vala_error_domain_get_cprefix (edomain)), vala_symbol_get_name (((ValaSymbol*) (self)))), (self->priv->cname = (g_free (self->priv->cname), NULL)), _tmp2);
		_tmp1 = (g_free (_tmp1), NULL);
		(edomain == NULL ? NULL : (edomain = (vala_code_node_unref (edomain), NULL)));
	}
	_tmp3 = NULL;
	return (_tmp3 = self->priv->cname, (_tmp3 == NULL ? NULL : g_strdup (_tmp3)));
}


ValaExpression* vala_error_code_get_value (ValaErrorCode* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_value;
}


void vala_error_code_set_value (ValaErrorCode* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_value = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_value == NULL ? NULL : (self->priv->_value = (vala_code_node_unref (self->priv->_value), NULL))), _tmp2);
}


static void vala_error_code_class_init (ValaErrorCodeClass * klass) {
	vala_error_code_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_error_code_finalize;
	g_type_class_add_private (klass, sizeof (ValaErrorCodePrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_error_code_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_error_code_real_accept_children;
	VALA_TYPESYMBOL_CLASS (klass)->get_cname = vala_error_code_real_get_cname;
}


static void vala_error_code_instance_init (ValaErrorCode * self) {
	self->priv = VALA_ERROR_CODE_GET_PRIVATE (self);
}


static void vala_error_code_finalize (ValaCodeNode* obj) {
	ValaErrorCode * self;
	self = VALA_ERROR_CODE (obj);
	(self->priv->_value == NULL ? NULL : (self->priv->_value = (vala_code_node_unref (self->priv->_value), NULL)));
	self->priv->cname = (g_free (self->priv->cname), NULL);
	VALA_CODE_NODE_CLASS (vala_error_code_parent_class)->finalize (obj);
}


GType vala_error_code_get_type (void) {
	static GType vala_error_code_type_id = 0;
	if (vala_error_code_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaErrorCodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_error_code_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaErrorCode), 0, (GInstanceInitFunc) vala_error_code_instance_init, NULL };
		vala_error_code_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaErrorCode", &g_define_type_info, 0);
	}
	return vala_error_code_type_id;
}




