/* valadynamicmethod.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valadynamicmethod.h>
#include <gee/arraylist.h>
#include <vala/valasymbol.h>




struct _ValaDynamicMethodPrivate {
	ValaDataType* _dynamic_type;
	ValaInvocationExpression* _invocation;
	char* cname;
};

#define VALA_DYNAMIC_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethodPrivate))
enum  {
	VALA_DYNAMIC_METHOD_DUMMY_PROPERTY
};
static gint vala_dynamic_method_dynamic_method_id;
static GeeList* vala_dynamic_method_real_get_cheader_filenames (ValaSymbol* base);
static char* vala_dynamic_method_real_get_default_cname (ValaMethod* base);
static gpointer vala_dynamic_method_parent_class = NULL;
static void vala_dynamic_method_finalize (ValaCodeNode* obj);



ValaDynamicMethod* vala_dynamic_method_construct (GType object_type, ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference) {
	ValaDynamicMethod* self;
	g_return_val_if_fail (dynamic_type != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	self = ((ValaDynamicMethod*) (g_type_create_instance (object_type)));
	self = ((ValaDynamicMethod*) (vala_method_construct (object_type, name, return_type, source_reference)));
	vala_dynamic_method_set_dynamic_type (self, dynamic_type);
	return self;
}


ValaDynamicMethod* vala_dynamic_method_new (ValaDataType* dynamic_type, const char* name, ValaDataType* return_type, ValaSourceReference* source_reference) {
	return vala_dynamic_method_construct (VALA_TYPE_DYNAMIC_METHOD, dynamic_type, name, return_type, source_reference);
}


static GeeList* vala_dynamic_method_real_get_cheader_filenames (ValaSymbol* base) {
	ValaDynamicMethod * self;
	self = ((ValaDynamicMethod*) (base));
	return ((GeeList*) (gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_direct_equal)));
}


static char* vala_dynamic_method_real_get_default_cname (ValaMethod* base) {
	ValaDynamicMethod * self;
	const char* _tmp1;
	self = ((ValaDynamicMethod*) (base));
	/* return cname of wrapper method*/
	if (self->priv->cname == NULL) {
		char* _tmp0;
		_tmp0 = NULL;
		self->priv->cname = (_tmp0 = g_strdup_printf ("_dynamic_%s%d", vala_symbol_get_name (((ValaSymbol*) (self))), vala_dynamic_method_dynamic_method_id++), (self->priv->cname = (g_free (self->priv->cname), NULL)), _tmp0);
	}
	_tmp1 = NULL;
	return (_tmp1 = self->priv->cname, (_tmp1 == NULL ? NULL : g_strdup (_tmp1)));
}


ValaDataType* vala_dynamic_method_get_dynamic_type (ValaDynamicMethod* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_dynamic_type;
}


void vala_dynamic_method_set_dynamic_type (ValaDynamicMethod* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_dynamic_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_dynamic_type == NULL ? NULL : (self->priv->_dynamic_type = (vala_code_node_unref (self->priv->_dynamic_type), NULL))), _tmp2);
}


ValaInvocationExpression* vala_dynamic_method_get_invocation (ValaDynamicMethod* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_invocation;
}


void vala_dynamic_method_set_invocation (ValaDynamicMethod* self, ValaInvocationExpression* value) {
	ValaInvocationExpression* _tmp2;
	ValaInvocationExpression* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_invocation = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_invocation == NULL ? NULL : (self->priv->_invocation = (vala_code_node_unref (self->priv->_invocation), NULL))), _tmp2);
}


static void vala_dynamic_method_class_init (ValaDynamicMethodClass * klass) {
	vala_dynamic_method_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_dynamic_method_finalize;
	g_type_class_add_private (klass, sizeof (ValaDynamicMethodPrivate));
	VALA_SYMBOL_CLASS (klass)->get_cheader_filenames = vala_dynamic_method_real_get_cheader_filenames;
	VALA_METHOD_CLASS (klass)->get_default_cname = vala_dynamic_method_real_get_default_cname;
}


static void vala_dynamic_method_instance_init (ValaDynamicMethod * self) {
	self->priv = VALA_DYNAMIC_METHOD_GET_PRIVATE (self);
}


static void vala_dynamic_method_finalize (ValaCodeNode* obj) {
	ValaDynamicMethod * self;
	self = VALA_DYNAMIC_METHOD (obj);
	(self->priv->_dynamic_type == NULL ? NULL : (self->priv->_dynamic_type = (vala_code_node_unref (self->priv->_dynamic_type), NULL)));
	(self->priv->_invocation == NULL ? NULL : (self->priv->_invocation = (vala_code_node_unref (self->priv->_invocation), NULL)));
	self->priv->cname = (g_free (self->priv->cname), NULL);
	VALA_CODE_NODE_CLASS (vala_dynamic_method_parent_class)->finalize (obj);
}


GType vala_dynamic_method_get_type (void) {
	static GType vala_dynamic_method_type_id = 0;
	if (vala_dynamic_method_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDynamicMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dynamic_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDynamicMethod), 0, (GInstanceInitFunc) vala_dynamic_method_instance_init, NULL };
		vala_dynamic_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaDynamicMethod", &g_define_type_info, 0);
	}
	return vala_dynamic_method_type_id;
}




