/* valaexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valasymbol.h>
#include <vala/valalocalvariable.h>




struct _ValaExpressionPrivate {
	ValaDataType* _value_type;
	ValaDataType* _target_type;
	ValaSymbol* _symbol_reference;
	gboolean _lvalue;
};

#define VALA_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_EXPRESSION, ValaExpressionPrivate))
enum  {
	VALA_EXPRESSION_DUMMY_PROPERTY,
	VALA_EXPRESSION_VALUE_TYPE,
	VALA_EXPRESSION_TARGET_TYPE,
	VALA_EXPRESSION_SYMBOL_REFERENCE,
	VALA_EXPRESSION_LVALUE
};
static gboolean vala_expression_real_is_pure (ValaExpression* self);
static gpointer vala_expression_parent_class = NULL;
static void vala_expression_finalize (GObject * obj);



static gboolean vala_expression_real_is_pure (ValaExpression* self) {
	g_return_val_if_fail (VALA_IS_EXPRESSION (self), FALSE);
	g_critical ("Type `%s' does not implement abstract method `vala_expression_is_pure'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return FALSE;
}


/**
 * Returns whether this expression is pure, i.e. whether this expression
 * is free of side-effects.
 */
gboolean vala_expression_is_pure (ValaExpression* self) {
	return VALA_EXPRESSION_GET_CLASS (self)->is_pure (self);
}


ValaDataType* vala_expression_get_value_type (ValaExpression* self) {
	g_return_val_if_fail (VALA_IS_EXPRESSION (self), NULL);
	return self->priv->_value_type;
}


void vala_expression_set_value_type (ValaExpression* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (VALA_IS_EXPRESSION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_value_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_value_type == NULL ? NULL : (self->priv->_value_type = (g_object_unref (self->priv->_value_type), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "value-type");
}


ValaDataType* vala_expression_get_target_type (ValaExpression* self) {
	g_return_val_if_fail (VALA_IS_EXPRESSION (self), NULL);
	return self->priv->_target_type;
}


void vala_expression_set_target_type (ValaExpression* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (VALA_IS_EXPRESSION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_target_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_target_type == NULL ? NULL : (self->priv->_target_type = (g_object_unref (self->priv->_target_type), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "target-type");
}


ValaSymbol* vala_expression_get_symbol_reference (ValaExpression* self) {
	g_return_val_if_fail (VALA_IS_EXPRESSION (self), NULL);
	return self->priv->_symbol_reference;
}


void vala_expression_set_symbol_reference (ValaExpression* self, ValaSymbol* value) {
	g_return_if_fail (VALA_IS_EXPRESSION (self));
	self->priv->_symbol_reference = value;
	g_object_notify (((GObject *) (self)), "symbol-reference");
}


gboolean vala_expression_get_lvalue (ValaExpression* self) {
	g_return_val_if_fail (VALA_IS_EXPRESSION (self), FALSE);
	return self->priv->_lvalue;
}


void vala_expression_set_lvalue (ValaExpression* self, gboolean value) {
	g_return_if_fail (VALA_IS_EXPRESSION (self));
	self->priv->_lvalue = value;
	g_object_notify (((GObject *) (self)), "lvalue");
}


static void vala_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaExpression * self;
	self = VALA_EXPRESSION (object);
	switch (property_id) {
		case VALA_EXPRESSION_VALUE_TYPE:
		g_value_set_object (value, vala_expression_get_value_type (self));
		break;
		case VALA_EXPRESSION_TARGET_TYPE:
		g_value_set_object (value, vala_expression_get_target_type (self));
		break;
		case VALA_EXPRESSION_SYMBOL_REFERENCE:
		g_value_set_object (value, vala_expression_get_symbol_reference (self));
		break;
		case VALA_EXPRESSION_LVALUE:
		g_value_set_boolean (value, vala_expression_get_lvalue (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaExpression * self;
	self = VALA_EXPRESSION (object);
	switch (property_id) {
		case VALA_EXPRESSION_VALUE_TYPE:
		vala_expression_set_value_type (self, g_value_get_object (value));
		break;
		case VALA_EXPRESSION_TARGET_TYPE:
		vala_expression_set_target_type (self, g_value_get_object (value));
		break;
		case VALA_EXPRESSION_SYMBOL_REFERENCE:
		vala_expression_set_symbol_reference (self, g_value_get_object (value));
		break;
		case VALA_EXPRESSION_LVALUE:
		vala_expression_set_lvalue (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_expression_class_init (ValaExpressionClass * klass) {
	vala_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_expression_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_expression_finalize;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_expression_real_is_pure;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_EXPRESSION_VALUE_TYPE, g_param_spec_object ("value-type", "value-type", "value-type", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_EXPRESSION_TARGET_TYPE, g_param_spec_object ("target-type", "target-type", "target-type", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_EXPRESSION_SYMBOL_REFERENCE, g_param_spec_object ("symbol-reference", "symbol-reference", "symbol-reference", VALA_TYPE_SYMBOL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_EXPRESSION_LVALUE, g_param_spec_boolean ("lvalue", "lvalue", "lvalue", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_expression_instance_init (ValaExpression * self) {
	self->priv = VALA_EXPRESSION_GET_PRIVATE (self);
	self->temp_vars = gee_array_list_new (VALA_TYPE_LOCAL_VARIABLE, ((GBoxedCopyFunc) (g_object_ref)), g_object_unref, g_direct_equal);
}


static void vala_expression_finalize (GObject * obj) {
	ValaExpression * self;
	self = VALA_EXPRESSION (obj);
	(self->priv->_value_type == NULL ? NULL : (self->priv->_value_type = (g_object_unref (self->priv->_value_type), NULL)));
	(self->priv->_target_type == NULL ? NULL : (self->priv->_target_type = (g_object_unref (self->priv->_target_type), NULL)));
	(self->temp_vars == NULL ? NULL : (self->temp_vars = (g_object_unref (self->temp_vars), NULL)));
	G_OBJECT_CLASS (vala_expression_parent_class)->finalize (obj);
}


GType vala_expression_get_type (void) {
	static GType vala_expression_type_id = 0;
	if (vala_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaExpression), 0, (GInstanceInitFunc) vala_expression_instance_init };
		vala_expression_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaExpression", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_expression_type_id;
}




