/* valatyperegisterfunction.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gobject/valatyperegisterfunction.h>
#include <vala/valacodecontext.h>
#include <vala/valaclass.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>




struct _ValaTypeRegisterFunctionPrivate {
	ValaCCodeFragment* declaration_fragment;
	ValaCCodeFragment* definition_fragment;
	ValaCCodeGenerator* _codegen;
};

#define VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPEREGISTER_FUNCTION, ValaTypeRegisterFunctionPrivate))
enum  {
	VALA_TYPEREGISTER_FUNCTION_DUMMY_PROPERTY,
	VALA_TYPEREGISTER_FUNCTION_CODEGEN
};
static ValaTypeSymbol* vala_typeregister_function_real_get_type_declaration (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_type_struct_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_base_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_class_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_instance_struct_size (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_parent_type_name (ValaTypeRegisterFunction* self);
static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self);
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* self);
static ValaSymbolAccessibility vala_typeregister_function_real_get_accessibility (ValaTypeRegisterFunction* self);
static gpointer vala_typeregister_function_parent_class = NULL;
static void vala_typeregister_function_finalize (GObject * obj);



/**
 * Constructs the C function from the specified type.
 */
void vala_typeregister_function_init_from_type (ValaTypeRegisterFunction* self, gboolean plugin) {
	gboolean use_thread_safe;
	gboolean fundamental;
	ValaTypeSymbol* _tmp0;
	ValaClass* cl;
	char* _tmp2;
	ValaTypeSymbol* _tmp1;
	char* _tmp3;
	char* type_id_name;
	ValaCCodeBlock* type_block;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeFunction* fun;
	ValaCCodeBlock* type_init;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp35;
	ValaCCodeConstant* _tmp34;
	char* _tmp33;
	char* _tmp32;
	char* _tmp31;
	char* _tmp30;
	char* _tmp29;
	char* _tmp28;
	ValaCCodeFragment* _tmp38;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeConstant* _tmp53;
	char* _tmp52;
	char* _tmp51;
	ValaTypeSymbol* _tmp50;
	ValaCCodeIdentifier* _tmp54;
	ValaCCodeConstant* _tmp57;
	char* _tmp56;
	ValaCCodeFragment* _tmp62;
	ValaCCodeFunction* _tmp85;
	g_return_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self));
	use_thread_safe = vala_code_context_require_glib_version (self->priv->_codegen->context, 2, 14);
	fundamental = FALSE;
	_tmp0 = NULL;
	cl = (_tmp0 = vala_typeregister_function_get_type_declaration (self), (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) (_tmp0)) : NULL));
	if (cl != NULL && !vala_class_get_is_compact (cl) && vala_class_get_base_class (cl) == NULL) {
		fundamental = TRUE;
	}
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp3 = NULL;
	type_id_name = (_tmp3 = g_strdup_printf ("%s_type_id", (_tmp2 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((_tmp1 = vala_typeregister_function_get_type_declaration (self))), NULL))), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 == NULL ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL))), _tmp3);
	type_block = vala_ccode_block_new ();
	cdecl_ = NULL;
	if (use_thread_safe) {
		ValaCCodeDeclaration* _tmp4;
		ValaCCodeVariableDeclarator* _tmp7;
		ValaCCodeConstant* _tmp6;
		char* _tmp5;
		_tmp4 = NULL;
		cdecl_ = (_tmp4 = vala_ccode_declaration_new ("gsize"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp4);
		_tmp7 = NULL;
		_tmp6 = NULL;
		_tmp5 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp7 = vala_ccode_variable_declarator_new_with_initializer ((_tmp5 = g_strconcat (type_id_name, "__volatile", NULL)), VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_constant_new ("0")))))));
		(_tmp7 == NULL ? NULL : (_tmp7 = (g_object_unref (_tmp7), NULL)));
		(_tmp6 == NULL ? NULL : (_tmp6 = (g_object_unref (_tmp6), NULL)));
		_tmp5 = (g_free (_tmp5), NULL);
	} else {
		ValaCCodeDeclaration* _tmp8;
		ValaCCodeVariableDeclarator* _tmp10;
		ValaCCodeConstant* _tmp9;
		_tmp8 = NULL;
		cdecl_ = (_tmp8 = vala_ccode_declaration_new ("GType"), (cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL))), _tmp8);
		_tmp10 = NULL;
		_tmp9 = NULL;
		vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp10 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("0")))))));
		(_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL)));
		(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
	}
	vala_ccode_declaration_set_modifiers (cdecl_, VALA_CCODE_MODIFIERS_STATIC);
	if (use_thread_safe) {
		vala_ccode_declaration_set_modifiers (cdecl_, vala_ccode_declaration_get_modifiers (cdecl_) | (VALA_CCODE_MODIFIERS_VOLATILE));
	}
	if (!plugin) {
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE (cdecl_));
	} else {
		vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (cdecl_));
	}
	fun = NULL;
	if (!plugin) {
		ValaCCodeFunction* _tmp14;
		char* _tmp13;
		char* _tmp12;
		ValaTypeSymbol* _tmp11;
		_tmp14 = NULL;
		_tmp13 = NULL;
		_tmp12 = NULL;
		_tmp11 = NULL;
		fun = (_tmp14 = vala_ccode_function_new ((_tmp13 = g_strdup_printf ("%s_get_type", (_tmp12 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((_tmp11 = vala_typeregister_function_get_type_declaration (self))), NULL)))), "GType"), (fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL))), _tmp14);
		_tmp13 = (g_free (_tmp13), NULL);
		_tmp12 = (g_free (_tmp12), NULL);
		(_tmp11 == NULL ? NULL : (_tmp11 = (g_object_unref (_tmp11), NULL)));
		/* Function will not be prototyped anyway */
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
	} else {
		ValaCCodeFunction* _tmp18;
		char* _tmp17;
		char* _tmp16;
		ValaTypeSymbol* _tmp15;
		ValaCCodeFormalParameter* _tmp19;
		char* _tmp22;
		char* _tmp21;
		ValaTypeSymbol* _tmp20;
		ValaCCodeFunction* _tmp23;
		ValaCCodeFunction* get_fun;
		ValaCCodeFunction* _tmp24;
		ValaCCodeBlock* _tmp25;
		ValaCCodeReturnStatement* _tmp27;
		ValaCCodeIdentifier* _tmp26;
		_tmp18 = NULL;
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp15 = NULL;
		fun = (_tmp18 = vala_ccode_function_new ((_tmp17 = g_strdup_printf ("%s_register_type", (_tmp16 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((_tmp15 = vala_typeregister_function_get_type_declaration (self))), NULL)))), "GType"), (fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL))), _tmp18);
		_tmp17 = (g_free (_tmp17), NULL);
		_tmp16 = (g_free (_tmp16), NULL);
		(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
		_tmp19 = NULL;
		vala_ccode_function_add_parameter (fun, (_tmp19 = vala_ccode_formal_parameter_new ("module", "GTypeModule *")));
		(_tmp19 == NULL ? NULL : (_tmp19 = (g_object_unref (_tmp19), NULL)));
		_tmp22 = NULL;
		_tmp21 = NULL;
		_tmp20 = NULL;
		_tmp23 = NULL;
		get_fun = (_tmp23 = vala_ccode_function_new ((_tmp22 = g_strdup_printf ("%s_get_type", (_tmp21 = vala_symbol_get_lower_case_cname (VALA_SYMBOL ((_tmp20 = vala_typeregister_function_get_type_declaration (self))), NULL)))), "GType"), (_tmp22 = (g_free (_tmp22), NULL)), (_tmp21 = (g_free (_tmp21), NULL)), (_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL))), _tmp23);
		if (vala_typeregister_function_get_accessibility (self) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			vala_ccode_function_set_modifiers (fun, VALA_CCODE_MODIFIERS_STATIC);
		}
		_tmp24 = NULL;
		vala_ccode_fragment_append (self->priv->declaration_fragment, VALA_CCODE_NODE ((_tmp24 = vala_ccode_function_copy (get_fun))));
		(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
		_tmp25 = NULL;
		vala_ccode_function_set_block (get_fun, (_tmp25 = vala_ccode_block_new ()));
		(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
		_tmp27 = NULL;
		_tmp26 = NULL;
		vala_ccode_block_add_statement (vala_ccode_function_get_block (get_fun), VALA_CCODE_NODE ((_tmp27 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new (type_id_name)))))));
		(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
		(_tmp26 == NULL ? NULL : (_tmp26 = (g_object_unref (_tmp26), NULL)));
		vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (get_fun));
		(get_fun == NULL ? NULL : (get_fun = (g_object_unref (get_fun), NULL)));
	}
	type_init = vala_ccode_block_new ();
	ctypedecl = vala_ccode_declaration_new ("const GTypeInfo");
	vala_ccode_declaration_set_modifiers (ctypedecl, VALA_CCODE_MODIFIERS_STATIC);
	_tmp35 = NULL;
	_tmp34 = NULL;
	_tmp33 = NULL;
	_tmp32 = NULL;
	_tmp31 = NULL;
	_tmp30 = NULL;
	_tmp29 = NULL;
	_tmp28 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, VALA_CCODE_DECLARATOR ((_tmp35 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_info", VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_constant_new ((_tmp33 = g_strdup_printf ("{ sizeof (%s), (GBaseInitFunc) %s, (GBaseFinalizeFunc) NULL, (GClassInitFunc) %s, (GClassFinalizeFunc) NULL, NULL, %s, 0, (GInstanceInitFunc) %s }", (_tmp28 = vala_typeregister_function_get_type_struct_name (self)), (_tmp29 = vala_typeregister_function_get_base_init_func_name (self)), (_tmp30 = vala_typeregister_function_get_class_init_func_name (self)), (_tmp31 = vala_typeregister_function_get_instance_struct_size (self)), (_tmp32 = vala_typeregister_function_get_instance_init_func_name (self)))))))))));
	(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
	(_tmp34 == NULL ? NULL : (_tmp34 = (g_object_unref (_tmp34), NULL)));
	_tmp33 = (g_free (_tmp33), NULL);
	_tmp32 = (g_free (_tmp32), NULL);
	_tmp31 = (g_free (_tmp31), NULL);
	_tmp30 = (g_free (_tmp30), NULL);
	_tmp29 = (g_free (_tmp29), NULL);
	_tmp28 = (g_free (_tmp28), NULL);
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE (ctypedecl));
	if (fundamental) {
		ValaCCodeDeclaration* ctypefundamentaldecl;
		ValaCCodeVariableDeclarator* _tmp37;
		ValaCCodeConstant* _tmp36;
		ctypefundamentaldecl = vala_ccode_declaration_new ("const GTypeFundamentalInfo");
		vala_ccode_declaration_set_modifiers (ctypefundamentaldecl, VALA_CCODE_MODIFIERS_STATIC);
		_tmp37 = NULL;
		_tmp36 = NULL;
		vala_ccode_declaration_add_declarator (ctypefundamentaldecl, VALA_CCODE_DECLARATOR ((_tmp37 = vala_ccode_variable_declarator_new_with_initializer ("g_define_type_fundamental_info", VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_constant_new ("{ (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) }")))))));
		(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
		(_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL)));
		vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE (ctypefundamentaldecl));
		(ctypefundamentaldecl == NULL ? NULL : (ctypefundamentaldecl = (g_object_unref (ctypefundamentaldecl), NULL)));
	}
	_tmp38 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((_tmp38 = vala_typeregister_function_get_type_interface_init_declaration (self))));
	(_tmp38 == NULL ? NULL : (_tmp38 = (g_object_unref (_tmp38), NULL)));
	reg_call = NULL;
	if (fundamental) {
		ValaCCodeFunctionCall* _tmp40;
		ValaCCodeIdentifier* _tmp39;
		_tmp40 = NULL;
		_tmp39 = NULL;
		reg_call = (_tmp40 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new ("g_type_register_fundamental")))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), _tmp40);
		(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
	} else {
		if (!plugin) {
			ValaCCodeFunctionCall* _tmp42;
			ValaCCodeIdentifier* _tmp41;
			_tmp42 = NULL;
			_tmp41 = NULL;
			reg_call = (_tmp42 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_identifier_new ("g_type_register_static")))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), _tmp42);
			(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
		} else {
			ValaCCodeFunctionCall* _tmp44;
			ValaCCodeIdentifier* _tmp43;
			ValaCCodeIdentifier* _tmp45;
			_tmp44 = NULL;
			_tmp43 = NULL;
			reg_call = (_tmp44 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ("g_type_module_register_type")))), (reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL))), _tmp44);
			(_tmp43 == NULL ? NULL : (_tmp43 = (g_object_unref (_tmp43), NULL)));
			_tmp45 = NULL;
			vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new ("module"))));
			(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
		}
	}
	if (fundamental) {
		ValaCCodeFunctionCall* _tmp47;
		ValaCCodeIdentifier* _tmp46;
		_tmp47 = NULL;
		_tmp46 = NULL;
		vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("g_type_fundamental_next")))))));
		(_tmp47 == NULL ? NULL : (_tmp47 = (g_object_unref (_tmp47), NULL)));
		(_tmp46 == NULL ? NULL : (_tmp46 = (g_object_unref (_tmp46), NULL)));
	} else {
		ValaCCodeIdentifier* _tmp49;
		char* _tmp48;
		_tmp49 = NULL;
		_tmp48 = NULL;
		vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ((_tmp48 = vala_typeregister_function_get_parent_type_name (self))))));
		(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
		_tmp48 = (g_free (_tmp48), NULL);
	}
	_tmp53 = NULL;
	_tmp52 = NULL;
	_tmp51 = NULL;
	_tmp50 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_constant_new ((_tmp52 = g_strdup_printf ("\"%s\"", (_tmp51 = vala_typesymbol_get_cname ((_tmp50 = vala_typeregister_function_get_type_declaration (self)), FALSE))))))));
	(_tmp53 == NULL ? NULL : (_tmp53 = (g_object_unref (_tmp53), NULL)));
	_tmp52 = (g_free (_tmp52), NULL);
	_tmp51 = (g_free (_tmp51), NULL);
	(_tmp50 == NULL ? NULL : (_tmp50 = (g_object_unref (_tmp50), NULL)));
	_tmp54 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp54 = vala_ccode_identifier_new ("&g_define_type_info"))));
	(_tmp54 == NULL ? NULL : (_tmp54 = (g_object_unref (_tmp54), NULL)));
	if (fundamental) {
		ValaCCodeIdentifier* _tmp55;
		_tmp55 = NULL;
		vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_identifier_new ("&g_define_type_fundamental_info"))));
		(_tmp55 == NULL ? NULL : (_tmp55 = (g_object_unref (_tmp55), NULL)));
	}
	_tmp57 = NULL;
	_tmp56 = NULL;
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_constant_new ((_tmp56 = vala_typeregister_function_get_type_flags (self))))));
	(_tmp57 == NULL ? NULL : (_tmp57 = (g_object_unref (_tmp57), NULL)));
	_tmp56 = (g_free (_tmp56), NULL);
	if (use_thread_safe && !plugin) {
		ValaCCodeDeclaration* temp_decl;
		ValaCCodeVariableDeclarator* _tmp58;
		temp_decl = vala_ccode_declaration_new ("GType");
		_tmp58 = NULL;
		vala_ccode_declaration_add_declarator (temp_decl, VALA_CCODE_DECLARATOR ((_tmp58 = vala_ccode_variable_declarator_new_with_initializer (type_id_name, VALA_CCODE_EXPRESSION (reg_call)))));
		(_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL)));
		vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE (temp_decl));
		(temp_decl == NULL ? NULL : (temp_decl = (g_object_unref (temp_decl), NULL)));
	} else {
		ValaCCodeExpressionStatement* _tmp61;
		ValaCCodeAssignment* _tmp60;
		ValaCCodeIdentifier* _tmp59;
		_tmp61 = NULL;
		_tmp60 = NULL;
		_tmp59 = NULL;
		vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((_tmp61 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new (type_id_name))), VALA_CCODE_EXPRESSION (reg_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
		(_tmp60 == NULL ? NULL : (_tmp60 = (g_object_unref (_tmp60), NULL)));
		(_tmp59 == NULL ? NULL : (_tmp59 = (g_object_unref (_tmp59), NULL)));
	}
	_tmp62 = NULL;
	vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((_tmp62 = vala_typeregister_function_get_type_interface_init_statements (self))));
	(_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL)));
	if (!plugin) {
		ValaCCodeExpression* condition;
		ValaCCodeIfStatement* cif;
		condition = NULL;
		/* the condition that guards the type initialisation*/
		if (use_thread_safe) {
			ValaCCodeIdentifier* _tmp63;
			ValaCCodeFunctionCall* _tmp64;
			ValaCCodeFunctionCall* enter;
			ValaCCodeUnaryExpression* _tmp67;
			ValaCCodeIdentifier* _tmp66;
			char* _tmp65;
			ValaCCodeExpression* _tmp69;
			ValaCCodeExpression* _tmp68;
			ValaCCodeIdentifier* _tmp70;
			ValaCCodeFunctionCall* _tmp71;
			ValaCCodeFunctionCall* leave;
			ValaCCodeUnaryExpression* _tmp74;
			ValaCCodeIdentifier* _tmp73;
			char* _tmp72;
			ValaCCodeIdentifier* _tmp75;
			ValaCCodeExpressionStatement* _tmp76;
			_tmp63 = NULL;
			_tmp64 = NULL;
			enter = (_tmp64 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_identifier_new ("g_once_init_enter")))), (_tmp63 == NULL ? NULL : (_tmp63 = (g_object_unref (_tmp63), NULL))), _tmp64);
			_tmp67 = NULL;
			_tmp66 = NULL;
			_tmp65 = NULL;
			vala_ccode_function_call_add_argument (enter, VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new ((_tmp65 = g_strconcat (type_id_name, "__volatile", NULL)))))))));
			(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
			(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
			_tmp65 = (g_free (_tmp65), NULL);
			_tmp69 = NULL;
			_tmp68 = NULL;
			condition = (_tmp69 = (_tmp68 = VALA_CCODE_EXPRESSION (enter), (_tmp68 == NULL ? NULL : g_object_ref (_tmp68))), (condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL))), _tmp69);
			_tmp70 = NULL;
			_tmp71 = NULL;
			leave = (_tmp71 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_identifier_new ("g_once_init_leave")))), (_tmp70 == NULL ? NULL : (_tmp70 = (g_object_unref (_tmp70), NULL))), _tmp71);
			_tmp74 = NULL;
			_tmp73 = NULL;
			_tmp72 = NULL;
			vala_ccode_function_call_add_argument (leave, VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new ((_tmp72 = g_strconcat (type_id_name, "__volatile", NULL)))))))));
			(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
			(_tmp73 == NULL ? NULL : (_tmp73 = (g_object_unref (_tmp73), NULL)));
			_tmp72 = (g_free (_tmp72), NULL);
			_tmp75 = NULL;
			vala_ccode_function_call_add_argument (leave, VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_identifier_new (type_id_name))));
			(_tmp75 == NULL ? NULL : (_tmp75 = (g_object_unref (_tmp75), NULL)));
			_tmp76 = NULL;
			vala_ccode_block_add_statement (type_init, VALA_CCODE_NODE ((_tmp76 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (leave)))));
			(_tmp76 == NULL ? NULL : (_tmp76 = (g_object_unref (_tmp76), NULL)));
			(enter == NULL ? NULL : (enter = (g_object_unref (enter), NULL)));
			(leave == NULL ? NULL : (leave = (g_object_unref (leave), NULL)));
		} else {
			ValaCCodeIdentifier* id;
			ValaCCodeConstant* zero;
			ValaCCodeExpression* _tmp77;
			id = vala_ccode_identifier_new (type_id_name);
			zero = vala_ccode_constant_new ("0");
			_tmp77 = NULL;
			condition = (_tmp77 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (id), VALA_CCODE_EXPRESSION (zero))), (condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL))), _tmp77);
			(id == NULL ? NULL : (id = (g_object_unref (id), NULL)));
			(zero == NULL ? NULL : (zero = (g_object_unref (zero), NULL)));
		}
		cif = vala_ccode_if_statement_new (condition, VALA_CCODE_STATEMENT (type_init), NULL);
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE (cif));
		(condition == NULL ? NULL : (condition = (g_object_unref (condition), NULL)));
		(cif == NULL ? NULL : (cif = (g_object_unref (cif), NULL)));
	} else {
		ValaCCodeBlock* _tmp79;
		ValaCCodeBlock* _tmp78;
		_tmp79 = NULL;
		_tmp78 = NULL;
		type_block = (_tmp79 = (_tmp78 = type_init, (_tmp78 == NULL ? NULL : g_object_ref (_tmp78))), (type_block == NULL ? NULL : (type_block = (g_object_unref (type_block), NULL))), _tmp79);
	}
	if (use_thread_safe) {
		ValaCCodeReturnStatement* _tmp82;
		ValaCCodeIdentifier* _tmp81;
		char* _tmp80;
		_tmp82 = NULL;
		_tmp81 = NULL;
		_tmp80 = NULL;
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE ((_tmp82 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_identifier_new ((_tmp80 = g_strconcat (type_id_name, "__volatile", NULL)))))))));
		(_tmp82 == NULL ? NULL : (_tmp82 = (g_object_unref (_tmp82), NULL)));
		(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
		_tmp80 = (g_free (_tmp80), NULL);
	} else {
		ValaCCodeReturnStatement* _tmp84;
		ValaCCodeIdentifier* _tmp83;
		_tmp84 = NULL;
		_tmp83 = NULL;
		vala_ccode_block_add_statement (type_block, VALA_CCODE_NODE ((_tmp84 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp83 = vala_ccode_identifier_new (type_id_name)))))));
		(_tmp84 == NULL ? NULL : (_tmp84 = (g_object_unref (_tmp84), NULL)));
		(_tmp83 == NULL ? NULL : (_tmp83 = (g_object_unref (_tmp83), NULL)));
	}
	_tmp85 = NULL;
	vala_ccode_fragment_append (self->priv->declaration_fragment, VALA_CCODE_NODE ((_tmp85 = vala_ccode_function_copy (fun))));
	(_tmp85 == NULL ? NULL : (_tmp85 = (g_object_unref (_tmp85), NULL)));
	vala_ccode_function_set_block (fun, type_block);
	vala_ccode_fragment_append (self->priv->definition_fragment, VALA_CCODE_NODE (fun));
	(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
	type_id_name = (g_free (type_id_name), NULL);
	(type_block == NULL ? NULL : (type_block = (g_object_unref (type_block), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (g_object_unref (cdecl_), NULL)));
	(fun == NULL ? NULL : (fun = (g_object_unref (fun), NULL)));
	(type_init == NULL ? NULL : (type_init = (g_object_unref (type_init), NULL)));
	(ctypedecl == NULL ? NULL : (ctypedecl = (g_object_unref (ctypedecl), NULL)));
	(reg_call == NULL ? NULL : (reg_call = (g_object_unref (reg_call), NULL)));
}


static ValaTypeSymbol* vala_typeregister_function_real_get_type_declaration (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_declaration'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the data type to be registered.
 *
 * @return type to be registered
 */
ValaTypeSymbol* vala_typeregister_function_get_type_declaration (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_declaration (self);
}


static char* vala_typeregister_function_real_get_type_struct_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_struct_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the type struct in C code.
 *
 * @return C struct name
 */
char* vala_typeregister_function_get_type_struct_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_struct_name (self);
}


static char* vala_typeregister_function_real_get_base_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_base_init_func_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the base_init function in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_base_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_base_init_func_name (self);
}


static char* vala_typeregister_function_real_get_class_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_class_init_func_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the class_init function in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_class_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_class_init_func_name (self);
}


static char* vala_typeregister_function_real_get_instance_struct_size (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_instance_struct_size'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the size of the instance struct in C code.
 *
 * @return C instance struct size
 */
char* vala_typeregister_function_get_instance_struct_size (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_struct_size (self);
}


static char* vala_typeregister_function_real_get_instance_init_func_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_instance_init_func_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the instance_init function in C code.
 *
 * @return C function name
 */
char* vala_typeregister_function_get_instance_init_func_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_instance_init_func_name (self);
}


static char* vala_typeregister_function_real_get_parent_type_name (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_parent_type_name'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns the name of the parent type in C code.
 *
 * @return C parent type name
 */
char* vala_typeregister_function_get_parent_type_name (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_parent_type_name (self);
}


/**
 * Returns the set of type flags to be applied when registering.
 *
 * @return type flags
 */
static char* vala_typeregister_function_real_get_type_flags (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	return g_strdup ("0");
}


char* vala_typeregister_function_get_type_flags (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_flags (self);
}


/**
 * Returns additional C declarations to setup interfaces.
 *
 * @return C declarations
 */
static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	return vala_ccode_fragment_new ();
}


ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_declaration (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_declaration (self);
}


static ValaCCodeFragment* vala_typeregister_function_real_get_type_interface_init_statements (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_type_interface_init_statements'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}


/**
 * Returns additional C initialization statements to setup interfaces.
 *
 * @return C statements
 */
ValaCCodeFragment* vala_typeregister_function_get_type_interface_init_statements (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_type_interface_init_statements (self);
}


/**
 * Returns the declaration for this type register function in C code.
 *
 * @return C function declaration fragment
 */
ValaCCodeFragment* vala_typeregister_function_get_declaration (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* _tmp0;
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->declaration_fragment, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
}


/**
 * Returns the definition for this type register function in C code.
 *
 * @return C function definition fragment
 */
ValaCCodeFragment* vala_typeregister_function_get_definition (ValaTypeRegisterFunction* self) {
	ValaCCodeFragment* _tmp0;
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	_tmp0 = NULL;
	return (_tmp0 = self->priv->definition_fragment, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
}


static ValaSymbolAccessibility vala_typeregister_function_real_get_accessibility (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), 0);
	g_critical ("Type `%s' does not implement abstract method `vala_typeregister_function_get_accessibility'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return 0;
}


/**
 * Returns the accessibility for this type.
 */
ValaSymbolAccessibility vala_typeregister_function_get_accessibility (ValaTypeRegisterFunction* self) {
	return VALA_TYPEREGISTER_FUNCTION_GET_CLASS (self)->get_accessibility (self);
}


ValaCCodeGenerator* vala_typeregister_function_get_codegen (ValaTypeRegisterFunction* self) {
	g_return_val_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self), NULL);
	return self->priv->_codegen;
}


void vala_typeregister_function_set_codegen (ValaTypeRegisterFunction* self, ValaCCodeGenerator* value) {
	ValaCCodeGenerator* _tmp2;
	ValaCCodeGenerator* _tmp1;
	g_return_if_fail (VALA_IS_TYPEREGISTER_FUNCTION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_codegen = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_codegen == NULL ? NULL : (self->priv->_codegen = (g_object_unref (self->priv->_codegen), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "codegen");
}


static void vala_typeregister_function_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaTypeRegisterFunction * self;
	self = VALA_TYPEREGISTER_FUNCTION (object);
	switch (property_id) {
		case VALA_TYPEREGISTER_FUNCTION_CODEGEN:
		g_value_set_object (value, vala_typeregister_function_get_codegen (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_typeregister_function_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaTypeRegisterFunction * self;
	self = VALA_TYPEREGISTER_FUNCTION (object);
	switch (property_id) {
		case VALA_TYPEREGISTER_FUNCTION_CODEGEN:
		vala_typeregister_function_set_codegen (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_typeregister_function_class_init (ValaTypeRegisterFunctionClass * klass) {
	vala_typeregister_function_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTypeRegisterFunctionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_typeregister_function_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_typeregister_function_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_typeregister_function_finalize;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_declaration = vala_typeregister_function_real_get_type_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_struct_name = vala_typeregister_function_real_get_type_struct_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_base_init_func_name = vala_typeregister_function_real_get_base_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_class_init_func_name = vala_typeregister_function_real_get_class_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_struct_size = vala_typeregister_function_real_get_instance_struct_size;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_instance_init_func_name = vala_typeregister_function_real_get_instance_init_func_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_parent_type_name = vala_typeregister_function_real_get_parent_type_name;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_flags = vala_typeregister_function_real_get_type_flags;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_declaration = vala_typeregister_function_real_get_type_interface_init_declaration;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_type_interface_init_statements = vala_typeregister_function_real_get_type_interface_init_statements;
	VALA_TYPEREGISTER_FUNCTION_CLASS (klass)->get_accessibility = vala_typeregister_function_real_get_accessibility;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_TYPEREGISTER_FUNCTION_CODEGEN, g_param_spec_object ("codegen", "codegen", "codegen", VALA_TYPE_CCODE_GENERATOR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_typeregister_function_instance_init (ValaTypeRegisterFunction * self) {
	self->priv = VALA_TYPEREGISTER_FUNCTION_GET_PRIVATE (self);
	self->priv->declaration_fragment = vala_ccode_fragment_new ();
	self->priv->definition_fragment = vala_ccode_fragment_new ();
}


static void vala_typeregister_function_finalize (GObject * obj) {
	ValaTypeRegisterFunction * self;
	self = VALA_TYPEREGISTER_FUNCTION (obj);
	(self->priv->declaration_fragment == NULL ? NULL : (self->priv->declaration_fragment = (g_object_unref (self->priv->declaration_fragment), NULL)));
	(self->priv->definition_fragment == NULL ? NULL : (self->priv->definition_fragment = (g_object_unref (self->priv->definition_fragment), NULL)));
	(self->priv->_codegen == NULL ? NULL : (self->priv->_codegen = (g_object_unref (self->priv->_codegen), NULL)));
	G_OBJECT_CLASS (vala_typeregister_function_parent_class)->finalize (obj);
}


GType vala_typeregister_function_get_type (void) {
	static GType vala_typeregister_function_type_id = 0;
	if (vala_typeregister_function_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeRegisterFunctionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeregister_function_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeRegisterFunction), 0, (GInstanceInitFunc) vala_typeregister_function_instance_init };
		vala_typeregister_function_type_id = g_type_register_static (G_TYPE_OBJECT, "ValaTypeRegisterFunction", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_typeregister_function_type_id;
}




