/* valaccodeelementaccessbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeelementaccessbinding.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <vala/valaexpression.h>
#include <vala/valadatatype.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valaintegerliteral.h>
#include <vala/valamemberaccess.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valasymbol.h>
#include <vala/valascope.h>
#include <vala/valamethod.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include <vala/valaformalparameter.h>
#include <vala/valasemanticanalyzer.h>
#include <ccode/valaccodecastexpression.h>
#include <vala/valasignal.h>
#include <vala/valastringliteral.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodeparenthesizedexpression.h>
#include <ccode/valaccodeelementaccess.h>
#include <gobject/valaccodegenerator.h>




struct _ValaCCodeElementAccessBindingPrivate {
	ValaElementAccess* _element_access;
};

#define VALA_CCODE_ELEMENT_ACCESS_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_ELEMENT_ACCESS_BINDING, ValaCCodeElementAccessBindingPrivate))
enum  {
	VALA_CCODE_ELEMENT_ACCESS_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_ELEMENT_ACCESS_BINDING_ELEMENT_ACCESS
};
static void vala_ccode_element_access_binding_real_emit (ValaCCodeBinding* base);
static gpointer vala_ccode_element_access_binding_parent_class = NULL;
static void vala_ccode_element_access_binding_finalize (GObject * obj);



ValaCCodeElementAccessBinding* vala_ccode_element_access_binding_new (ValaCCodeGenerator* codegen, ValaElementAccess* element_access) {
	ValaCCodeElementAccessBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_ELEMENT_ACCESS (element_access), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_ELEMENT_ACCESS_BINDING, 0, NULL);
	vala_ccode_element_access_binding_set_element_access (self, element_access);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_element_access_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeElementAccessBinding * self;
	ValaElementAccess* _tmp0;
	ValaElementAccess* expr;
	GeeList* indices;
	gint rank;
	ValaTypeSymbol* _tmp1;
	ValaTypeSymbol* container_type;
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* ccontainer;
	ValaCCodeExpression* _tmp4;
	ValaExpression* _tmp3;
	ValaCCodeExpression* _tmp5;
	ValaCCodeExpression* cindex;
	self = VALA_CCODE_ELEMENT_ACCESS_BINDING (base);
	_tmp0 = NULL;
	expr = (_tmp0 = self->priv->_element_access, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	indices = vala_element_access_get_indices (expr);
	rank = gee_collection_get_size (GEE_COLLECTION (indices));
	_tmp1 = NULL;
	container_type = (_tmp1 = vala_data_type_get_data_type (vala_expression_get_value_type (vala_element_access_get_container (expr))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
	_tmp2 = NULL;
	ccontainer = (_tmp2 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_element_access_get_container (expr)))), (_tmp2 == NULL ? NULL : g_object_ref (_tmp2)));
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp5 = NULL;
	cindex = (_tmp5 = (_tmp4 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp3 = ((ValaExpression*) (gee_list_get (((GeeList*) (indices)), 0))))))), (_tmp4 == NULL ? NULL : g_object_ref (_tmp4))), (_tmp3 == NULL ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL))), _tmp5);
	if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference (vala_element_access_get_container (expr)))) {
		ValaExpression* _tmp6;
		ValaIntegerLiteral* lit;
		ValaMemberAccess* _tmp8;
		ValaExpression* _tmp7;
		ValaMemberAccess* memberaccess;
		/* Figure if cindex is a constant expression and calculate dim...*/
		_tmp6 = NULL;
		lit = (_tmp6 = ((ValaExpression*) (gee_list_get (((GeeList*) (indices)), 0))), (VALA_IS_INTEGER_LITERAL (_tmp6) ? ((ValaIntegerLiteral*) (_tmp6)) : NULL));
		_tmp8 = NULL;
		_tmp7 = NULL;
		memberaccess = (_tmp8 = (_tmp7 = vala_element_access_get_container (expr), (VALA_IS_MEMBER_ACCESS (_tmp7) ? ((ValaMemberAccess*) (_tmp7)) : NULL)), (_tmp8 == NULL ? NULL : g_object_ref (_tmp8)));
		if (lit != NULL && memberaccess != NULL) {
			gint dim;
			ValaCCodeExpression* _tmp9;
			dim = atoi (vala_integer_literal_get_value (lit));
			_tmp9 = NULL;
			vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), (_tmp9 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_member_access_get_inner (memberaccess), dim + 1)));
			(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
		}
		(lit == NULL ? NULL : (lit = (g_object_unref (lit), NULL)));
		(memberaccess == NULL ? NULL : (memberaccess = (g_object_unref (memberaccess), NULL)));
	} else {
		if (container_type == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
			ValaCCodeIdentifier* _tmp10;
			ValaCCodeFunctionCall* _tmp11;
			ValaCCodeFunctionCall* coffsetcall;
			ValaCCodeIdentifier* _tmp12;
			ValaCCodeFunctionCall* _tmp13;
			ValaCCodeFunctionCall* ccall;
			/* access to unichar in a string*/
			_tmp10 = NULL;
			_tmp11 = NULL;
			coffsetcall = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("g_utf8_offset_to_pointer")))), (_tmp10 == NULL ? NULL : (_tmp10 = (g_object_unref (_tmp10), NULL))), _tmp11);
			vala_ccode_function_call_add_argument (coffsetcall, ccontainer);
			vala_ccode_function_call_add_argument (coffsetcall, cindex);
			_tmp12 = NULL;
			_tmp13 = NULL;
			ccall = (_tmp13 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("g_utf8_get_char")))), (_tmp12 == NULL ? NULL : (_tmp12 = (g_object_unref (_tmp12), NULL))), _tmp13);
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (coffsetcall));
			vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccall));
			(coffsetcall == NULL ? NULL : (coffsetcall = (g_object_unref (coffsetcall), NULL)));
			(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
		} else {
			if (container_type != NULL && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type != NULL && vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type != NULL && (vala_typesymbol_is_subtype_of (container_type, VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type)) || vala_typesymbol_is_subtype_of (container_type, VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type)))) {
				ValaTypeSymbol* collection_iface;
				ValaMethod* get_method;
				GeeList* get_params;
				GeeIterator* get_params_it;
				ValaFormalParameter* get_param;
				ValaCCodeIdentifier* _tmp20;
				char* _tmp19;
				ValaCCodeFunctionCall* _tmp21;
				ValaCCodeFunctionCall* get_ccall;
				ValaCCodeCastExpression* _tmp24;
				char* _tmp23;
				char* _tmp22;
				ValaCCodeExpression* _tmp25;
				collection_iface = NULL;
				if (vala_typesymbol_is_subtype_of (container_type, VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type))) {
					ValaTypeSymbol* _tmp15;
					ValaTypeSymbol* _tmp14;
					_tmp15 = NULL;
					_tmp14 = NULL;
					collection_iface = (_tmp15 = (_tmp14 = VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->list_type), (_tmp14 == NULL ? NULL : g_object_ref (_tmp14))), (collection_iface == NULL ? NULL : (collection_iface = (g_object_unref (collection_iface), NULL))), _tmp15);
				} else {
					if (vala_typesymbol_is_subtype_of (container_type, VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type))) {
						ValaTypeSymbol* _tmp17;
						ValaTypeSymbol* _tmp16;
						_tmp17 = NULL;
						_tmp16 = NULL;
						collection_iface = (_tmp17 = (_tmp16 = VALA_TYPESYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->map_type), (_tmp16 == NULL ? NULL : g_object_ref (_tmp16))), (collection_iface == NULL ? NULL : (collection_iface = (g_object_unref (collection_iface), NULL))), _tmp17);
					}
				}
				get_method = VALA_METHOD (vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (collection_iface)), "get"));
				get_params = vala_method_get_parameters (get_method);
				get_params_it = gee_iterable_iterator (GEE_ITERABLE (get_params));
				gee_iterator_next (get_params_it);
				get_param = ((ValaFormalParameter*) (gee_iterator_get (get_params_it)));
				if (vala_data_type_get_type_parameter (vala_formal_parameter_get_parameter_type (get_param)) != NULL) {
					ValaDataType* index_type;
					ValaCCodeExpression* _tmp18;
					index_type = vala_semantic_analyzer_get_actual_type (vala_expression_get_value_type (vala_element_access_get_container (expr)), VALA_SYMBOL (get_method), vala_formal_parameter_get_parameter_type (get_param), VALA_CODE_NODE (expr));
					_tmp18 = NULL;
					cindex = (_tmp18 = vala_ccode_generator_convert_to_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), cindex, index_type), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), _tmp18);
					(index_type == NULL ? NULL : (index_type = (g_object_unref (index_type), NULL)));
				}
				_tmp20 = NULL;
				_tmp19 = NULL;
				_tmp21 = NULL;
				get_ccall = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ((_tmp19 = vala_method_get_cname (get_method)))))), (_tmp20 == NULL ? NULL : (_tmp20 = (g_object_unref (_tmp20), NULL))), (_tmp19 = (g_free (_tmp19), NULL)), _tmp21);
				_tmp24 = NULL;
				_tmp23 = NULL;
				_tmp22 = NULL;
				vala_ccode_function_call_add_argument (get_ccall, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_cast_expression_new (ccontainer, (_tmp23 = g_strconcat ((_tmp22 = vala_typesymbol_get_cname (collection_iface, FALSE)), "*", NULL))))));
				(_tmp24 == NULL ? NULL : (_tmp24 = (g_object_unref (_tmp24), NULL)));
				_tmp23 = (g_free (_tmp23), NULL);
				_tmp22 = (g_free (_tmp22), NULL);
				vala_ccode_function_call_add_argument (get_ccall, cindex);
				_tmp25 = NULL;
				vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), (_tmp25 = vala_ccode_generator_convert_from_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION (get_ccall), vala_expression_get_value_type (VALA_EXPRESSION (expr)))));
				(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
				(collection_iface == NULL ? NULL : (collection_iface = (g_object_unref (collection_iface), NULL)));
				(get_method == NULL ? NULL : (get_method = (g_object_unref (get_method), NULL)));
				(get_params == NULL ? NULL : (get_params = (g_object_unref (get_params), NULL)));
				(get_params_it == NULL ? NULL : (get_params_it = (g_object_unref (get_params_it), NULL)));
				(get_param == NULL ? NULL : (get_param = (g_object_unref (get_param), NULL)));
				(get_ccall == NULL ? NULL : (get_ccall = (g_object_unref (get_ccall), NULL)));
			} else {
				if (VALA_IS_MEMBER_ACCESS (vala_element_access_get_container (expr)) && VALA_IS_SIGNAL (vala_expression_get_symbol_reference (vala_element_access_get_container (expr)))) {
					ValaSignal* _tmp26;
					ValaSignal* sig;
					ValaMemberAccess* _tmp27;
					ValaMemberAccess* ma;
					GeeList* _tmp28;
					ValaExpression* _tmp29;
					ValaStringLiteral* _tmp30;
					ValaStringLiteral* detail_expr;
					char* signal_detail;
					ValaCCodeIdentifier* _tmp31;
					ValaCCodeFunctionCall* _tmp32;
					ValaCCodeFunctionCall* ccall;
					ValaCCodeIdentifier* _tmp33;
					ValaCCodeFunctionCall* _tmp34;
					ValaCCodeFunctionCall* ccast;
					ValaCCodeConstant* _tmp35;
					/* detailed signal emission*/
					_tmp26 = NULL;
					sig = (_tmp26 = VALA_SIGNAL (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp26 == NULL ? NULL : g_object_ref (_tmp26)));
					_tmp27 = NULL;
					ma = (_tmp27 = VALA_MEMBER_ACCESS (vala_element_access_get_container (expr)), (_tmp27 == NULL ? NULL : g_object_ref (_tmp27)));
					_tmp28 = NULL;
					_tmp29 = NULL;
					_tmp30 = NULL;
					detail_expr = (_tmp30 = (_tmp29 = ((ValaExpression*) (gee_list_get ((_tmp28 = vala_element_access_get_indices (expr)), 0))), (VALA_IS_STRING_LITERAL (_tmp29) ? ((ValaStringLiteral*) (_tmp29)) : NULL)), (_tmp28 == NULL ? NULL : (_tmp28 = (g_object_unref (_tmp28), NULL))), _tmp30);
					signal_detail = vala_string_literal_eval (detail_expr);
					_tmp31 = NULL;
					_tmp32 = NULL;
					ccall = (_tmp32 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("g_signal_emit_by_name")))), (_tmp31 == NULL ? NULL : (_tmp31 = (g_object_unref (_tmp31), NULL))), _tmp32);
					/* FIXME: use C cast if debugging disabled*/
					_tmp33 = NULL;
					_tmp34 = NULL;
					ccast = (_tmp34 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp33 == NULL ? NULL : (_tmp33 = (g_object_unref (_tmp33), NULL))), _tmp34);
					vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (ma)))));
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
					_tmp35 = NULL;
					vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp35 = vala_signal_get_canonical_cconstant (sig, signal_detail))));
					(_tmp35 == NULL ? NULL : (_tmp35 = (g_object_unref (_tmp35), NULL)));
					vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION (ccall));
					(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
					(ma == NULL ? NULL : (ma = (g_object_unref (ma), NULL)));
					(detail_expr == NULL ? NULL : (detail_expr = (g_object_unref (detail_expr), NULL)));
					signal_detail = (g_free (signal_detail), NULL);
					(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
					(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
				} else {
					ValaCCodeElementAccess* _tmp42;
					{
						gint i;
						/* access to element in an array*/
						i = 1;
						for (; i < rank; i++) {
							ValaCCodeExpression* _tmp37;
							ValaCCodeParenthesizedExpression* _tmp36;
							ValaCCodeBinaryExpression* _tmp38;
							ValaCCodeBinaryExpression* cmul;
							ValaCCodeExpression* _tmp41;
							ValaCCodeParenthesizedExpression* _tmp40;
							ValaExpression* _tmp39;
							_tmp37 = NULL;
							_tmp36 = NULL;
							_tmp38 = NULL;
							cmul = (_tmp38 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_parenthesized_expression_new (cindex))), (_tmp37 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_element_access_get_container (expr), i + 1))), (_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL))), (_tmp36 == NULL ? NULL : (_tmp36 = (g_object_unref (_tmp36), NULL))), _tmp38);
							_tmp41 = NULL;
							_tmp40 = NULL;
							_tmp39 = NULL;
							cindex = (_tmp41 = VALA_CCODE_EXPRESSION (vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, VALA_CCODE_EXPRESSION (cmul), VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_parenthesized_expression_new (VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE ((_tmp39 = ((ValaExpression*) (gee_list_get (((GeeList*) (indices)), i)))))))))))), (cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL))), _tmp41);
							(_tmp40 == NULL ? NULL : (_tmp40 = (g_object_unref (_tmp40), NULL)));
							(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
							(cmul == NULL ? NULL : (cmul = (g_object_unref (cmul), NULL)));
						}
					}
					_tmp42 = NULL;
					vala_ccode_expression_binding_set_codenode (VALA_CCODE_EXPRESSION_BINDING (self), VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_element_access_new (ccontainer, cindex))));
					(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
				}
			}
		}
	}
	vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (vala_ccode_expression_binding_get_codenode (VALA_CCODE_EXPRESSION_BINDING (self))));
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(indices == NULL ? NULL : (indices = (g_object_unref (indices), NULL)));
	(container_type == NULL ? NULL : (container_type = (g_object_unref (container_type), NULL)));
	(ccontainer == NULL ? NULL : (ccontainer = (g_object_unref (ccontainer), NULL)));
	(cindex == NULL ? NULL : (cindex = (g_object_unref (cindex), NULL)));
}


ValaElementAccess* vala_ccode_element_access_binding_get_element_access (ValaCCodeElementAccessBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_ELEMENT_ACCESS_BINDING (self), NULL);
	return self->priv->_element_access;
}


void vala_ccode_element_access_binding_set_element_access (ValaCCodeElementAccessBinding* self, ValaElementAccess* value) {
	ValaElementAccess* _tmp2;
	ValaElementAccess* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_ELEMENT_ACCESS_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_element_access = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_element_access == NULL ? NULL : (self->priv->_element_access = (g_object_unref (self->priv->_element_access), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "element-access");
}


static void vala_ccode_element_access_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeElementAccessBinding * self;
	self = VALA_CCODE_ELEMENT_ACCESS_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_ELEMENT_ACCESS_BINDING_ELEMENT_ACCESS:
		g_value_set_object (value, vala_ccode_element_access_binding_get_element_access (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_element_access_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeElementAccessBinding * self;
	self = VALA_CCODE_ELEMENT_ACCESS_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_ELEMENT_ACCESS_BINDING_ELEMENT_ACCESS:
		vala_ccode_element_access_binding_set_element_access (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_element_access_binding_class_init (ValaCCodeElementAccessBindingClass * klass) {
	vala_ccode_element_access_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeElementAccessBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_element_access_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_element_access_binding_set_property;
	G_OBJECT_CLASS (klass)->finalize = vala_ccode_element_access_binding_finalize;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_element_access_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_ELEMENT_ACCESS_BINDING_ELEMENT_ACCESS, g_param_spec_object ("element-access", "element-access", "element-access", VALA_TYPE_ELEMENT_ACCESS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_element_access_binding_instance_init (ValaCCodeElementAccessBinding * self) {
	self->priv = VALA_CCODE_ELEMENT_ACCESS_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_element_access_binding_finalize (GObject * obj) {
	ValaCCodeElementAccessBinding * self;
	self = VALA_CCODE_ELEMENT_ACCESS_BINDING (obj);
	(self->priv->_element_access == NULL ? NULL : (self->priv->_element_access = (g_object_unref (self->priv->_element_access), NULL)));
	G_OBJECT_CLASS (vala_ccode_element_access_binding_parent_class)->finalize (obj);
}


GType vala_ccode_element_access_binding_get_type (void) {
	static GType vala_ccode_element_access_binding_type_id = 0;
	if (vala_ccode_element_access_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeElementAccessBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_element_access_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeElementAccessBinding), 0, (GInstanceInitFunc) vala_ccode_element_access_binding_instance_init };
		vala_ccode_element_access_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION_BINDING, "ValaCCodeElementAccessBinding", &g_define_type_info, 0);
	}
	return vala_ccode_element_access_binding_type_id;
}




