/* valadynamicproperty.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valadynamicproperty.h>
#include <gee/arraylist.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <vala/valasymbol.h>
#include <vala/valacodegenerator.h>




struct _ValaDynamicPropertyPrivate {
	ValaDataType* _dynamic_type;
	char* cname;
};

#define VALA_DYNAMIC_PROPERTY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DYNAMIC_PROPERTY, ValaDynamicPropertyPrivate))
enum  {
	VALA_DYNAMIC_PROPERTY_DUMMY_PROPERTY,
	VALA_DYNAMIC_PROPERTY_DYNAMIC_TYPE
};
static GeeList* vala_dynamic_property_real_get_cheader_filenames (ValaSymbol* base);
static ValaCodeBinding* vala_dynamic_property_real_create_code_binding (ValaCodeNode* base, ValaCodeGenerator* codegen);
static gpointer vala_dynamic_property_parent_class = NULL;
static void vala_dynamic_property_dispose (GObject * obj);



ValaDynamicProperty* vala_dynamic_property_new (ValaDataType* dynamic_type, const char* name, ValaSourceReference* source_reference) {
	ValaDynamicProperty * self;
	g_return_val_if_fail (VALA_IS_DATA_TYPE (dynamic_type), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = g_object_newv (VALA_TYPE_DYNAMIC_PROPERTY, 0, NULL);
	vala_dynamic_property_set_dynamic_type (self, dynamic_type);
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


static GeeList* vala_dynamic_property_real_get_cheader_filenames (ValaSymbol* base) {
	ValaDynamicProperty * self;
	self = VALA_DYNAMIC_PROPERTY (base);
	return GEE_LIST (gee_array_list_new (G_TYPE_STRING, ((GBoxedCopyFunc) (g_strdup)), g_free, g_direct_equal));
}


static ValaCodeBinding* vala_dynamic_property_real_create_code_binding (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaDynamicProperty * self;
	self = VALA_DYNAMIC_PROPERTY (base);
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (codegen), NULL);
	return vala_code_generator_create_dynamic_property_binding (codegen, self);
}


ValaDataType* vala_dynamic_property_get_dynamic_type (ValaDynamicProperty* self) {
	g_return_val_if_fail (VALA_IS_DYNAMIC_PROPERTY (self), NULL);
	return self->priv->_dynamic_type;
}


void vala_dynamic_property_set_dynamic_type (ValaDynamicProperty* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (VALA_IS_DYNAMIC_PROPERTY (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_dynamic_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_dynamic_type == NULL ? NULL : (self->priv->_dynamic_type = (g_object_unref (self->priv->_dynamic_type), NULL))), _tmp2);
}


static void vala_dynamic_property_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaDynamicProperty * self;
	self = VALA_DYNAMIC_PROPERTY (object);
	switch (property_id) {
		case VALA_DYNAMIC_PROPERTY_DYNAMIC_TYPE:
		g_value_set_object (value, vala_dynamic_property_get_dynamic_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_dynamic_property_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaDynamicProperty * self;
	self = VALA_DYNAMIC_PROPERTY (object);
	switch (property_id) {
		case VALA_DYNAMIC_PROPERTY_DYNAMIC_TYPE:
		vala_dynamic_property_set_dynamic_type (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_dynamic_property_class_init (ValaDynamicPropertyClass * klass) {
	vala_dynamic_property_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaDynamicPropertyPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_dynamic_property_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_dynamic_property_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_dynamic_property_dispose;
	VALA_SYMBOL_CLASS (klass)->get_cheader_filenames = vala_dynamic_property_real_get_cheader_filenames;
	VALA_CODE_NODE_CLASS (klass)->create_code_binding = vala_dynamic_property_real_create_code_binding;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_DYNAMIC_PROPERTY_DYNAMIC_TYPE, g_param_spec_object ("dynamic-type", "dynamic-type", "dynamic-type", VALA_TYPE_DATA_TYPE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_dynamic_property_instance_init (ValaDynamicProperty * self) {
	self->priv = VALA_DYNAMIC_PROPERTY_GET_PRIVATE (self);
}


static void vala_dynamic_property_dispose (GObject * obj) {
	ValaDynamicProperty * self;
	self = VALA_DYNAMIC_PROPERTY (obj);
	(self->priv->_dynamic_type == NULL ? NULL : (self->priv->_dynamic_type = (g_object_unref (self->priv->_dynamic_type), NULL)));
	self->priv->cname = (g_free (self->priv->cname), NULL);
	G_OBJECT_CLASS (vala_dynamic_property_parent_class)->dispose (obj);
}


GType vala_dynamic_property_get_type (void) {
	static GType vala_dynamic_property_type_id = 0;
	if (G_UNLIKELY (vala_dynamic_property_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDynamicPropertyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_dynamic_property_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDynamicProperty), 0, (GInstanceInitFunc) vala_dynamic_property_instance_init };
		vala_dynamic_property_type_id = g_type_register_static (VALA_TYPE_PROPERTY, "ValaDynamicProperty", &g_define_type_info, 0);
	}
	return vala_dynamic_property_type_id;
}




