/* valaccodeincludedirective.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeincludedirective.h>
#include <ccode/valaccodelinedirective.h>




struct _ValaCCodeIncludeDirectivePrivate {
	char* _filename;
	gboolean _local;
};

#define VALA_CCODE_INCLUDE_DIRECTIVE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_INCLUDE_DIRECTIVE, ValaCCodeIncludeDirectivePrivate))
enum  {
	VALA_CCODE_INCLUDE_DIRECTIVE_DUMMY_PROPERTY,
	VALA_CCODE_INCLUDE_DIRECTIVE_FILENAME,
	VALA_CCODE_INCLUDE_DIRECTIVE_LOCAL
};
static void vala_ccode_include_directive_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_include_directive_parent_class = NULL;
static void vala_ccode_include_directive_dispose (GObject * obj);



ValaCCodeIncludeDirective* vala_ccode_include_directive_new (const char* _filename, gboolean _local) {
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeIncludeDirective * self;
	g_return_val_if_fail (_filename != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "filename";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, _filename);
	__params_it++;
	self = g_object_newv (VALA_TYPE_CCODE_INCLUDE_DIRECTIVE, __params_it - __params, __params);
	vala_ccode_include_directive_set_local (self, _local);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_ccode_include_directive_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeIncludeDirective * self;
	self = VALA_CCODE_INCLUDE_DIRECTIVE (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer, NULL);
	vala_ccode_writer_write_string (writer, "#include ");
	if (self->priv->_local) {
		vala_ccode_writer_write_string (writer, "\"");
		vala_ccode_writer_write_string (writer, self->priv->_filename);
		vala_ccode_writer_write_string (writer, "\"");
	} else {
		vala_ccode_writer_write_string (writer, "<");
		vala_ccode_writer_write_string (writer, self->priv->_filename);
		vala_ccode_writer_write_string (writer, ">");
	}
	vala_ccode_writer_write_newline (writer);
}


const char* vala_ccode_include_directive_get_filename (ValaCCodeIncludeDirective* self) {
	g_return_val_if_fail (VALA_IS_CCODE_INCLUDE_DIRECTIVE (self), NULL);
	return self->priv->_filename;
}


void vala_ccode_include_directive_set_filename (ValaCCodeIncludeDirective* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_INCLUDE_DIRECTIVE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_filename = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_filename = (g_free (self->priv->_filename), NULL)), _tmp2);
}


gboolean vala_ccode_include_directive_get_local (ValaCCodeIncludeDirective* self) {
	g_return_val_if_fail (VALA_IS_CCODE_INCLUDE_DIRECTIVE (self), FALSE);
	return self->priv->_local;
}


void vala_ccode_include_directive_set_local (ValaCCodeIncludeDirective* self, gboolean value) {
	g_return_if_fail (VALA_IS_CCODE_INCLUDE_DIRECTIVE (self));
	self->priv->_local = value;
}


static void vala_ccode_include_directive_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeIncludeDirective * self;
	self = VALA_CCODE_INCLUDE_DIRECTIVE (object);
	switch (property_id) {
		case VALA_CCODE_INCLUDE_DIRECTIVE_FILENAME:
		g_value_set_string (value, vala_ccode_include_directive_get_filename (self));
		break;
		case VALA_CCODE_INCLUDE_DIRECTIVE_LOCAL:
		g_value_set_boolean (value, vala_ccode_include_directive_get_local (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_include_directive_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeIncludeDirective * self;
	self = VALA_CCODE_INCLUDE_DIRECTIVE (object);
	switch (property_id) {
		case VALA_CCODE_INCLUDE_DIRECTIVE_FILENAME:
		vala_ccode_include_directive_set_filename (self, g_value_get_string (value));
		break;
		case VALA_CCODE_INCLUDE_DIRECTIVE_LOCAL:
		vala_ccode_include_directive_set_local (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_include_directive_class_init (ValaCCodeIncludeDirectiveClass * klass) {
	vala_ccode_include_directive_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeIncludeDirectivePrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_include_directive_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_include_directive_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_include_directive_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_include_directive_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_INCLUDE_DIRECTIVE_FILENAME, g_param_spec_string ("filename", "filename", "filename", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_INCLUDE_DIRECTIVE_LOCAL, g_param_spec_boolean ("local", "local", "local", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_include_directive_instance_init (ValaCCodeIncludeDirective * self) {
	self->priv = VALA_CCODE_INCLUDE_DIRECTIVE_GET_PRIVATE (self);
}


static void vala_ccode_include_directive_dispose (GObject * obj) {
	ValaCCodeIncludeDirective * self;
	self = VALA_CCODE_INCLUDE_DIRECTIVE (obj);
	self->priv->_filename = (g_free (self->priv->_filename), NULL);
	G_OBJECT_CLASS (vala_ccode_include_directive_parent_class)->dispose (obj);
}


GType vala_ccode_include_directive_get_type (void) {
	static GType vala_ccode_include_directive_type_id = 0;
	if (G_UNLIKELY (vala_ccode_include_directive_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeIncludeDirectiveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_include_directive_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeIncludeDirective), 0, (GInstanceInitFunc) vala_ccode_include_directive_instance_init };
		vala_ccode_include_directive_type_id = g_type_register_static (VALA_TYPE_CCODE_NODE, "ValaCCodeIncludeDirective", &g_define_type_info, 0);
	}
	return vala_ccode_include_directive_type_id;
}




