/* valacodecontext.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALACODECONTEXT_H__
#define __VALA_VALACODECONTEXT_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/collection.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>

G_BEGIN_DECLS


#define VALA_TYPE_CODE_CONTEXT (vala_code_context_get_type ())
#define VALA_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContext))
#define VALA_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))
#define VALA_IS_CODE_CONTEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_CODE_CONTEXT))
#define VALA_IS_CODE_CONTEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_CODE_CONTEXT))
#define VALA_CODE_CONTEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_CODE_CONTEXT, ValaCodeContextClass))

typedef struct _ValaCodeContextPrivate ValaCodeContextPrivate;

/**
 * The root of the code tree.
 */
struct _ValaCodeContext {
	GObject parent_instance;
	ValaCodeContextPrivate * priv;
};

struct _ValaCodeContextClass {
	GObjectClass parent_class;
};


ValaCodeContext* vala_code_context_new (void);
GeeCollection* vala_code_context_get_source_files (ValaCodeContext* self);
GeeCollection* vala_code_context_get_c_source_files (ValaCodeContext* self);
void vala_code_context_add_source_file (ValaCodeContext* self, ValaSourceFile* file);
void vala_code_context_add_c_source_file (ValaCodeContext* self, const char* file);
GeeCollection* vala_code_context_get_packages (ValaCodeContext* self);
gboolean vala_code_context_has_package (ValaCodeContext* self, const char* pkg);
void vala_code_context_add_package (ValaCodeContext* self, const char* pkg);
void vala_code_context_accept (ValaCodeContext* self, ValaCodeVisitor* visitor);
void vala_code_context_find_header_cycles (ValaCodeContext* self);
void vala_code_context_add_define (ValaCodeContext* self, const char* define);
gboolean vala_code_context_ignore_node (ValaCodeContext* self, ValaCodeNode* node);
char* vala_code_context_get_package_path (ValaCodeContext* self, const char* pkg, int vapi_directories_length1, char** vapi_directories);
void vala_code_context_add_dynamic_member (ValaCodeContext* self, ValaSymbol* dynamic_member);
char* vala_code_context_get_library (ValaCodeContext* self);
void vala_code_context_set_library (ValaCodeContext* self, const char* value);
gboolean vala_code_context_get_memory_management (ValaCodeContext* self);
void vala_code_context_set_memory_management (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_assert (ValaCodeContext* self);
void vala_code_context_set_assert (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_checking (ValaCodeContext* self);
void vala_code_context_set_checking (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_non_null (ValaCodeContext* self);
void vala_code_context_set_non_null (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_non_null_experimental (ValaCodeContext* self);
void vala_code_context_set_non_null_experimental (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_ccode_only (ValaCodeContext* self);
void vala_code_context_set_ccode_only (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_compile_only (ValaCodeContext* self);
void vala_code_context_set_compile_only (ValaCodeContext* self, gboolean value);
char* vala_code_context_get_output (ValaCodeContext* self);
void vala_code_context_set_output (ValaCodeContext* self, const char* value);
char* vala_code_context_get_basedir (ValaCodeContext* self);
void vala_code_context_set_basedir (ValaCodeContext* self, const char* value);
char* vala_code_context_get_directory (ValaCodeContext* self);
void vala_code_context_set_directory (ValaCodeContext* self, const char* value);
gboolean vala_code_context_get_debug (ValaCodeContext* self);
void vala_code_context_set_debug (ValaCodeContext* self, gboolean value);
gint vala_code_context_get_optlevel (ValaCodeContext* self);
void vala_code_context_set_optlevel (ValaCodeContext* self, gint value);
gboolean vala_code_context_get_thread (ValaCodeContext* self);
void vala_code_context_set_thread (ValaCodeContext* self, gboolean value);
ValaMethod* vala_code_context_get_module_init_method (ValaCodeContext* self);
void vala_code_context_set_module_init_method (ValaCodeContext* self, ValaMethod* value);
gboolean vala_code_context_get_save_temps (ValaCodeContext* self);
void vala_code_context_set_save_temps (ValaCodeContext* self, gboolean value);
gboolean vala_code_context_get_save_csources (ValaCodeContext* self);
gboolean vala_code_context_get_save_cheaders (ValaCodeContext* self);
ValaNamespace* vala_code_context_get_root (ValaCodeContext* self);
ValaCodeGenerator* vala_code_context_get_codegen (ValaCodeContext* self);
void vala_code_context_set_codegen (ValaCodeContext* self, ValaCodeGenerator* value);
GType vala_code_context_get_type (void);


G_END_DECLS

#endif
