/* valatypeparameter.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valatypeparameter.h>
#include <gee/map.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaTypeParameterPrivate {
	GeeMap* array_types;
};
#define VALA_TYPEPARAMETER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_TYPEPARAMETER, ValaTypeParameterPrivate))
enum  {
	VALA_TYPEPARAMETER_DUMMY_PROPERTY
};
static void vala_typeparameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_typeparameter_parent_class = NULL;
static void vala_typeparameter_dispose (GObject * obj);



/**
 * Creates a new generic type parameter.
 *
 * @param name   parameter name
 * @param source reference to source code
 * @return       newly created generic type parameter
 */
ValaTypeParameter* vala_typeparameter_new (const char* _name, ValaSourceReference* source) {
	ValaTypeParameter * self;
	g_return_val_if_fail (_name != NULL, NULL);
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (source), NULL);
	self = g_object_newv (VALA_TYPE_TYPEPARAMETER, 0, NULL);
	vala_symbol_set_name (VALA_SYMBOL (self), _name);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source);
	return self;
}


static void vala_typeparameter_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaTypeParameter * self;
	self = VALA_TYPEPARAMETER (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_type_parameter (visitor, self);
}


/**
 * Checks two type parameters for equality.
 *
 * @param param2 a type parameter
 * @return      true if this type parameter is equal to param2, false
 *              otherwise
 */
gboolean vala_typeparameter_equals (ValaTypeParameter* self, ValaTypeParameter* param2) {
	g_return_val_if_fail (VALA_IS_TYPEPARAMETER (self), FALSE);
	g_return_val_if_fail (VALA_IS_TYPEPARAMETER (param2), FALSE);
	/* FIXME check whether the corresponding data type of one of the
	       parameters is a base type of the corresponding data
	       type of the other parameter and check along the path
	       whether one parameter maps to the other*/
	return TRUE;
}


static void vala_typeparameter_class_init (ValaTypeParameterClass * klass) {
	vala_typeparameter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaTypeParameterPrivate));
	G_OBJECT_CLASS (klass)->dispose = vala_typeparameter_dispose;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_typeparameter_real_accept;
}


static void vala_typeparameter_init (ValaTypeParameter * self) {
	self->priv = VALA_TYPEPARAMETER_GET_PRIVATE (self);
}


static void vala_typeparameter_dispose (GObject * obj) {
	ValaTypeParameter * self;
	self = VALA_TYPEPARAMETER (obj);
	(self->priv->array_types == NULL ? NULL : (self->priv->array_types = (g_object_unref (self->priv->array_types), NULL)));
	G_OBJECT_CLASS (vala_typeparameter_parent_class)->dispose (obj);
}


GType vala_typeparameter_get_type (void) {
	static GType vala_typeparameter_type_id = 0;
	if (G_UNLIKELY (vala_typeparameter_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaTypeParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_typeparameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaTypeParameter), 0, (GInstanceInitFunc) vala_typeparameter_init };
		vala_typeparameter_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaTypeParameter", &g_define_type_info, 0);
	}
	return vala_typeparameter_type_id;
}




