/* valaccodememberaccessbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodememberaccessbinding.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valadatatype.h>
#include <vala/valaexpression.h>
#include <vala/valamethod.h>
#include <vala/valabaseaccess.h>
#include <vala/valasymbol.h>
#include <vala/valaclass.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodenode.h>
#include <ccode/valaccodememberaccess.h>
#include <vala/valainterface.h>
#include <vala/valalocalvariable.h>
#include <gee/list.h>
#include <ccode/valaccodeassignment.h>
#include <vala/valaarraylengthfield.h>
#include <vala/valafield.h>
#include <vala/valapointertype.h>
#include <vala/valaconstant.h>
#include <vala/valaproperty.h>
#include <vala/valapropertyaccessor.h>
#include <ccode/valaccodecommaexpression.h>
#include <gee/collection.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeconstant.h>
#include <vala/valaenumvalue.h>
#include <vala/valaformalparameter.h>
#include <vala/valastruct.h>
#include <vala/valasignal.h>
#include <vala/valaclasstype.h>
#include <vala/valainterfacetype.h>
#include <vala/valavaluetype.h>
#include <gobject/valaccodebinding.h>
#include <gobject/valaccodemethodbinding.h>




struct _ValaCCodeMemberAccessBindingPrivate {
	ValaMemberAccess* _member_access;
};
#define VALA_CCODE_MEMBER_ACCESS_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_MEMBER_ACCESS_BINDING, ValaCCodeMemberAccessBindingPrivate))
enum  {
	VALA_CCODE_MEMBER_ACCESS_BINDING_DUMMY_PROPERTY,
	VALA_CCODE_MEMBER_ACCESS_BINDING_MEMBER_ACCESS
};
static void vala_ccode_member_access_binding_process_cmember (ValaCCodeMemberAccessBinding* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type);
static void vala_ccode_member_access_binding_real_emit (ValaCCodeBinding* base);
static gpointer vala_ccode_member_access_binding_parent_class = NULL;
static void vala_ccode_member_access_binding_dispose (GObject * obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeMemberAccessBinding* vala_ccode_member_access_binding_new (ValaCCodeGenerator* codegen, ValaMemberAccess* member_access) {
	ValaCCodeMemberAccessBinding * self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_MEMBER_ACCESS (member_access), NULL);
	self = g_object_newv (VALA_TYPE_CCODE_MEMBER_ACCESS_BINDING, 0, NULL);
	vala_ccode_member_access_binding_set_member_access (self, member_access);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


static void vala_ccode_member_access_binding_process_cmember (ValaCCodeMemberAccessBinding* self, ValaMemberAccess* expr, ValaCCodeExpression* pub_inst, ValaDataType* base_type) {
	g_return_if_fail (VALA_IS_CCODE_MEMBER_ACCESS_BINDING (self));
	g_return_if_fail (VALA_IS_MEMBER_ACCESS (expr));
	g_return_if_fail (pub_inst == NULL || VALA_IS_CCODE_EXPRESSION (pub_inst));
	g_return_if_fail (base_type == NULL || VALA_IS_DATA_TYPE (base_type));
	if (VALA_IS_METHOD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
		ValaMethod* _tmp0;
		ValaMethod* m;
		_tmp0 = NULL;
		m = (_tmp0 = VALA_METHOD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
		if (VALA_IS_BASE_ACCESS (vala_member_access_get_inner (expr))) {
			if (vala_method_get_base_method (m) != NULL) {
				ValaClass* _tmp1;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp4;
				char* _tmp3;
				char* _tmp2;
				ValaCCodeFunctionCall* _tmp5;
				ValaCCodeFunctionCall* vcast;
				ValaCCodeIdentifier* _tmp8;
				char* _tmp7;
				char* _tmp6;
				ValaCCodeMemberAccess* _tmp9;
				_tmp1 = NULL;
				base_class = (_tmp1 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m)))), (_tmp1 == NULL ? NULL : g_object_ref (_tmp1)));
				_tmp4 = NULL;
				_tmp3 = NULL;
				_tmp2 = NULL;
				_tmp5 = NULL;
				vcast = (_tmp5 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ((_tmp3 = g_strdup_printf ("%s_CLASS", (_tmp2 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (base_class), NULL)))))))), (_tmp4 == NULL ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL))), (_tmp3 = (g_free (_tmp3), NULL)), (_tmp2 = (g_free (_tmp2), NULL)), _tmp5);
				_tmp8 = NULL;
				_tmp7 = NULL;
				_tmp6 = NULL;
				vala_ccode_function_call_add_argument (vcast, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ((_tmp7 = g_strdup_printf ("%s_parent_class", (_tmp6 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), NULL))))))));
				(_tmp8 == NULL ? NULL : (_tmp8 = (g_object_unref (_tmp8), NULL)));
				_tmp7 = (g_free (_tmp7), NULL);
				_tmp6 = (g_free (_tmp6), NULL);
				_tmp9 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp9 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vcast), vala_symbol_get_name (VALA_SYMBOL (m))))));
				(_tmp9 == NULL ? NULL : (_tmp9 = (g_object_unref (_tmp9), NULL)));
				(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
				(vcast == NULL ? NULL : (vcast = (g_object_unref (vcast), NULL)));
				(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
				return;
			} else {
				if (vala_method_get_base_interface_method (m) != NULL) {
					ValaInterface* _tmp10;
					ValaInterface* base_iface;
					char* _tmp12;
					char* _tmp11;
					char* _tmp13;
					char* parent_iface_var;
					ValaCCodeMemberAccess* _tmp15;
					ValaCCodeIdentifier* _tmp14;
					_tmp10 = NULL;
					base_iface = (_tmp10 = VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_interface_method (m)))), (_tmp10 == NULL ? NULL : g_object_ref (_tmp10)));
					_tmp12 = NULL;
					_tmp11 = NULL;
					_tmp13 = NULL;
					parent_iface_var = (_tmp13 = g_strdup_printf ("%s_%s_parent_iface", (_tmp11 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), NULL)), (_tmp12 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_iface), NULL))), (_tmp12 = (g_free (_tmp12), NULL)), (_tmp11 = (g_free (_tmp11), NULL)), _tmp13);
					_tmp15 = NULL;
					_tmp14 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp15 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new (parent_iface_var))), vala_symbol_get_name (VALA_SYMBOL (m))))));
					(_tmp15 == NULL ? NULL : (_tmp15 = (g_object_unref (_tmp15), NULL)));
					(_tmp14 == NULL ? NULL : (_tmp14 = (g_object_unref (_tmp14), NULL)));
					(base_iface == NULL ? NULL : (base_iface = (g_object_unref (base_iface), NULL)));
					parent_iface_var = (g_free (parent_iface_var), NULL);
					(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
					return;
				}
			}
		}
		if (vala_method_get_base_method (m) != NULL) {
			ValaCCodeMethodBinding* binding;
			binding = vala_ccode_binding_method_binding (VALA_CCODE_BINDING (self), vala_method_get_base_method (m));
			if (!vala_ccode_method_binding_get_has_wrapper (binding)) {
				ValaCCodeExpression* _tmp16;
				ValaCCodeExpression* inst;
				ValaClass* _tmp18;
				ValaClass* base_class;
				ValaCCodeIdentifier* _tmp21;
				char* _tmp20;
				char* _tmp19;
				ValaCCodeFunctionCall* _tmp22;
				ValaCCodeFunctionCall* vclass;
				ValaCCodeMemberAccess* _tmp23;
				_tmp16 = NULL;
				inst = (_tmp16 = pub_inst, (_tmp16 == NULL ? NULL : g_object_ref (_tmp16)));
				if (vala_member_access_get_inner (expr) != NULL && !vala_expression_is_pure (vala_member_access_get_inner (expr))) {
					ValaLocalVariable* temp_var;
					ValaCCodeIdentifier* ctemp;
					ValaCCodeExpression* _tmp17;
					/* instance expression has side-effects
					 store in temp. variable*/
					temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_static_type (vala_member_access_get_inner (expr)), TRUE, NULL);
					gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
					ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
					_tmp17 = NULL;
					inst = (_tmp17 = VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (ctemp), pub_inst, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp17);
					vala_code_node_set_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (expr)), VALA_CCODE_NODE (ctemp));
					(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
					(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
				}
				_tmp18 = NULL;
				base_class = (_tmp18 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m)))), (_tmp18 == NULL ? NULL : g_object_ref (_tmp18)));
				_tmp21 = NULL;
				_tmp20 = NULL;
				_tmp19 = NULL;
				_tmp22 = NULL;
				vclass = (_tmp22 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_identifier_new ((_tmp20 = g_strdup_printf ("%s_GET_CLASS", (_tmp19 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (base_class), NULL)))))))), (_tmp21 == NULL ? NULL : (_tmp21 = (g_object_unref (_tmp21), NULL))), (_tmp20 = (g_free (_tmp20), NULL)), (_tmp19 = (g_free (_tmp19), NULL)), _tmp22);
				vala_ccode_function_call_add_argument (vclass, inst);
				_tmp23 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp23 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (vclass), vala_symbol_get_name (VALA_SYMBOL (m))))));
				(_tmp23 == NULL ? NULL : (_tmp23 = (g_object_unref (_tmp23), NULL)));
				(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
				(base_class == NULL ? NULL : (base_class = (g_object_unref (base_class), NULL)));
				(vclass == NULL ? NULL : (vclass = (g_object_unref (vclass), NULL)));
			} else {
				ValaCCodeIdentifier* _tmp25;
				char* _tmp24;
				_tmp25 = NULL;
				_tmp24 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp25 = vala_ccode_identifier_new ((_tmp24 = vala_method_get_cname (vala_method_get_base_method (m)))))));
				(_tmp25 == NULL ? NULL : (_tmp25 = (g_object_unref (_tmp25), NULL)));
				_tmp24 = (g_free (_tmp24), NULL);
			}
			(binding == NULL ? NULL : (binding = (g_object_unref (binding), NULL)));
		} else {
			if (vala_method_get_base_interface_method (m) != NULL) {
				ValaCCodeIdentifier* _tmp27;
				char* _tmp26;
				_tmp27 = NULL;
				_tmp26 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp27 = vala_ccode_identifier_new ((_tmp26 = vala_method_get_cname (vala_method_get_base_interface_method (m)))))));
				(_tmp27 == NULL ? NULL : (_tmp27 = (g_object_unref (_tmp27), NULL)));
				_tmp26 = (g_free (_tmp26), NULL);
			} else {
				ValaCCodeIdentifier* _tmp29;
				char* _tmp28;
				_tmp29 = NULL;
				_tmp28 = NULL;
				vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp29 = vala_ccode_identifier_new ((_tmp28 = vala_method_get_cname (m))))));
				(_tmp29 == NULL ? NULL : (_tmp29 = (g_object_unref (_tmp29), NULL)));
				_tmp28 = (g_free (_tmp28), NULL);
			}
		}
		(m == NULL ? NULL : (m = (g_object_unref (m), NULL)));
	} else {
		if (VALA_IS_ARRAY_LENGTH_FIELD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
			ValaCCodeExpression* _tmp30;
			_tmp30 = NULL;
			vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp30 = vala_ccode_generator_get_array_length_cexpression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_member_access_get_inner (expr), 1))));
			(_tmp30 == NULL ? NULL : (_tmp30 = (g_object_unref (_tmp30), NULL)));
		} else {
			if (VALA_IS_FIELD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
				ValaField* _tmp31;
				ValaField* f;
				_tmp31 = NULL;
				f = (_tmp31 = VALA_FIELD (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp31 == NULL ? NULL : g_object_ref (_tmp31)));
				if (vala_field_get_instance (f)) {
					ValaDataType* _tmp32;
					ValaDataType* instance_expression_type;
					ValaDataType* instance_target_type;
					ValaCCodeExpression* typed_inst;
					gboolean is_gtypeinstance;
					ValaCCodeExpression* inst;
					_tmp32 = NULL;
					instance_expression_type = (_tmp32 = base_type, (_tmp32 == NULL ? NULL : g_object_ref (_tmp32)));
					instance_target_type = vala_ccode_generator_get_data_type_for_symbol (VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (f))));
					typed_inst = vala_ccode_generator_get_implicit_cast_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), pub_inst, instance_expression_type, instance_target_type);
					is_gtypeinstance = (vala_typesymbol_is_subtype_of (vala_data_type_get_data_type (instance_target_type), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gtypeinstance_type));
					inst = NULL;
					if (is_gtypeinstance && vala_symbol_get_access (VALA_SYMBOL (f)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
						ValaCCodeExpression* _tmp33;
						_tmp33 = NULL;
						inst = (_tmp33 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (typed_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp33);
					} else {
						ValaCCodeExpression* _tmp35;
						ValaCCodeExpression* _tmp34;
						_tmp35 = NULL;
						_tmp34 = NULL;
						inst = (_tmp35 = (_tmp34 = typed_inst, (_tmp34 == NULL ? NULL : g_object_ref (_tmp34))), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp35);
					}
					if (vala_typesymbol_is_reference_type (vala_data_type_get_data_type (instance_target_type)) || (vala_member_access_get_inner (expr) != NULL && VALA_IS_POINTER_TYPE (vala_expression_get_static_type (vala_member_access_get_inner (expr))))) {
						ValaCCodeMemberAccess* _tmp37;
						char* _tmp36;
						_tmp37 = NULL;
						_tmp36 = NULL;
						vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp37 = vala_ccode_member_access_new_pointer (inst, (_tmp36 = vala_field_get_cname (f))))));
						(_tmp37 == NULL ? NULL : (_tmp37 = (g_object_unref (_tmp37), NULL)));
						_tmp36 = (g_free (_tmp36), NULL);
					} else {
						ValaCCodeMemberAccess* _tmp39;
						char* _tmp38;
						_tmp39 = NULL;
						_tmp38 = NULL;
						vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp39 = vala_ccode_member_access_new (inst, (_tmp38 = vala_field_get_cname (f)), FALSE))));
						(_tmp39 == NULL ? NULL : (_tmp39 = (g_object_unref (_tmp39), NULL)));
						_tmp38 = (g_free (_tmp38), NULL);
					}
					(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
					(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
					(typed_inst == NULL ? NULL : (typed_inst = (g_object_unref (typed_inst), NULL)));
					(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp41;
					char* _tmp40;
					_tmp41 = NULL;
					_tmp40 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp41 = vala_ccode_identifier_new ((_tmp40 = vala_field_get_cname (f))))));
					(_tmp41 == NULL ? NULL : (_tmp41 = (g_object_unref (_tmp41), NULL)));
					_tmp40 = (g_free (_tmp40), NULL);
				}
				if (vala_data_type_get_type_parameter (vala_field_get_type_reference (f)) != NULL && vala_data_type_get_type_parameter (vala_expression_get_static_type (VALA_EXPRESSION (expr))) == NULL) {
					ValaCCodeExpression* _tmp42;
					_tmp42 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp42 = vala_ccode_generator_convert_from_generic_pointer (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (expr))), vala_expression_get_static_type (VALA_EXPRESSION (expr))))));
					(_tmp42 == NULL ? NULL : (_tmp42 = (g_object_unref (_tmp42), NULL)));
				}
				(f == NULL ? NULL : (f = (g_object_unref (f), NULL)));
			} else {
				if (VALA_IS_CONSTANT (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
					ValaConstant* _tmp43;
					ValaConstant* c;
					ValaCCodeIdentifier* _tmp45;
					char* _tmp44;
					_tmp43 = NULL;
					c = (_tmp43 = VALA_CONSTANT (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp43 == NULL ? NULL : g_object_ref (_tmp43)));
					_tmp45 = NULL;
					_tmp44 = NULL;
					vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp45 = vala_ccode_identifier_new ((_tmp44 = vala_constant_get_cname (c))))));
					(_tmp45 == NULL ? NULL : (_tmp45 = (g_object_unref (_tmp45), NULL)));
					_tmp44 = (g_free (_tmp44), NULL);
					(c == NULL ? NULL : (c = (g_object_unref (c), NULL)));
				} else {
					if (VALA_IS_PROPERTY (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
						ValaProperty* _tmp46;
						ValaProperty* prop;
						_tmp46 = NULL;
						prop = (_tmp46 = VALA_PROPERTY (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp46 == NULL ? NULL : g_object_ref (_tmp46)));
						if (vala_property_get_get_accessor (prop) != NULL && vala_property_accessor_get_automatic_body (vala_property_get_get_accessor (prop)) && VALA_SYMBOL (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol) == vala_symbol_get_parent_symbol (VALA_SYMBOL (prop))) {
							ValaCCodeExpression* inst;
							ValaCCodeExpression* _tmp47;
							ValaCCodeMemberAccess* _tmp49;
							char* _tmp48;
							inst = NULL;
							_tmp47 = NULL;
							inst = (_tmp47 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new_pointer (pub_inst, "priv")), (inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL))), _tmp47);
							_tmp49 = NULL;
							_tmp48 = NULL;
							vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp49 = vala_ccode_member_access_new_pointer (inst, (_tmp48 = vala_field_get_cname (vala_property_get_field (prop)))))));
							(_tmp49 == NULL ? NULL : (_tmp49 = (g_object_unref (_tmp49), NULL)));
							_tmp48 = (g_free (_tmp48), NULL);
							(inst == NULL ? NULL : (inst = (g_object_unref (inst), NULL)));
						} else {
							if (!vala_property_get_no_accessor_method (prop)) {
								ValaProperty* _tmp50;
								ValaProperty* base_property;
								ValaTypesymbol* _tmp55;
								ValaTypesymbol* base_property_type;
								ValaCCodeIdentifier* _tmp58;
								char* _tmp57;
								char* _tmp56;
								ValaCCodeFunctionCall* _tmp59;
								ValaCCodeFunctionCall* ccall;
								ValaDataType* _tmp60;
								ValaDataType* instance_expression_type;
								ValaDataType* instance_target_type;
								ValaCCodeExpression* typed_pub_inst;
								_tmp50 = NULL;
								base_property = (_tmp50 = prop, (_tmp50 == NULL ? NULL : g_object_ref (_tmp50)));
								if (vala_property_get_base_property (prop) != NULL) {
									ValaProperty* _tmp52;
									ValaProperty* _tmp51;
									_tmp52 = NULL;
									_tmp51 = NULL;
									base_property = (_tmp52 = (_tmp51 = vala_property_get_base_property (prop), (_tmp51 == NULL ? NULL : g_object_ref (_tmp51))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), _tmp52);
								} else {
									if (vala_property_get_base_interface_property (prop) != NULL) {
										ValaProperty* _tmp54;
										ValaProperty* _tmp53;
										_tmp54 = NULL;
										_tmp53 = NULL;
										base_property = (_tmp54 = (_tmp53 = vala_property_get_base_interface_property (prop), (_tmp53 == NULL ? NULL : g_object_ref (_tmp53))), (base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL))), _tmp54);
									}
								}
								_tmp55 = NULL;
								base_property_type = (_tmp55 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (base_property))), (_tmp55 == NULL ? NULL : g_object_ref (_tmp55)));
								_tmp58 = NULL;
								_tmp57 = NULL;
								_tmp56 = NULL;
								_tmp59 = NULL;
								ccall = (_tmp59 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_identifier_new ((_tmp57 = g_strdup_printf ("%s_get_%s", (_tmp56 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_property_type), NULL)), vala_symbol_get_name (VALA_SYMBOL (base_property)))))))), (_tmp58 == NULL ? NULL : (_tmp58 = (g_object_unref (_tmp58), NULL))), (_tmp57 = (g_free (_tmp57), NULL)), (_tmp56 = (g_free (_tmp56), NULL)), _tmp59);
								_tmp60 = NULL;
								instance_expression_type = (_tmp60 = base_type, (_tmp60 == NULL ? NULL : g_object_ref (_tmp60)));
								instance_target_type = vala_ccode_generator_get_data_type_for_symbol (base_property_type);
								typed_pub_inst = vala_ccode_generator_get_implicit_cast_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), pub_inst, instance_expression_type, instance_target_type);
								vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
								/* Property acesses to real struct types are handeled different to other properties.
								 They are returned as out parameter.*/
								if (vala_data_type_is_real_struct_type (vala_property_get_type_reference (base_property))) {
									ValaCCodeCommaExpression* ccomma;
									ValaLocalVariable* temp_var;
									ValaCCodeIdentifier* ctemp;
									ValaCCodeUnaryExpression* _tmp61;
									ccomma = vala_ccode_comma_expression_new ();
									temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_property_get_type_reference (base_property), TRUE, NULL);
									ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
									gee_collection_add (GEE_COLLECTION (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), temp_var);
									_tmp61 = NULL;
									vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ctemp)))));
									(_tmp61 == NULL ? NULL : (_tmp61 = (g_object_unref (_tmp61), NULL)));
									vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
									vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ctemp));
									vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
									(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
									(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
									(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
								} else {
									vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
								}
								(base_property == NULL ? NULL : (base_property = (g_object_unref (base_property), NULL)));
								(base_property_type == NULL ? NULL : (base_property_type = (g_object_unref (base_property_type), NULL)));
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
								(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
								(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
								(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
							} else {
								ValaCCodeIdentifier* _tmp62;
								ValaCCodeFunctionCall* _tmp63;
								ValaCCodeFunctionCall* ccall;
								ValaCCodeIdentifier* _tmp64;
								ValaCCodeFunctionCall* _tmp65;
								ValaCCodeFunctionCall* ccast;
								ValaCCodeConstant* _tmp66;
								ValaLocalVariable* temp_var;
								ValaCCodeIdentifier* ctemp;
								ValaCCodeUnaryExpression* _tmp67;
								ValaCCodeConstant* _tmp68;
								ValaCCodeCommaExpression* ccomma;
								_tmp62 = NULL;
								_tmp63 = NULL;
								ccall = (_tmp63 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_identifier_new ("g_object_get")))), (_tmp62 == NULL ? NULL : (_tmp62 = (g_object_unref (_tmp62), NULL))), _tmp63);
								_tmp64 = NULL;
								_tmp65 = NULL;
								ccast = (_tmp65 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp64 == NULL ? NULL : (_tmp64 = (g_object_unref (_tmp64), NULL))), _tmp65);
								vala_ccode_function_call_add_argument (ccast, pub_inst);
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
								/* property name is second argument of g_object_get*/
								_tmp66 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp66 = vala_property_get_canonical_cconstant (prop))));
								(_tmp66 == NULL ? NULL : (_tmp66 = (g_object_unref (_tmp66), NULL)));
								/* we need a temporary variable to save the property value*/
								temp_var = vala_ccode_generator_get_temp_variable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_expression_get_static_type (VALA_EXPRESSION (expr)), TRUE, NULL);
								gee_list_insert (GEE_LIST (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->temp_vars), 0, temp_var);
								ctemp = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (temp_var)));
								_tmp67 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ctemp)))));
								(_tmp67 == NULL ? NULL : (_tmp67 = (g_object_unref (_tmp67), NULL)));
								_tmp68 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_constant_new ("NULL"))));
								(_tmp68 == NULL ? NULL : (_tmp68 = (g_object_unref (_tmp68), NULL)));
								ccomma = vala_ccode_comma_expression_new ();
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ccall));
								vala_ccode_comma_expression_append_expression (ccomma, VALA_CCODE_EXPRESSION (ctemp));
								vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccomma));
								(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
								(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
								(temp_var == NULL ? NULL : (temp_var = (g_object_unref (temp_var), NULL)));
								(ctemp == NULL ? NULL : (ctemp = (g_object_unref (ctemp), NULL)));
								(ccomma == NULL ? NULL : (ccomma = (g_object_unref (ccomma), NULL)));
							}
						}
						(prop == NULL ? NULL : (prop = (g_object_unref (prop), NULL)));
					} else {
						if (VALA_IS_ENUM_VALUE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
							ValaEnumValue* _tmp69;
							ValaEnumValue* ev;
							ValaCCodeConstant* _tmp71;
							char* _tmp70;
							_tmp69 = NULL;
							ev = (_tmp69 = VALA_ENUM_VALUE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp69 == NULL ? NULL : g_object_ref (_tmp69)));
							_tmp71 = NULL;
							_tmp70 = NULL;
							vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp71 = vala_ccode_constant_new ((_tmp70 = vala_enum_value_get_cname (ev))))));
							(_tmp71 == NULL ? NULL : (_tmp71 = (g_object_unref (_tmp71), NULL)));
							_tmp70 = (g_free (_tmp70), NULL);
							(ev == NULL ? NULL : (ev = (g_object_unref (ev), NULL)));
						} else {
							if (VALA_IS_LOCAL_VARIABLE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
								ValaLocalVariable* _tmp72;
								ValaLocalVariable* local;
								ValaCCodeIdentifier* _tmp74;
								char* _tmp73;
								_tmp72 = NULL;
								local = (_tmp72 = VALA_LOCAL_VARIABLE (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp72 == NULL ? NULL : g_object_ref (_tmp72)));
								_tmp74 = NULL;
								_tmp73 = NULL;
								vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp74 = vala_ccode_identifier_new ((_tmp73 = vala_ccode_generator_get_variable_cname (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), vala_symbol_get_name (VALA_SYMBOL (local))))))));
								(_tmp74 == NULL ? NULL : (_tmp74 = (g_object_unref (_tmp74), NULL)));
								_tmp73 = (g_free (_tmp73), NULL);
								(local == NULL ? NULL : (local = (g_object_unref (local), NULL)));
							} else {
								if (VALA_IS_FORMAL_PARAMETER (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
									ValaFormalParameter* _tmp75;
									ValaFormalParameter* p;
									_tmp75 = NULL;
									p = (_tmp75 = VALA_FORMAL_PARAMETER (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp75 == NULL ? NULL : g_object_ref (_tmp75)));
									if (_vala_strcmp0 (vala_symbol_get_name (VALA_SYMBOL (p)), "this") == 0) {
										vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (pub_inst));
									} else {
										ValaStruct* _tmp77;
										ValaTypesymbol* _tmp76;
										ValaStruct* type_as_struct;
										_tmp77 = NULL;
										_tmp76 = NULL;
										type_as_struct = (_tmp77 = (_tmp76 = vala_data_type_get_data_type (vala_formal_parameter_get_type_reference (p)), (VALA_IS_STRUCT (_tmp76) ? ((ValaStruct*) _tmp76) : NULL)), (_tmp77 == NULL ? NULL : g_object_ref (_tmp77)));
										if (vala_formal_parameter_get_direction (p) != VALA_PARAMETER_DIRECTION_IN || (type_as_struct != NULL && !vala_struct_is_simple_type (type_as_struct))) {
											ValaCCodeIdentifier* _tmp79;
											char* _tmp78;
											_tmp79 = NULL;
											_tmp78 = NULL;
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp79 = vala_ccode_identifier_new ((_tmp78 = g_strdup_printf ("(*%s)", vala_symbol_get_name (VALA_SYMBOL (p))))))));
											(_tmp79 == NULL ? NULL : (_tmp79 = (g_object_unref (_tmp79), NULL)));
											_tmp78 = (g_free (_tmp78), NULL);
										} else {
											/* Property setters of non simple structs shall replace all occurences
											 of the "value" formal parameter with a dereferencing version of that
											 parameter.*/
											if (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_property_accessor != NULL && vala_property_accessor_get_writable (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_property_accessor) && vala_property_accessor_get_value_parameter (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_property_accessor) == p && vala_data_type_is_real_struct_type (vala_property_get_type_reference (vala_property_accessor_get_prop (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_property_accessor)))) {
												ValaCCodeIdentifier* _tmp80;
												_tmp80 = NULL;
												vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp80 = vala_ccode_identifier_new ("(*value)"))));
												(_tmp80 == NULL ? NULL : (_tmp80 = (g_object_unref (_tmp80), NULL)));
											} else {
												ValaCCodeIdentifier* _tmp81;
												_tmp81 = NULL;
												vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE ((_tmp81 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (p))))));
												(_tmp81 == NULL ? NULL : (_tmp81 = (g_object_unref (_tmp81), NULL)));
											}
										}
										(type_as_struct == NULL ? NULL : (type_as_struct = (g_object_unref (type_as_struct), NULL)));
									}
									(p == NULL ? NULL : (p = (g_object_unref (p), NULL)));
								} else {
									if (VALA_IS_SIGNAL (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr)))) {
										ValaSignal* _tmp82;
										ValaSignal* sig;
										ValaTypesymbol* _tmp83;
										ValaTypesymbol* cl;
										_tmp82 = NULL;
										sig = (_tmp82 = VALA_SIGNAL (vala_expression_get_symbol_reference (VALA_EXPRESSION (expr))), (_tmp82 == NULL ? NULL : g_object_ref (_tmp82)));
										_tmp83 = NULL;
										cl = (_tmp83 = VALA_TYPESYMBOL (vala_symbol_get_parent_symbol (VALA_SYMBOL (sig))), (_tmp83 == NULL ? NULL : g_object_ref (_tmp83)));
										if (vala_signal_get_has_emitter (sig)) {
											ValaCCodeIdentifier* _tmp86;
											char* _tmp85;
											char* _tmp84;
											ValaCCodeFunctionCall* _tmp87;
											ValaCCodeFunctionCall* ccall;
											ValaDataType* _tmp88;
											ValaDataType* instance_expression_type;
											ValaDataType* instance_target_type;
											ValaCCodeExpression* typed_pub_inst;
											_tmp86 = NULL;
											_tmp85 = NULL;
											_tmp84 = NULL;
											_tmp87 = NULL;
											ccall = (_tmp87 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_identifier_new ((_tmp85 = g_strdup_printf ("%s_%s", (_tmp84 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), vala_symbol_get_name (VALA_SYMBOL (sig)))))))), (_tmp86 == NULL ? NULL : (_tmp86 = (g_object_unref (_tmp86), NULL))), (_tmp85 = (g_free (_tmp85), NULL)), (_tmp84 = (g_free (_tmp84), NULL)), _tmp87);
											_tmp88 = NULL;
											instance_expression_type = (_tmp88 = base_type, (_tmp88 == NULL ? NULL : g_object_ref (_tmp88)));
											instance_target_type = vala_ccode_generator_get_data_type_for_symbol (cl);
											typed_pub_inst = vala_ccode_generator_get_implicit_cast_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), pub_inst, instance_expression_type, instance_target_type);
											vala_ccode_function_call_add_argument (ccall, typed_pub_inst);
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(instance_expression_type == NULL ? NULL : (instance_expression_type = (g_object_unref (instance_expression_type), NULL)));
											(instance_target_type == NULL ? NULL : (instance_target_type = (g_object_unref (instance_target_type), NULL)));
											(typed_pub_inst == NULL ? NULL : (typed_pub_inst = (g_object_unref (typed_pub_inst), NULL)));
										} else {
											ValaCCodeIdentifier* _tmp89;
											ValaCCodeFunctionCall* _tmp90;
											ValaCCodeFunctionCall* ccall;
											ValaCCodeIdentifier* _tmp91;
											ValaCCodeFunctionCall* _tmp92;
											ValaCCodeFunctionCall* ccast;
											ValaCCodeConstant* _tmp93;
											_tmp89 = NULL;
											_tmp90 = NULL;
											ccall = (_tmp90 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_identifier_new ("g_signal_emit_by_name")))), (_tmp89 == NULL ? NULL : (_tmp89 = (g_object_unref (_tmp89), NULL))), _tmp90);
											/* FIXME: use C cast if debugging disabled*/
											_tmp91 = NULL;
											_tmp92 = NULL;
											ccast = (_tmp92 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp91 = vala_ccode_identifier_new ("G_OBJECT")))), (_tmp91 == NULL ? NULL : (_tmp91 = (g_object_unref (_tmp91), NULL))), _tmp92);
											vala_ccode_function_call_add_argument (ccast, pub_inst);
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccast));
											_tmp93 = NULL;
											vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp93 = vala_signal_get_canonical_cconstant (sig))));
											(_tmp93 == NULL ? NULL : (_tmp93 = (g_object_unref (_tmp93), NULL)));
											vala_code_node_set_ccodenode (VALA_CODE_NODE (expr), VALA_CCODE_NODE (ccall));
											(ccall == NULL ? NULL : (ccall = (g_object_unref (ccall), NULL)));
											(ccast == NULL ? NULL : (ccast = (g_object_unref (ccast), NULL)));
										}
										(sig == NULL ? NULL : (sig = (g_object_unref (sig), NULL)));
										(cl == NULL ? NULL : (cl = (g_object_unref (cl), NULL)));
									}
								}
							}
						}
					}
				}
			}
		}
	}
}


static void vala_ccode_member_access_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeMemberAccessBinding * self;
	ValaMemberAccess* _tmp0;
	ValaMemberAccess* expr;
	ValaCCodeExpression* pub_inst;
	ValaDataType* base_type;
	self = VALA_CCODE_MEMBER_ACCESS_BINDING (base);
	_tmp0 = NULL;
	expr = (_tmp0 = self->priv->_member_access, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	pub_inst = NULL;
	base_type = NULL;
	if (vala_member_access_get_inner (expr) == NULL) {
		ValaCCodeExpression* _tmp1;
		_tmp1 = NULL;
		pub_inst = (_tmp1 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp1);
		if (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol != NULL) {
			/* base type is available if this is a type method */
			if (VALA_IS_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
				ValaDataType* _tmp2;
				_tmp2 = NULL;
				base_type = (_tmp2 = VALA_DATA_TYPE (vala_class_type_new (VALA_CLASS (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp2);
			} else {
				if (VALA_IS_INTERFACE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)) {
					ValaDataType* _tmp3;
					_tmp3 = NULL;
					base_type = (_tmp3 = VALA_DATA_TYPE (vala_interface_type_new (VALA_INTERFACE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp3);
				} else {
					ValaDataType* _tmp4;
					ValaCCodeExpression* _tmp5;
					_tmp4 = NULL;
					base_type = (_tmp4 = VALA_DATA_TYPE (vala_value_type_new (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol)), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp4);
					_tmp5 = NULL;
					pub_inst = (_tmp5 = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("(*self)")), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp5);
				}
			}
		}
	} else {
		ValaCCodeExpression* _tmp7;
		ValaCCodeExpression* _tmp6;
		_tmp7 = NULL;
		_tmp6 = NULL;
		pub_inst = (_tmp7 = (_tmp6 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_member_access_get_inner (expr)))), (_tmp6 == NULL ? NULL : g_object_ref (_tmp6))), (pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL))), _tmp7);
		if (vala_expression_get_static_type (vala_member_access_get_inner (expr)) != NULL) {
			ValaDataType* _tmp9;
			ValaDataType* _tmp8;
			_tmp9 = NULL;
			_tmp8 = NULL;
			base_type = (_tmp9 = (_tmp8 = vala_expression_get_static_type (vala_member_access_get_inner (expr)), (_tmp8 == NULL ? NULL : g_object_ref (_tmp8))), (base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL))), _tmp9);
		}
	}
	vala_ccode_member_access_binding_process_cmember (self, expr, pub_inst, base_type);
	vala_ccode_generator_visit_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_EXPRESSION (expr));
	(expr == NULL ? NULL : (expr = (g_object_unref (expr), NULL)));
	(pub_inst == NULL ? NULL : (pub_inst = (g_object_unref (pub_inst), NULL)));
	(base_type == NULL ? NULL : (base_type = (g_object_unref (base_type), NULL)));
}


ValaMemberAccess* vala_ccode_member_access_binding_get_member_access (ValaCCodeMemberAccessBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_MEMBER_ACCESS_BINDING (self), NULL);
	return self->priv->_member_access;
}


void vala_ccode_member_access_binding_set_member_access (ValaCCodeMemberAccessBinding* self, ValaMemberAccess* value) {
	ValaMemberAccess* _tmp2;
	ValaMemberAccess* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_MEMBER_ACCESS_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_member_access = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_member_access == NULL ? NULL : (self->priv->_member_access = (g_object_unref (self->priv->_member_access), NULL))), _tmp2);
}


static void vala_ccode_member_access_binding_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeMemberAccessBinding * self;
	self = VALA_CCODE_MEMBER_ACCESS_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_MEMBER_ACCESS_BINDING_MEMBER_ACCESS:
		g_value_set_object (value, vala_ccode_member_access_binding_get_member_access (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_member_access_binding_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeMemberAccessBinding * self;
	self = VALA_CCODE_MEMBER_ACCESS_BINDING (object);
	switch (property_id) {
		case VALA_CCODE_MEMBER_ACCESS_BINDING_MEMBER_ACCESS:
		vala_ccode_member_access_binding_set_member_access (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_member_access_binding_class_init (ValaCCodeMemberAccessBindingClass * klass) {
	vala_ccode_member_access_binding_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeMemberAccessBindingPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_member_access_binding_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_member_access_binding_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_member_access_binding_dispose;
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_member_access_binding_real_emit;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_MEMBER_ACCESS_BINDING_MEMBER_ACCESS, g_param_spec_object ("member-access", "member-access", "member-access", VALA_TYPE_MEMBER_ACCESS, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_member_access_binding_init (ValaCCodeMemberAccessBinding * self) {
	self->priv = VALA_CCODE_MEMBER_ACCESS_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_member_access_binding_dispose (GObject * obj) {
	ValaCCodeMemberAccessBinding * self;
	self = VALA_CCODE_MEMBER_ACCESS_BINDING (obj);
	(self->priv->_member_access == NULL ? NULL : (self->priv->_member_access = (g_object_unref (self->priv->_member_access), NULL)));
	G_OBJECT_CLASS (vala_ccode_member_access_binding_parent_class)->dispose (obj);
}


GType vala_ccode_member_access_binding_get_type (void) {
	static GType vala_ccode_member_access_binding_type_id = 0;
	if (G_UNLIKELY (vala_ccode_member_access_binding_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMemberAccessBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_member_access_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMemberAccessBinding), 0, (GInstanceInitFunc) vala_ccode_member_access_binding_init };
		vala_ccode_member_access_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION_BINDING, "ValaCCodeMemberAccessBinding", &g_define_type_info, 0);
	}
	return vala_ccode_member_access_binding_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




