/* valaccodeunaryexpression.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeunaryexpression.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeUnaryExpressionPrivate {
	ValaCCodeUnaryOperator _operator;
	ValaCCodeExpression* _inner;
};
#define VALA_CCODE_UNARY_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_UNARY_EXPRESSION, ValaCCodeUnaryExpressionPrivate))
enum  {
	VALA_CCODE_UNARY_EXPRESSION_DUMMY_PROPERTY,
	VALA_CCODE_UNARY_EXPRESSION_OPERATOR,
	VALA_CCODE_UNARY_EXPRESSION_INNER
};
static void vala_ccode_unary_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_unary_expression_parent_class = NULL;
static void vala_ccode_unary_expression_dispose (GObject * obj);



ValaCCodeUnaryExpression* vala_ccode_unary_expression_new (ValaCCodeUnaryOperator op, ValaCCodeExpression* expr) {
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeUnaryExpression * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (expr), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "inner";
	g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION);
	g_value_set_object (&__params_it->value, expr);
	__params_it++;
	self = g_object_newv (VALA_TYPE_CCODE_UNARY_EXPRESSION, __params_it - __params, __params);
	vala_ccode_unary_expression_set_operator (self, op);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_ccode_unary_expression_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeUnaryExpression * self;
	self = VALA_CCODE_UNARY_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_PLUS) {
		vala_ccode_writer_write_string (writer, "+");
	} else {
		if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_MINUS) {
			vala_ccode_writer_write_string (writer, "-");
		} else {
			if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION) {
				vala_ccode_writer_write_string (writer, "!");
			} else {
				if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
					vala_ccode_writer_write_string (writer, "~");
				} else {
					if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION) {
						vala_ccode_writer_write_string (writer, "*");
					} else {
						if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF) {
							vala_ccode_writer_write_string (writer, "&");
						} else {
							if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT) {
								vala_ccode_writer_write_string (writer, "++");
							} else {
								if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT) {
									vala_ccode_writer_write_string (writer, "--");
								}
							}
						}
					}
				}
			}
		}
	}
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_inner), writer);
	if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT) {
		vala_ccode_writer_write_string (writer, "++");
	} else {
		if (self->priv->_operator == VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT) {
			vala_ccode_writer_write_string (writer, "--");
		}
	}
}


ValaCCodeUnaryOperator vala_ccode_unary_expression_get_operator (ValaCCodeUnaryExpression* self) {
	g_return_val_if_fail (VALA_IS_CCODE_UNARY_EXPRESSION (self), 0);
	return self->priv->_operator;
}


void vala_ccode_unary_expression_set_operator (ValaCCodeUnaryExpression* self, ValaCCodeUnaryOperator value) {
	g_return_if_fail (VALA_IS_CCODE_UNARY_EXPRESSION (self));
	self->priv->_operator = value;
}


ValaCCodeExpression* vala_ccode_unary_expression_get_inner (ValaCCodeUnaryExpression* self) {
	g_return_val_if_fail (VALA_IS_CCODE_UNARY_EXPRESSION (self), NULL);
	return self->priv->_inner;
}


void vala_ccode_unary_expression_set_inner (ValaCCodeUnaryExpression* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_UNARY_EXPRESSION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL))), _tmp2);
}


static void vala_ccode_unary_expression_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeUnaryExpression * self;
	self = VALA_CCODE_UNARY_EXPRESSION (object);
	switch (property_id) {
		case VALA_CCODE_UNARY_EXPRESSION_OPERATOR:
		g_value_set_enum (value, vala_ccode_unary_expression_get_operator (self));
		break;
		case VALA_CCODE_UNARY_EXPRESSION_INNER:
		g_value_set_object (value, vala_ccode_unary_expression_get_inner (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_unary_expression_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeUnaryExpression * self;
	self = VALA_CCODE_UNARY_EXPRESSION (object);
	switch (property_id) {
		case VALA_CCODE_UNARY_EXPRESSION_OPERATOR:
		vala_ccode_unary_expression_set_operator (self, g_value_get_enum (value));
		break;
		case VALA_CCODE_UNARY_EXPRESSION_INNER:
		vala_ccode_unary_expression_set_inner (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_unary_expression_class_init (ValaCCodeUnaryExpressionClass * klass) {
	vala_ccode_unary_expression_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeUnaryExpressionPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_unary_expression_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_unary_expression_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_unary_expression_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_unary_expression_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_UNARY_EXPRESSION_OPERATOR, g_param_spec_enum ("operator", "operator", "operator", VALA_TYPE_CCODE_UNARY_OPERATOR, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_UNARY_EXPRESSION_INNER, g_param_spec_object ("inner", "inner", "inner", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void vala_ccode_unary_expression_init (ValaCCodeUnaryExpression * self) {
	self->priv = VALA_CCODE_UNARY_EXPRESSION_GET_PRIVATE (self);
}


static void vala_ccode_unary_expression_dispose (GObject * obj) {
	ValaCCodeUnaryExpression * self;
	self = VALA_CCODE_UNARY_EXPRESSION (obj);
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL)));
	G_OBJECT_CLASS (vala_ccode_unary_expression_parent_class)->dispose (obj);
}


GType vala_ccode_unary_expression_get_type (void) {
	static GType vala_ccode_unary_expression_type_id = 0;
	if (G_UNLIKELY (vala_ccode_unary_expression_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeUnaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_unary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeUnaryExpression), 0, (GInstanceInitFunc) vala_ccode_unary_expression_init };
		vala_ccode_unary_expression_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeUnaryExpression", &g_define_type_info, 0);
	}
	return vala_ccode_unary_expression_type_id;
}



GType vala_ccode_unary_operator_get_type (void) {
	static GType vala_ccode_unary_operator_type_id = 0;
	if (G_UNLIKELY (vala_ccode_unary_operator_type_id == 0)) {
		static const GEnumValue values[] = {{VALA_CCODE_UNARY_OPERATOR_PLUS, "VALA_CCODE_UNARY_OPERATOR_PLUS", "plus"}, {VALA_CCODE_UNARY_OPERATOR_MINUS, "VALA_CCODE_UNARY_OPERATOR_MINUS", "minus"}, {VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, "VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION", "logical-negation"}, {VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT, "VALA_CCODE_UNARY_OPERATOR_BITWISE_COMPLEMENT", "bitwise-complement"}, {VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, "VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION", "pointer-indirection"}, {VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, "VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF", "address-of"}, {VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT, "VALA_CCODE_UNARY_OPERATOR_PREFIX_INCREMENT", "prefix-increment"}, {VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT, "VALA_CCODE_UNARY_OPERATOR_PREFIX_DECREMENT", "prefix-decrement"}, {VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT, "VALA_CCODE_UNARY_OPERATOR_POSTFIX_INCREMENT", "postfix-increment"}, {VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT, "VALA_CCODE_UNARY_OPERATOR_POSTFIX_DECREMENT", "postfix-decrement"}, {0, NULL, NULL}};
		vala_ccode_unary_operator_type_id = g_enum_register_static ("ValaCCodeUnaryOperator", values);
	}
	return vala_ccode_unary_operator_type_id;
}




