/* valaccodememberaccess.vala
 *
 * Copyright (C) 2006  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodenode.h>




struct _ValaCCodeMemberAccessPrivate {
	ValaCCodeExpression* _inner;
	char* _member_name;
	gboolean _is_pointer;
};
#define VALA_CCODE_MEMBER_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_MEMBER_ACCESS, ValaCCodeMemberAccessPrivate))
enum  {
	VALA_CCODE_MEMBER_ACCESS_DUMMY_PROPERTY,
	VALA_CCODE_MEMBER_ACCESS_INNER,
	VALA_CCODE_MEMBER_ACCESS_MEMBER_NAME,
	VALA_CCODE_MEMBER_ACCESS_IS_POINTER
};
static void vala_ccode_member_access_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_member_access_parent_class = NULL;
static void vala_ccode_member_access_dispose (GObject * obj);



ValaCCodeMemberAccess* vala_ccode_member_access_new (ValaCCodeExpression* container, const char* member, gboolean pointer) {
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeMemberAccess * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (container), NULL);
	g_return_val_if_fail (member != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "inner";
	g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION);
	g_value_set_object (&__params_it->value, container);
	__params_it++;
	__params_it->name = "member-name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, member);
	__params_it++;
	self = g_object_newv (VALA_TYPE_CCODE_MEMBER_ACCESS, __params_it - __params, __params);
	vala_ccode_member_access_set_is_pointer (self, pointer);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


ValaCCodeMemberAccess* vala_ccode_member_access_new_pointer (ValaCCodeExpression* container, const char* member) {
	GParameter * __params;
	GParameter * __params_it;
	ValaCCodeMemberAccess * self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (container), NULL);
	g_return_val_if_fail (member != NULL, NULL);
	__params = g_new0 (GParameter, 2);
	__params_it = __params;
	__params_it->name = "inner";
	g_value_init (&__params_it->value, VALA_TYPE_CCODE_EXPRESSION);
	g_value_set_object (&__params_it->value, container);
	__params_it++;
	__params_it->name = "member-name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, member);
	__params_it++;
	self = g_object_newv (VALA_TYPE_CCODE_MEMBER_ACCESS, __params_it - __params, __params);
	vala_ccode_member_access_set_is_pointer (self, TRUE);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static void vala_ccode_member_access_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeMemberAccess * self;
	self = VALA_CCODE_MEMBER_ACCESS (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_inner), writer);
	if (self->priv->_is_pointer) {
		vala_ccode_writer_write_string (writer, "->");
	} else {
		vala_ccode_writer_write_string (writer, ".");
	}
	vala_ccode_writer_write_string (writer, self->priv->_member_name);
}


ValaCCodeExpression* vala_ccode_member_access_get_inner (ValaCCodeMemberAccess* self) {
	g_return_val_if_fail (VALA_IS_CCODE_MEMBER_ACCESS (self), NULL);
	return self->priv->_inner;
}


void vala_ccode_member_access_set_inner (ValaCCodeMemberAccess* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_MEMBER_ACCESS (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_inner = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL))), _tmp2);
}


char* vala_ccode_member_access_get_member_name (ValaCCodeMemberAccess* self) {
	g_return_val_if_fail (VALA_IS_CCODE_MEMBER_ACCESS (self), NULL);
	return self->priv->_member_name;
}


void vala_ccode_member_access_set_member_name (ValaCCodeMemberAccess* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_MEMBER_ACCESS (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_member_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_member_name = (g_free (self->priv->_member_name), NULL)), _tmp2);
}


gboolean vala_ccode_member_access_get_is_pointer (ValaCCodeMemberAccess* self) {
	g_return_val_if_fail (VALA_IS_CCODE_MEMBER_ACCESS (self), FALSE);
	return self->priv->_is_pointer;
}


void vala_ccode_member_access_set_is_pointer (ValaCCodeMemberAccess* self, gboolean value) {
	g_return_if_fail (VALA_IS_CCODE_MEMBER_ACCESS (self));
	self->priv->_is_pointer = value;
}


static void vala_ccode_member_access_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ValaCCodeMemberAccess * self;
	self = VALA_CCODE_MEMBER_ACCESS (object);
	switch (property_id) {
		case VALA_CCODE_MEMBER_ACCESS_INNER:
		g_value_set_object (value, vala_ccode_member_access_get_inner (self));
		break;
		case VALA_CCODE_MEMBER_ACCESS_MEMBER_NAME:
		g_value_set_string (value, vala_ccode_member_access_get_member_name (self));
		break;
		case VALA_CCODE_MEMBER_ACCESS_IS_POINTER:
		g_value_set_boolean (value, vala_ccode_member_access_get_is_pointer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_member_access_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ValaCCodeMemberAccess * self;
	self = VALA_CCODE_MEMBER_ACCESS (object);
	switch (property_id) {
		case VALA_CCODE_MEMBER_ACCESS_INNER:
		vala_ccode_member_access_set_inner (self, g_value_get_object (value));
		break;
		case VALA_CCODE_MEMBER_ACCESS_MEMBER_NAME:
		vala_ccode_member_access_set_member_name (self, g_value_get_string (value));
		break;
		case VALA_CCODE_MEMBER_ACCESS_IS_POINTER:
		vala_ccode_member_access_set_is_pointer (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void vala_ccode_member_access_class_init (ValaCCodeMemberAccessClass * klass) {
	vala_ccode_member_access_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValaCCodeMemberAccessPrivate));
	G_OBJECT_CLASS (klass)->get_property = vala_ccode_member_access_get_property;
	G_OBJECT_CLASS (klass)->set_property = vala_ccode_member_access_set_property;
	G_OBJECT_CLASS (klass)->dispose = vala_ccode_member_access_dispose;
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_member_access_real_write;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_MEMBER_ACCESS_INNER, g_param_spec_object ("inner", "inner", "inner", VALA_TYPE_CCODE_EXPRESSION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_MEMBER_ACCESS_MEMBER_NAME, g_param_spec_string ("member-name", "member-name", "member-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALA_CCODE_MEMBER_ACCESS_IS_POINTER, g_param_spec_boolean ("is-pointer", "is-pointer", "is-pointer", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void vala_ccode_member_access_init (ValaCCodeMemberAccess * self) {
	self->priv = VALA_CCODE_MEMBER_ACCESS_GET_PRIVATE (self);
}


static void vala_ccode_member_access_dispose (GObject * obj) {
	ValaCCodeMemberAccess * self;
	self = VALA_CCODE_MEMBER_ACCESS (obj);
	(self->priv->_inner == NULL ? NULL : (self->priv->_inner = (g_object_unref (self->priv->_inner), NULL)));
	self->priv->_member_name = (g_free (self->priv->_member_name), NULL);
	G_OBJECT_CLASS (vala_ccode_member_access_parent_class)->dispose (obj);
}


GType vala_ccode_member_access_get_type (void) {
	static GType vala_ccode_member_access_type_id = 0;
	if (G_UNLIKELY (vala_ccode_member_access_type_id == 0)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMemberAccess), 0, (GInstanceInitFunc) vala_ccode_member_access_init };
		vala_ccode_member_access_type_id = g_type_register_static (VALA_TYPE_CCODE_EXPRESSION, "ValaCCodeMemberAccess", &g_define_type_info, 0);
	}
	return vala_ccode_member_access_type_id;
}




