/*
 * $Id: apc_static.c,v 2.0.1.5 1996/06/26 18:39:38 alexis Exp alexis $
 *
 * UPS Daemon
 * The Wild Wind Communications, 1995, 1996
 *
 * See file LICENSE for the distribution terms of this software.
 */

#include "upsd.h"
#include "apc.h"

/*
 * SmartUPS(R)
 */
char apc_SmartUPS_NA[] = "NA";
char apc_SmartUPS_NO[] = "NO";
char apc_SmartUPS_OK[] = "OK";

char apc_SmartWriteBuffer[MAXAPCWRITEBUFFER];

static struct ups_reg apc_SmartUPS_registers[] = {
	{SMART_BREPL, "batteries-replaced", R_INFO | R_OPTION, APC_WRITE, T_BINARY, 8+2, 2, "x", 1},
	{SMART_COPYRIGHT, "copyright", R_INFO, 0, T_BINARY, 8+2, 2, "y", 1},
	{SMART_FIRMWARE, "firmware", R_INFO, 0, T_BINARY, 3+2, 2, "V", 1},
	{SMART_HTPOINT, "high-transfer-point", R_OPTION, APC_TOGGLE, T_NUMBER, 3+2, 0, "u", 1},
	{SMART_INIT, "initialize", R_COMMAND, 0, T_BINARY, 2+2, 2, "Y", 1},
	{SMART_LABEL, "label", R_INFO | R_OPTION, APC_WRITE, T_BINARY, 8+2, 2, "c", 1},
	{SMART_LASTTEST, "last-test", R_STATUS, 0, T_BINARY, 2+2, 2, "X", 1},
	{SMART_LFREQUENCY, "line-frequency", R_STATUS, 0, T_NUMBER, 5+2, 2, "F", 1},
	{SMART_LIGHTTEST, "light-test", R_COMMAND | R_STATUS, 0, T_BINARY, 2+2, 2, "A", 1},
	{SMART_LINEALARM, "line-alarm", R_OPTION, APC_TOGGLE, T_BINARY, 1+2, 2, "k", 1},
	{SMART_LINESENS, "line-sensitivity", R_OPTION, APC_TOGGLE, T_BINARY, 1+2, 2, "s", 1},
	{SMART_LMAXVAC, "line-maxvac", R_STATUS, 0, T_NUMBER, 5+2, 1, "M", 1},
	{SMART_LMINVAC, "line-minvac", R_STATUS, 0, T_NUMBER, 5+2, 1, "N", 1},
	{SMART_LOAD, "load", R_STATUS, 0, T_NUMBER, 5+2, 1, "P", 1},
	{SMART_LOWBATDUR, "low-batteries-duration", R_OPTION, APC_TOGGLE, T_NUMBER, 2+2, 0, "q", 1},
	{SMART_LTPOINT, "low-transfer-point", R_OPTION, APC_TOGGLE, T_NUMBER, 3+2, 0, "l", 1},
	{SMART_LVOLTAGE, "line-voltage", R_STATUS, 0, T_NUMBER, 5+2, 1, "L", 1},
	{SMART_MANUFACTURED, "manufactured", R_INFO, 0, T_BINARY, 8+2, 2, "m", 1},
	{SMART_MODIFY, NULL, R_COMMAND, 0, T_BINARY, 2+2, 2, "-", 1},
	{SMART_NVOLTAGE, "nominal-voltage", R_OPTION, APC_TOGGLE, T_NUMBER, 3+2, 0, "o", 1},
	{SMART_POWERTEST, "power-test", R_COMMAND, 0, T_BINARY, 2+2, 2, "U", 1},
	{SMART_RECHARGE, "recharge", R_STATUS, 0, T_NUMBER, 5+2, 1, "f", 1},
	{SMART_SELFTEST, "self-test", R_COMMAND, 0, T_BINARY, 0, 0, "W", 1},
	{SMART_SERIAL, "serial", R_INFO, 0, T_BINARY, 8+2, 2, "n", 1},
	{SMART_SHUTDELAY, "shutdown-delay", R_OPTION, APC_TOGGLE, T_NUMBER, 3+2, 0, "p", 1},
	{SMART_SHUTDOWN, "shutdown", R_COMMAND, APC_WRITE, T_BINARY, 0, 0, "S", 1},
	{SMART_TEMP, "temperature", R_STATUS, 0, T_NUMBER, 5+2, 1, "C", 1},
	{SMART_VDC, "vdc", R_STATUS, 0, T_NUMBER, 5+2, 2, "B", 1},
	{SMART_VOLTAGE, "voltage", R_STATUS, 0, T_NUMBER, 5+2, 1, "O", 1},
	{SMART_WAKEUPBCAP, "wakeup-batteries-capacity", R_OPTION, APC_TOGGLE, T_NUMBER, 2+2, 0, "e", 1},
	{SMART_WAKEUPDELAY, "wakeup-delay", R_OPTION, APC_TOGGLE, T_NUMBER, 3+2, 0, "r", 1},
	{SMART_WRITE, NULL, R_COMMAND, 0, T_BINARY, 2+2, 2, apc_SmartWriteBuffer, 1},
	{0, NULL, 0, 0, 0, 0, 0, NULL, 0}
};

/* The not-so-smart SmartUPS v/s */
/* This model is added by John Fieber <jfieber@indiana.edu> */
static struct ups_reg apc_SmartUPS_vs_registers[] = {
	{SMART_COPYRIGHT, "copyright", R_INFO, 0, T_BINARY, 8+2, 2, "y", 1},
	{SMART_FIRMWARE, "firmware", R_INFO, 0, T_BINARY, 6+2, 2, "b", 1},
	{SMART_INIT, "initialize", R_COMMAND, 0, T_BINARY, 2+2, 2, "Y", 1},
	{SMART_LASTTEST, "last-test", R_STATUS, 0, T_BINARY, 2+2, 2, "X", 1},
	{SMART_LIGHTTEST, "light-test", R_COMMAND | R_STATUS, 0, T_BINARY, 2+2, 2, "A", 1},
	{SMART_MODEL, "model", R_INFO, 0, T_BINARY, 17+2, 2, "", 1},
	{SMART_MODIFY, NULL, R_COMMAND, 0, T_BINARY, 2+2, 2, "-", 1},
	{SMART_POWERTEST, "power-test", R_COMMAND, 0, T_BINARY, 2+2, 2, "U", 1},
	{SMART_SELFTEST, "self-test", R_COMMAND, 0, T_BINARY, 0, 0, "W", 1},
	{SMART_SERIAL, "serial", R_INFO, 0, T_BINARY, 12+2, 2, "n", 1},
	{SMART_SHUTDOWN, "shutdown", R_COMMAND, APC_WRITE, T_BINARY, 0, 0, "S", 1},
	{SMART_STATUS, "status", R_INFO, 0, T_BINARY, 2+2, 2, "Q", 1},
	{SMART_WRITE, NULL, R_COMMAND, 0, T_BINARY, 2+2, 2, apc_SmartWriteBuffer, 1},
	{0, NULL, 0, 0, 0, 0, 0, NULL, 0}
};

/* Legal values for SmartUPS(R) 230V units. */
static struct ups_val apc_SmartUPS_230_values[] = {
	{SMART_HTPOINT, {number: 253}},
	{SMART_HTPOINT, {number: 264}},
	{SMART_HTPOINT, {number: 271}},
	{SMART_HTPOINT, {number: 280}},

	{SMART_LTPOINT, {number: 188}},
	{SMART_LTPOINT, {number: 196}},
	{SMART_LTPOINT, {number: 204}},
	{SMART_LTPOINT, {number: 208}},

	{SMART_LOWBATDUR, {number: 2}},
	{SMART_LOWBATDUR, {number: 5}},
	{SMART_LOWBATDUR, {number: 7}},
	{SMART_LOWBATDUR, {number: 10}},

	{SMART_WAKEUPBCAP, {number: 0}},
	{SMART_WAKEUPBCAP, {number: 10}},
	{SMART_WAKEUPBCAP, {number: 25}},
	{SMART_WAKEUPBCAP, {number: 90}},
	{SMART_WAKEUPBCAP, {number: 100}},

	{SMART_WAKEUPDELAY, {number: 0}},
	{SMART_WAKEUPDELAY, {number: 60}},
	{SMART_WAKEUPDELAY, {number: 180}},
	{SMART_WAKEUPDELAY, {number: 300}},

	{SMART_NVOLTAGE, {number: 225}},
	{SMART_NVOLTAGE, {number: 230}},
	{SMART_NVOLTAGE, {number: 240}},
	{SMART_NVOLTAGE, {number: 220}},

	{SMART_SHUTDELAY, {number: 20}},
	{SMART_SHUTDELAY, {number: 180}},
	{SMART_SHUTDELAY, {number: 300}},
	{SMART_SHUTDELAY, {number: 600}},

	{SMART_LINESENS, {binary: "L"}},
	{SMART_LINESENS, {binary: "M"}},
	{SMART_LINESENS, {binary: "H"}},

	{SMART_LINEALARM, {binary: "0"}},
	{SMART_LINEALARM, {binary: "L"}},
	{SMART_LINEALARM, {binary: "T"}},
	{SMART_LINEALARM, {binary: "N"}},

	{SMART_LABEL, {binary: NULL}},

	{SMART_BREPL, {binary: NULL}},

	{0, {binary: NULL}}
};

/*
 * APC Smart-UPS Series Triggers
 */
static struct ups_trig apc_SmartUPS_triggers[] = {
	{SMART_TLINEFAIL, "line-fail", SMART_TLINERSTR, "!", 1},
	{SMART_TLINERSTR, "line-restore", SMART_TLINEFAIL, "$", 1},
	{SMART_TTEST, "ups-test", 0, "*", 1},
	{SMART_TBLOW, "batteries-low", SMART_TBRST, "%", 1},
	{SMART_TBRST, "batteries-restore", SMART_TBLOW, "+", 1},
	{0, NULL, 0, NULL, 0}
};

struct ups_model apc_SmartUPS_230 = {
	"apc-smart",
	"smart-ups",
	230,
	sizeof(apc_SmartUPS_registers)/sizeof(struct ups_reg),
	apc_SmartUPS_registers,
	apc_SmartUPS_triggers,
	apc_SmartUPS_230_values,
	apc_poll,
	apc_tune
};

struct ups_model apc_SmartUPS_vs_420 = {
	"apc-smart-vs",
	"smart-ups-vs",
	420,
	sizeof(apc_SmartUPS_vs_registers)/sizeof(struct ups_reg),
	apc_SmartUPS_vs_registers,
	apc_SmartUPS_triggers,
	apc_SmartUPS_230_values,
	apc_poll,
	apc_tune
};
