(* $I1: Unison file synchronizer: src/fspath.mli $ *)
(* $I2: Last modified by vouillon on Wed, 26 May 2004 09:43:22 -0400 $ *)
(* $I3: Copyright 1999-2004 (see COPYING for details) $ *)

(* Defines an abstract type of absolute filenames (fspaths)                  *)

type t

val child : t -> Name.t -> t
val concat : t -> Path.local -> t

val canonize : string option -> t
val toString : t -> string
val concatToString : t -> Path.local -> string

(* If the string is the name of the local root, returns a localPath such     *)
(* that concatenated to the root, it points to the same file as              *)
(* (fspath, path) in this replica.                                           *)
val fullLocalPath : string -> t -> Path.local -> Path.local

(* If fspath+path refers to a (followed) symlink, then return the directory  *)
(* of the symlink's target; otherwise return the parent dir of path.  If     *)
(* fspath+path is a root directory, raise Fatal.                             *)
val findWorkingDir : t -> Path.local -> (t * Path.local)

(* Return the least distinguishing suffixes of two fspaths, for displaying   *)
(* in the user interface.                                                    *)
val differentSuffix: t -> t -> (string * string)

(* Return the AppleDouble filename; if root dir, raise Invalid_argument      *)
val appleDouble : t -> t
(* Return the resource fork filename; if root dir, raise Invalid_argument    *)
val rsrc : t -> t

(* Wrapped system calls that use invariants of the fspath internal rep       *)
(* BE SURE TO USE ONLY THESE, NOT VERSIONS FROM THE UNIX MODULE!             *)
val stat : t -> Unix.LargeFile.stats
val lstat : t -> Unix.LargeFile.stats
val opendir : t -> Unix.dir_handle
