;
;	*****RSWITCH.ASM task switching code for the TC V2.0 environment
;
;
;	First try at a TC vers 2.0 "coswitch.asm" deal
;
;	10-Apr-89 ... BEB
;
;	Rewritten and made operational
;	23-Apr-91 ... MBE
;
;   Coswitch algorithm in C:
;
;   coswitch( old_cs, new_cs, first )
;   int	*old_cs, *new_cs, first;
;   {
;	/* save SP, frame pointers, and other registers in old_cs */
;	if ( first == 0 ) {
;	    /* load sp from new_sp[0] and clear frame pointers */
;	    new_context((int)0, (dptr)0 );
;	    syserr( "new_context() returned in coswitch" );
;	    }
;	else {
;	    /* load sp, frame pointers and other registers from new_cs */
;	    }
;   }


rsw	struc
rsw_bp	dw	?		; saved bp
rsw_ip	dd	?		; return cs:ip
rsw_ocs	dd	?		; old_cs
rsw_ncs	dd	?		; new_cs
rsw_fst	dw	?		; first
rsw	ends

cstate	struc
csp	dw	?		; save sp
css	dw	?		; save ss
csi	dw	?		; save si
cdi	dw	?		; save di
cbx	dw	?		; save bx
cbp	dw	?
cstate	ends

DGROUP	group	_DATA
	assume	cs:RSW_TEXT,ds:DGROUP

_DATA	segment word public 'DATA'
msg	db	'new_context() returned in coswitch',0
_DATA	ends


RSW_TEXT segment byte public 'CODE'

	extrn	_new_context:far
	extrn	_syserr:far

	public	_coswitch

_coswitch proc	far

; /* save SP, frame pointers, and other registers in old_cs */
	mov	ax,sp
	mov	cx,bx
	mov	dx,bp
	push	bp
	mov	bp,sp
	les	bx,rsw_ocs[bp]
	mov	es:css[bx],ss
	mov	es:csp[bx],ax
	mov	es:csi[bx],si
	mov	es:cdi[bx],di
	mov	es:cbx[bx],cx
	mov	es:cbp[bx],dx


; if ( first == 0 ) {
	cmp	rsw_fst[bp],0
	jnz	notzero

;    /* First is 0. */
;    /* Set things up for first activation of this coexpression */
;    /* load sp from new_sp[0] and clear frame pointers */
	les	bx,rsw_ncs[bp]
	mov	ax,es
	mov	ss,ax			;(interrupts deferred after ss load)
	mov	sp,es:csp[bx]		; switch to new stack
	mov	bp,sp
	xor	si,si
	xor	di,di
	xor	bx,bx
	
;   new_context((int)0, (dptr)0 );
;   syserr( "new_context() returned in coswitch" );
;   }
	push	bx			; (dptr)0
	push	bx
	push	bx			; (int)0
	call	_new_context

	push	ds
	mov	ax,offset DGROUP:msg
	push	ax
	call	_syserr			; should not return
	mov	sp,bp
	pop	bp
	ret


;   else {
;      /* load sp, frame pointers and other registers from new_cs */
;      }
notzero:
	les	bx,rsw_ncs[bp]
	mov	ss,es:css[bx]		;(interrupts deferred after ss load)
	mov	sp,es:csp[bx]
	mov	bp,es:cbp[bx]
	mov	si,es:csi[bx]
	mov	di,es:cdi[bx]
	mov	bx,es:cbx[bx]
	ret

_coswitch endp
RSW_TEXT ends
	end
