/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.internal.operation;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.InstanceSpecification;
import org.eclipse.uml2.Slot;
import org.eclipse.uml2.StructuralFeature;
import org.eclipse.uml2.UML2Plugin;
import org.eclipse.uml2.internal.operation.UML2Operations;

public final class InstanceSpecificationOperations
extends UML2Operations {
    private InstanceSpecificationOperations() {
    }

    public static boolean validateSlotsAreDefined(InstanceSpecification instanceSpecification, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        Iterator slots = instanceSpecification.getSlots().iterator();
        block0: while (slots.hasNext()) {
            Slot slot = (Slot)slots.next();
            Iterator classifiers = instanceSpecification.getClassifiers().iterator();
            while (classifiers.hasNext()) {
                Classifier classifier = (Classifier)classifiers.next();
                if (classifier.allFeatures().contains(slot.getDefiningFeature())) continue block0;
            }
            result = false;
            if (diagnostics == null) {
                return result;
            }
            diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 28, UML2Plugin.INSTANCE.getString("_UI_InstanceSpecification_SlotsAreDefined_diagnostic", UML2Operations.getMessageSubstitutions(context, slot, instanceSpecification)), new Object[]{instanceSpecification, slot}));
        }
        return result;
    }

    public static boolean validateNoDuplicateSlots(InstanceSpecification instanceSpecification, DiagnosticChain diagnostics, Map context) {
        boolean result = true;
        HashSet<StructuralFeature> definingFeatures = new HashSet<StructuralFeature>();
        Iterator slots = instanceSpecification.getSlots().iterator();
        while (slots.hasNext()) {
            StructuralFeature definingFeature = ((Slot)slots.next()).getDefiningFeature();
            if (definingFeatures.contains(definingFeature)) {
                result = false;
                if (diagnostics == null) {
                    return result;
                }
                diagnostics.add((Diagnostic)new BasicDiagnostic(2, "org.eclipse.uml2", 29, UML2Plugin.INSTANCE.getString("_UI_InstanceSpecification_NoDuplicateSlots_diagnostic", UML2Operations.getMessageSubstitutions(context, definingFeature, instanceSpecification)), new Object[]{instanceSpecification, definingFeature}));
                continue;
            }
            definingFeatures.add(definingFeature);
        }
        return result;
    }
}

