/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.uml2.uml.BehavioredClassifier;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.RedefinableElement;
import org.eclipse.uml2.uml.Region;
import org.eclipse.uml2.uml.State;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.internal.operations.NamespaceOperations;

public class StateOperations
extends NamespaceOperations {
    protected StateOperations() {
    }

    public static boolean validateSubmachineStates(State state, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateDestinationsOrSourcesOfTransitions(State state, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateSubmachineOrRegions(State state, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateCompositeStates(State state, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean validateEntryOrExit(State state, DiagnosticChain diagnostics, Map context) {
        return true;
    }

    public static boolean isSimple(State state) {
        return state.getRegions().isEmpty();
    }

    public static boolean isComposite(State state) {
        return !state.getRegions().isEmpty();
    }

    public static boolean isOrthogonal(State state) {
        return state.getRegions().size() > 1;
    }

    public static boolean isSubmachineState(State state) {
        return state.getSubmachine() != null;
    }

    public static Classifier redefinitionContext(State state) {
        StateMachine sm = state.containingStateMachine();
        if (sm != null) {
            BehavioredClassifier context = sm.getContext();
            return context == null || !sm.getGenerals().isEmpty() ? sm : context;
        }
        return null;
    }

    public static boolean isRedefinitionContextValid(State state, State redefined) {
        Region container = state.getContainer();
        if (container != null && redefined != null) {
            return container.getExtendedRegion() == redefined.getContainer();
        }
        return false;
    }

    public static boolean isConsistentWith(State state, RedefinableElement redefinee) {
        if (redefinee.isRedefinitionContextValid(state)) {
            State redefineeState = (State)redefinee;
            if (state.isSimple()) {
                return redefineeState.isComposite();
            }
            if (state.isComposite()) {
                EList regions = state.getRegions();
                Iterator redefineeRegions = redefineeState.getRegions().iterator();
                while (redefineeRegions.hasNext()) {
                    Region redefineeRegion = (Region)redefineeRegions.next();
                    Region extendedRegion = redefineeRegion.getExtendedRegion();
                    if (!regions.contains((Object)extendedRegion) || extendedRegion.isConsistentWith(redefineeRegion)) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public static StateMachine containingStateMachine(State state) {
        Region container = state.getContainer();
        return container == null ? null : container.containingStateMachine();
    }
}

