.TH "TXT2TAGS" 1 "Janvier 2005" "Version 2.2"

.SH NOM
.P
\fBtxt2tags\fR \- outil de conversion et de mise au format

.SH SYNOPSIS
.P
\fBtxt2tags\fR [\fIOPTION\fR]... [\fIFILE\fR]...

.SH DESCRIPTION
.P
\fBtxt2tags\fR est un outil de conversion GPL crit en Python qui gnre des documents en \fIHTML\fR, \fIXHTML\fR, \fISGML\fR, \fILaTeX\fR, \fIMan Page\fR, \fIMoinMoin\fR, \fIMagicPoint\fR et \fIPageMaker\fR  partir d'un simple fichier texte avec un minimum de marques.

.P
L'utilisateur a juste besoin de savoir un minimum de marques simples de \fBtxt2tags\fR, et comment crire des fichiers texte. Le programme fait tout le travail, ajoutant les marques compliques et se dbrouillant avec les problmes du fichier de sortie.

.P
Le mme fichier texte peut tre converti dans tous les formats cible, sans aucune dition supplmentaire. C'est le rle de \fBtxt2tags\fR : UNE source, des sorties MULTIPLES.

.P
\fBNOTE:\fR le noyau de la version 2.0 de \fBtxt2tags\fR a t compltement rcrit. Si vous tes utilisateur d'une version prcdente, vous pouvez tre oblig de rcrire une partie de vos vieux documents.

.P
Visitez la page de base du programme  :
\fIhttp://txt2tags.sourceforge.net\fR.

.SH OPTIONS
.TP
     \fB\-\-css\-sugar\fR
insrer CSS\-friendly tags pour les cibles HTML and XHTML

.TP
     \fB\-\-css\-inside\fR
insrer le contenu du fichier CSS dans l'entte HTML/XHTML

.TP
     \fB\-\-dump\-config\fR
imprimer toute la configuration trouve et sortir

.TP
     \fB\-\-encoding\fR
choisir l'encodage de la sortie (utf\-8, iso\-8859\-1, etc)

.TP
     \fB\-\-gui\fR
appeler l'interface graphique Tk

.TP
 \fB\-h\fR, \fB\-\-help\fR
imprimer les informations d'aide et sortir

.TP
 \fB\-H\fR, \fB\-\-no\-headers\fR
suppression des informations d'entte, de titre, de pied et sortir

.TP
     \fB\-\-headers\fR
montrer les informations d'entte, de titre et de pied (actif par dfaut)

.TP
 \fB\-i\fR, \fB\-\-infile\fR=\fIFILE\fR
choisir FILE comme fichier d'entre ('\-' pour STDIN)

.TP
     \fB\-\-mask\-email\fR
masquer les email des robots scanneurs. x@y.z devient <x (a) y z>

.TP
 \fB\-n\fR, \fB\-\-enum\-title\fR
numroter les titres : 1, 1.1, 1.1.1, etc

.TP
     \fB\-\-no\-encoding\fR
supprimer la configuration d'encodage

.TP
     \fB\-\-no\-enum\-title\fR
supprimer la numrotation automatique des titres

.TP
     \fB\-\-no\-infile\fR
supprimer la dclaration de fichier d'entre

.TP
     \fB\-\-no\-mask\-email\fR
dmasque les emails, supprime l'option \-\-mask\-email

.TP
     \fB\-\-no\-outfile\fR
supprime la dclaration prcdente de fichier de sortie

.TP
     \fB\-\-no\-quiet\fR
imprime les messages supprime l'option \-\-quiet

.TP
     \fB\-\-no\-rc\fR
ne pas lire le fichier de configuration utilisateur ~/.txt2tagsrc

.TP
     \fB\-\-no\-style\fR
supprimer la dclaration de style

.TP
     \fB\-\-no\-toc\fR
ne pas ajouter de table des matires au document de sortie

.TP
     \fB\-\-no\-toc\-only\fR
supprimer l'option \-\-toc\-only

.TP
 \fB\-o\fR, \fB\-\-outfile\fR=\fIFILE\fR
gnrer le fichier de sortie FILE ('\-' pour STDOUT)

.TP
 \fB\-q\fR, \fB\-\-quiet\fR
mode silencieux, supprime toutes les sorties (sauf les erreurs)

.TP
     \fB\-\-rc\fR
lire la configuration utilisateur ~/.txt2tagsrc (actif par dfaut)

.TP
     \fB\-\-style\fR=\fIFILE\fR
utiliser FILE comme style de document (comme Html CSS)

.TP
\fB\-t\fR, \fB\-\-target\fR
choisit le type de document de sortie, options actuelles :
html, xhtml, sgml, tex, lout, man, mgp, moin, pm6, txt

.TP
     \fB\-\-toc\fR
ajouter la table des matires au document de sortie

.TP
     \fB\-\-toc\-level\fR=\fIN\fR
mettre le niveau maximum de la table des matires  N

.TP
     \fB\-\-toc\-only\fR
imprime la table des matires et sort

.TP
 \fB\-v\fR, \fB\-\-verbose\fR
imprime les message d'information pendant la conversion

.TP
 \fB\-V\fR, \fB\-\-version\fR
imprime la version du programme et sort

Par dfaut la sortie convertie est sauve dans 'file.<type>'.
Utiliser \-\-outfile pour forcer le nom du fichier de  sortie.
Si le fichier d'entre est '\-', on lit  partir de STDIN.
Si le fichier de sortie est '\-', la sortie se fait sur STDOUT.

.SH STRUCTURE
.P
Le fichier source \fBtxt2tags\fR peut comporter trois zones.

.TP
\fBEntte\fR
Les trois premires lignes. Elles sont utilises pour l'identification du document. Si vous n'avez pas besoin de l'entte, vous devez laisser ces trois lignes libres ou utiliser l'option no\-header.

.TP
\fBConfiguration\fR
Dmarre  la quatrime ligne. Toutes les lignes ont la forme %!keyword: valeur. Les configurations peuvent aussi tre faites par un fichier de configuration ou  la ligne de commande.

.TP
\fBCorps\fR
La vraie partie du document. Seule cette partie est obligatoire pour avoir un fichier \fBtxt2tags\fR valide.

.SH CONFIGURATION
.P
\fBtxt2tags\fR peut tre personnalis de l'extrieur ou de l'intrieur. De l'extrieur par un fichier \&.txt2tagsrc ou par un fichier import d'un autre fichier \fBtxt2tags\fR. La personnalisation interne est faite par des commandes de configuration spciales dans le document source. Tous les deux utilisent la mme syntaxe :

.TP
\fB%!target:\fR
dfinit la cible principale

.TP
\fB%!options(target):\fR
dfinit les options de chaque cible

.TP
\fB%!include: file.t2t\fR
inclut un fichier \fBtxt2tags\fR

.TP
\fB%!include: ``file.txt``\fR
inclut un fichier texte dans le document

.TP
\fB%!include: ''file.html''\fR
inclut un fichier tel qu'il est

.TP
\fB%!style:\fR
dfinit un fichier CSS (Cascading Style Sheet) pour les cibles XHTML et HTML ou pour charger des modules dans la cible TEX (par \eusepackage)

.TP
\fB%!encoding:\fR
choisit l'encodage de la cible (comme iso\-8859\-1) pour les traductions i18n

.TP
\fB%!includeconf:\fR
inclut une configuration  partir d'un fichier externe

.TP
\fB%!guicolors:\fR
configuration des couleurs pour l'interface GUI (Tk/Tcl)

.TP
\fB%!preproc:\fR
vos filtres personnels (macro) qui seront effectus \fBAVANT\fR le traitement

.TP
\fB%!postproc:\fR
vos filtres personnels (macro) qui seront effectus \fBAPRES\fR le traitement

.SS REGLES POUR LA CONFIGURATION
.RS
.IP \(bu 3
les configurations ne sont valides que dans la zone de configuration et sont considrs comme des commentaires dans le corps du document. Une exception est include qui est valide dans le corps.

.IP \(bu 3
si le mme mot clef apparat plus d'une fois dans la zone de configuration, le dernier trouv est celui utilis. Exceptions : options, preproc et postproc, qui peuvent tre cumulatifs.

.IP \(bu 3
Une ligne de configuration avec un mot clef invalide est considre comme du commentaire.

.IP \(bu 3
Ces configurations ont priorit sur le fichier \&.txt2tagsrc, mais pas sur les options de la ligne de commande.
.RE

.SH SYNTAXE
.P
Un syntaxe simple de marques est utilise dans le document source (le fichier texte)
pour identifier les structures et la mise au format. Voici la liste complte :

.SS Basique
.nf
  Entte            Les 3 premires lignes su fichier source
  Titre             = mots =
  Titre numrot    + mots +
  Paragraphe        mots
.fi


.SS Enjoliveurs
.nf
  Gras              **mots**
  Italique          //mots//
  Soulign          __mots__
  Machine  crire  ``mots``
.fi


.SS Blocs de texte
.nf
  Quote                   <TAB>mots
  Liste                   - mots
  Liste numrote         + mots
  Liste de dfinitions    : mots
  Ligne verbatim          ``` mots
  Zone verbatim           ```<retour  la ligne> lignes <retour  la ligne>```
  Ligne brute             """ mots
  Zone brute              """<retour  la ligne> lignes <retour  la ligne>"""
  Table                   | cellule1 | cellule2 | cellule3...
.fi


.SS Autres
.nf
  Ligne de sparation    -----------------------...
  Ligne plus paisse     =======================...
  Liens                 [label url]
  Image                 [<nom de fichier>.jpg]
  Texte brut            ""mots""
  Commentaire           % commentaires
.fi


.P
Lire le User Guide de \fBtx2tags\fR (dans le rpertoire de la documentation)
pour une description dtaille de chaque marque.

.SH EXEMPLES
.P
Considrons que vous avez crit un fichier marqu `file.t2t`,
voyons comment oprer pour la conversion.

.TP
\fBConversion vers HTML dans le fichier file.html\fR
$ txt2tags \-t html file.t2t

.TP
\fBMme travail, mais en utilisant une redirection\fR
$ txt2tags \-t html \-o \- file.t2t > file.html

.TP
\fBEt en ajoutant une table des matires (TDM)\fR
$ txt2tags \-t html \-\-toc file.t2t

.TP
\fBAvec une TDM et des titres numrots\fR
$ txt2tags \-t html \-\-toc \-\-enum\-title file.t2t

.TP
\fBQue la TDM\fR
$ txt2tags \-\-toc\-only file.t2t

.TP
\fBUtilisation de l'interface graphique\fR
$ txt2tags \-\-gui file.t2t

.TP
\fBPost\-conversion avec un filtre externe\fR
$ txt2tags \-t html \-o\- file.t2t | sed \-f myfilter.sed > file.html

.TP
\fBTest sur une ligne avec entre  partir de STDIN\fR
$ echo \-e "\en**bold**" | txt2tags \-t html \-H \-

.SH TRUCS
.P
Il y a quelques trucs agrables qui font de \fBtxt2tags\fR un excellent outil pour la documentation.

.TP
Ancres
Les titres peuvent avoir des liens avec des ancres pour vous permettre d'y aller directement, si la cible l'autorise.

.nf
  Titre             = mots =[ancre]
  Titre numrots   + mots +[ancre]
.fi


.TP
Fichiers multiples
\fBtxt2tags\fR peut traiter plus d'un fichier  la fois comme :
txt2tags *.t2t

.SH MACROS
.TP
%%date
Permet d'inclure la date courante, dans le format YYYYMMDD.
Un format optionnel peut tre dfini en utilisant la syntaxe :
%%date(format\-string).

.TP
%%infile
Utilis pour obtenir des informations sur le fichier source. Une mise au format optionnelle
peut tre spcifie par la syntaxe :  %%infile(format\-string).
Un lien utile dans le pied de page comme [voir le fichier source %%infile], ainsi vous pouvez 
changer le nom du fichier et la rfrence sera mise  jour.

.TP
%%mtime
Donne les informations sur la date de modification du fichier.
Il utilise le mme format que la macro %%date.

.TP
%%outfile
Utilis pour obtenir des informations sur le fichier converti.
Une mise au format optionnelle est spcifie par la syntaxe %%outfile(format\-string).
Ainsi pour indiquer "Ceci est le fichier de sortie manpage\-fr.man ".
Vous pouvez changer le nom du ficher et sa rfrence sera mise  jour.

.TP
%%toc
La macro %%toc spcifie o la TDM va tre insre. Vous pouvez la mettre n'importe o dans le document.

NOTE: %%toc ne sera dveloppe qu'avec l'option \-\-toc.

.SH AUTEUR
.P
Ecrit et maintenu par Aurelio Marinho Jargas <verde@aurelio.net>

.P
Cette page de manuel a t crite par Jose Inacio Coelho <jic@technologist.com>
comme un fichier texte, puis converti au format man par \fBtxt2tags\fR!

.P
Traduit par Claude Hiebel <chiebel@free.fr>.

.SH COPYRIGHT
.P
Copyright (C) 2001, 2002, 2003, 2004, 2005 Aurelio Marinho Jargas

.P
This is free software; see the source for copying condpuis converti au format man par
NO warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.


.\" man code generated by txt2tags 2.3.3-dev (http://txt2tags.sf.net)
.\" cmdline: txt2tags -t man doc/French/manpage-fr.t2t

