.TH "TXT2TAGS" 1 "Julho, 2004" ""

.SH NOME
.P
txt2tags \- ferramenta para formatar e converter textos

.SH SINOPSE
.P
\fBtxt2tags\fR [\fIOPO\fR]... [\fIARQUIVO\fR]...

.SH DESCRIO
.P
O \fBtxt2tags\fR  uma ferramenta GPL de converso de formatos escrita
em Python que gera documentos em \fIHTML\fR, \fIXHTML\fR, \fISGML\fR,
\fILaTeX\fR, \fIMan Page\fR, \fIMoinMoin\fR, \fIMagic Point\fR e \fIPagemaker\fR
a partir de um nico arquivo de texto com algumas marcaes.

.P
O usurio s precisa conhecer algumas marcas usadas pelo \fBtxt2tags\fR,
e escrever textos normais. O programa faz todo o trabalho sujo,
adicionando as tags complicadas e lidando com as pegadinhas dos
documentos de destino.

.P
O mesmo arquivo texto pode ser convertido para todos os formatos
disponveis, sem a necessidade de qualquer alterao. Esta  a
finalidade do \fBtxt2tags\fR: UM arquivo fonte, VRIOS destinos.

.P
\fBNOTA:\fR A verso 2.0 do txt2tags foi completamente reescrita a
partir do zero. Logo, se voc for um usurio de verses anteriores do
txt2tags,  possvel que necessite reescrever partes de seus
documentos antigos.

.P
Visite a pgina do programa em
\fIhttp://txt2tags.sourceforge.net\fR.

.SH OPES
.TP
     \fB\-\-css\-sugar\fR
insere tags compatveis com CSS em destinos HTML e XHTML

.TP
     \fB\-\-css\-inside\fR
insere o contedo do arquivo CSS no documento HTML/XHTML

.TP
     \fB\-\-dump\-config\fR
exibe todas as configuraes encontradas e sai

.TP
     \fB\-\-encoding\fR
informa a codificao de destino (utf\-8, iso\-8859\-1, etc)

.TP
     \fB\-\-gui\fR
carrega a interface grfica escrita em TK

.TP
 \fB\-h\fR, \fB\-\-help\fR
exibe o texto de ajuda e sai

.TP
 \fB\-H\fR, \fB\-\-no\-headers\fR
suprime os cabealhos, ttulo e rodap

.TP
     \fB\-\-headers\fR
exibe os cabealhos, ttulo e rodap (padro LIGADO)

.TP
 \fB\-i\fR, \fB\-\-infile\fR=\fIARQUIVO\fR
define ARQUIVO como arquivo fonte ('\-' para STDIN)

.TP
     \fB\-\-mask\-email\fR
esconde os e\-mails dos robs de SPAM. x@y.z vira <x (a) y z>

.TP
 \fB\-n\fR, \fB\-\-enum\-title\fR
numera todos os ttulos como 1, 1.1, 1.1.1, etc

.TP
     \fB\-\-no\-encoding\fR
exclui a configurao de codificao

.TP
     \fB\-\-no\-enum\-title\fR
desativa a auto\-numerao de ttulos

.TP
     \fB\-\-no\-infile\fR
exclui as definies anteriores do arquivo fonte

.TP
     \fB\-\-no\-mask\-email\fR
exibe os e\-mails, desabilitando a opo \-\-mask\-email

.TP
     \fB\-\-no\-outfile\fR
exclui as definies anteriores sobre o arquivo de destino

.TP
     \fB\-\-no\-rc\fR
no l o arquivo configurao do usurio em ~/.txt2tagsrc

.TP
     \fB\-\-no\-style\fR
exclui as configuraes de estilo

.TP
     \fB\-\-no\-toc\fR
no inclui o ndice (Table of Contents) no documento de destino

.TP
     \fB\-\-no\-toc\-only\fR
desativa a opo \-\-toc\-only

.TP
 \fB\-o\fR, \fB\-\-outfile\fR=\fIARQUIVO\fR
define ARQUIVO como destino ('\-' para STDOUT)

.TP
     \fB\-\-rc\fR
l a configurao do usurio em ~/.txt2tagsrc (padro LIGADO)

.TP
     \fB\-\-style\fR=\fIARQUIVO\fR
utiliza ARQUIVO como estilo do documento (como o CSS do Html)

.TP
\fB\-t\fR, \fB\-\-target\fR
define o tipo do documento de destino. atualmente suportados:
html, xhtml, sgml, tex, man, mgp, moin, pm6, txt

.TP
     \fB\-\-toc\fR
inclui o ndice (Table of Contents) no documento de destino

.TP
     \fB\-\-toc\-level\fR=\fIN\fR
define o nvel mximo (profundidade) do ndice para N

.TP
     \fB\-\-toc\-only\fR
exibe o ndice do documento e sai

.TP
 \fB\-v\fR, \fB\-\-verbose\fR
exibe mensagens informativas durante a converso

.TP
 \fB\-V\fR, \fB\-\-version\fR
exibe a verso do programa e sai

.P
Normalmente a sada convertida  gravada em 'arquivo.<tipo>'.
Utilize \-\-outfile para forar um nome para o arquivo de sada.
Se o arquivo de entrada  '\-', l de STDIN.
Se o arquivo de sada  '\-', envia a sada para STDOUT.

.SH ESTRUTURA
.P
Um arquivo fonte txt2tags pode ter trs reas:

.TP
\fBCabealho\fR
As primeiras trs linhas. So usadas para identificao do documento.
Se no for necessrio, o cabealho pode ser suprimido pela
configurao no\-header.

.TP
\fBConfigurao\fR
Inicia a partir da quarta linha. Todas as configuraes tm o formato
%!chave: valor. As configuraes tambm podem ser realizadas por
arquivos de configurao ou linha de comando.

.TP
\fBCorpo\fR
O verdadeiro documento!  a nica rea necessria para que se tenha um
documento txt2tags vlido.

.SH CONFIGURAES
.P
O Txt2tags pode ser personalizado por mtodos internos e externos. Os
meios externos podem ser de um arquivo chamado \&.txt2tagsrc ou
importado de outro arquivo txt2tags. O jeito interno  feito por
comandos includos na rea de configurao do fonte. Ambas formas usam
a mesma sintaxe:

.TP
\fB%!target:\fR
define o formato destino (target) principal

.TP
\fB%!options(target):\fR
define as opes de cada destino

.TP
\fB%!include: arquivo.txt\fR
incli um arquivo texto no documento

.TP
\fB%!include: ''arquivo.html''\fR
include um arquivo literal no documento, \fIipsis literis\fR

.TP
\fB%!style:\fR
para indicar um arquivo CSS (Cascading Style Sheets) para os destinos
XHTML e HTML ou carregar um mdulo \eusepackage no destino TEX

.TP
\fB%!encoding:\fR
para indicar um conjunto de caracteres (como iso\-8859\-1) para usurios
de lngua no\-inglesa

.TP
\fB%!includeconf:\fR
usado para incluir configuraes a partir de um arquivo externo

.TP
\fB%!guicolors:\fR
configuraes de cores para a interface grfica (tk/tcl)

.TP
\fB%!preproc:\fR
filtros personalizados (macros) que sero processados \fBANTES\fR da
avaliao do documento

.TP
\fB%!postproc:\fR
filtros personalizados (macros) que sero processados \fBAPS\fR a
avaliao do documento

.SH REGRAS DAS CONFIGURAES
.RS
.IP \(bu 3
As configuraes so vlidas somente dentro da rea de
Configurao, e sero consideradas comentrios simples se forem
encontradas no Corpo do documento.

.IP \(bu 3
Se a mesma palavra\-chave aparece mais de uma vez na rea de
Configurao, apenas a ltima ser usada. Exceo: options, preproc
e postproc, que so acumulativas.

.IP \(bu 3
Uma linha de configurao com uma palavra\-chave invlida ser
considerada um comentrio.

.IP \(bu 3
Estas configuraes tm precedncia sobre o arquivo txt2tagsrc, mas
no sobre as opes de linha de comando.
.RE

.SH SINTAXE
.P
Uma sintaxe de marcas bem simples  utilizada no arquivo fonte
(o arquivo de texto puro) para identificar as estruturas
e a formatao. Aqui est a lista completa:

.SS Bsico
.nf
  Cabealhos        As 3 primeiras linhas do arquivo fonte
  Ttulo            = palavras =
  Ttulo numerado   + palavras +
  Pargrafo         palavras
.fi


.SS Embelezadores
.nf
  Negrito           **palavras**
  Itlico           //palavras//
  Sublinhado        __palavras__
  Monoespaado      ``palavras``
.fi


.SS Text Blocks
.nf
  Citao             <TAB>palavras
  Lista               - palavras
  Lista numerada      + palavras
  Lista de definio  : palavras
  Linha formatada     ``` palavras
  rea formatada      ```<Quebra> linhas <Quebra>```
  Linha protegida     """ palavras
  rea protegida      """<Quebra> linhas <Quebra>"""
  Tabela              | cel1 | cel2 | cel3...
.fi


.SS Outros
.nf
  Linha de separao  -----------------------...
  Linha destacada     =======================...
  Links               [nome url]
  Imagem              [arquivo.XXX]
  Texto protegido     ""palavras""
  Data atual          %%date(formato)
  Comentrio          % comentrios
.fi


.P
Por favor, leia o arquivo \fBREGRAS\fR (no diretrio de documentao
do programa) para uma descrio detalhada de cada marca.

.SH EXEMPLOS
.P
Supondo que voc criou um arquivo marcado chamado arquivo.t2t,
vamos nos divertir fazendo algumas converses.

.TP
\fBConverte para HTML, gravando em arquivo.html\fR
$ txt2tags \-t html arquivo.t2t

.TP
\fBSimilar ao anterior, usando redirecionamento\fR
$ txt2tags \-t html \-o \- arquivo.t2t > arquivo.html

.TP
\fBIncluindo o ndice\fR
$ txt2tags \-t html \-\-toc arquivo.t2t

.TP
\fBIncluindo o ndice e ttulos numerados\fR
$ txt2tags \-t html \-\-toc \-\-enum\-title arquivo.t2t

.TP
\fBExibio rpida do contedo\fR
$ txt2tags \-\-toc\-only arquivo.t2t

.TP
\fBUtilizando a interface grfica\fR
$ txt2tags \-\-gui arquivo.t2t

.TP
\fBEdio ps\-converso utilizando filtro externo\fR
$ txt2tags \-t html \-o\- arquivo.t2t | sed \-f meufiltro.sed > arquivo.html

.TP
\fBTeste rpido de uma linha vindo de STDIN\fR
$ echo \-e "\en**negrito**" | txt2tags \-t html \-H \-

.SH UTILIDADES
.P
H alguns truques que tornam o txt2tags uma excelente ferramenta de
documentao:

.TP
Ancoramento
Os Ttulos podem ser ligados por ncoras (se o formato de destino
permitir). Isso permite ir diretamente a alguma parte do documento.

.nf
  Ttulo            = palavras =[ncora]
  Ttulo Numerado   + palavras +[ncora]
.fi


.TP
Mltiplos arquivos
O Txt2tags pode manipular mais de um arquivo, como:
\fBtxt2tags *.t2t\fR

.TP
A macro %%date
Permite incluir a data corrente no formato ISO aaaammdd. Uma
formatao opcional pode ser especificada com a sintaxe
%%date(formato).

.SH AUTOR
.P
O txt2tags foi criado e  mantido por Aurlio Marinho Jargas
<verde@aurelio.net>

.P
Esta Pgina de Manual foi escrita por Jos Incio Coelho
<jic@technologist.com> como um arquivo texto, e convertida para o
formato de manual no \fBtxt2tags\fR!

.P
A traduo deste manual para o portugus foi feita por Mauricio
Teixeira <mteixeira@webset.net>

.SH LICENA
.P
Copyright (C) 2001, 2002, 2003, 2004 Aurlio Marinho Jargas

.P
Este programa  livre. Veja nos arquivos fonte as condies de cpia.
NO H garantia, nem de COMERCIALIZAO nem de ADEQUAO A QUALQUER
PROPSITO.


.\" man code generated by txt2tags 2.2 (http://txt2tags.sf.net)
.\" cmdline: txt2tags doc/pt_BR/abuse-me.t2t doc/pt_BR/exemplo.t2t doc/pt_BR/guia-usuario.t2t doc/pt_BR/manual.t2t

