<?php
// $Horde: turba/lib/api.php,v 1.14.2.7 2002/04/12 16:10:08 jan Exp $

// Find the base file path of Turba
if (!defined('TURBA_BASE')) define('TURBA_BASE', dirname(__FILE__) . '/..');

// Include the Turba base libraries and setup.
require_once TURBA_BASE . '/lib/base.php';

function turbaExpandAddresses($names = array(), $addressbooks = array(), $fields = array())
{
    global $cfgSources;
    include TURBA_BASE . '/config/attributes.php';
    include_once TURBA_BASE . '/lib/Source.php';

    if (!isset($cfgSources) || !is_array($cfgSources) || !count($cfgSources)) {
        return array();
    }

    if (count($addressbooks) == 0) {
        $addressbooks = array(key($cfgSources));
    }

    $results = array();
    $seen = array();
    foreach ($addressbooks as $source) {
        if (isset($cfgSources[$source])) {
            $driver = &Turba_Source::singleton($source, $cfgSources[$source]);
            if (PEAR::isError($driver)) {
                return new PEAR_Error(_("Failed to connect to the specified directory."), HORDE_ERROR, null, null, $source);
            }

            foreach ($names as $name) {
                $criteria = array();
                if (isset($fields[$source])) {
                    foreach ($fields[$source] as $field) {
                        $criteria[$field] = trim($name);
                    }
                }
                if (count($criteria) == 0) {
                    $criteria['name'] = trim($name);
                }
                $res = $driver->search($criteria, 'lastname', TURBA_SEARCH_OR);
                if (!isset($results[$name])) {
                    $results[$name] = array();
                }
                if (get_class($res) == 'turba_list') {
                    while ($ob = $res->next()) {
                        $att = $ob->getAttributes();
                        foreach ($att as $key => $value) {
                            if (!empty($value) && isset($attributes[$key]) &&
                                $attributes[$key]['type'] == 'email' &&
                                empty($seen[$name][trim(strtolower($att['name'])) . trim(strtolower($value))])) {

                                $results[$name][] = array('name' => $att['name'], 'email' => $value);
                                $seen[$name][trim(strtolower($att['name'])) . trim(strtolower($value))] = true;
                            }
                        }
                    }
                }
            }

        }
    }

    return $results;
}

function turbaAddAddress($name = '', $address = '', $addressbook = '')
{
    global $cfgSources;
    include_once 'PEAR.php';
    include_once TURBA_BASE . '/lib/Source.php';

    if (empty($addressbook) || !isset($cfgSources[$addressbook])) {
        return PEAR::raiseError(_("Invalid addressbook."), HORDE_ERROR, null, null, $addressbook);
    }

    if (empty($name)) {
        return PEAR::raiseError(_("Invalid name."), HORDE_ERROR, null, null, $addressbook);
    }

    if (empty($address)) {
        return PEAR::raiseError(_("Invalid e-mail address."), HORDE_ERROR, null, null, $addressbook);
    }

    if ($cfgSources[$addressbook]['readonly']
        && (!isset($cfgSources[$addressbook]['admin'])
        || !in_array(Auth::getAuth(), $cfgSources[$addressbook]['admin']))) {
        return PEAR::raiseError(_("Addressbook is read-only."), HORDE_ERROR, null, null, $addressbook);
    }

    $driver = &Turba_Source::singleton($addressbook, $cfgSources[$addressbook]);
    $res = $driver->search(array('name' => $name, 'email' => $address), 'lastname', TURBA_SEARCH_AND);
    if (PEAR::isError($res) || $res->count() > 0) {
        return PEAR::raiseError(_("This person is already in your addressbook."), HORDE_MESSAGE, null, null, $addressbook);
    }

    return $driver->addObject(array('name' => $name, 'email' => $address, '__owner' => Auth::getAuth()));
}

function turbaGetSources($writeable = false)
{
    global $cfgSources;
    include_once 'PEAR.php';

    if (!isset($cfgSources) || !is_array($cfgSources) || !count($cfgSources)) {
        return array();
    }

    $readonly = array();
    $writeonly = array();

    foreach ($cfgSources as $key => $entry) {
        if ($entry['readonly'] && (!isset($entry['admin']) || !in_array(Auth::getAuth(), $entry['admin']))) {
            $readonly[$key] = $entry['title'];
        } else {
            $writeonly[$key] = $entry['title'];
        }
    }

    if ($writeable) {
        return $writeonly;
    } else {
        return array_merge($readonly, $writeonly);
    }
}

function turbaGetFields($addressbook = '')
{
    global $cfgSources;
    include TURBA_BASE . '/config/attributes.php';
    include_once 'PEAR.php';

    if (empty($addressbook) || !isset($cfgSources[$addressbook])) {
        return PEAR::raiseError(_("Invalid addressbook."), HORDE_ERROR, null, null, $addressbook);
    }

    $fields = array();
    foreach ($cfgSources[$addressbook]['map'] as $field_name => $null) {
        if (substr($field_name, 0, 2) != '__') {
            $fields[$field_name] = array('name' => $field_name,
                                         'type' => $attributes[$field_name]['type'],
                                         'desc' => $attributes[$field_name]['desc'],
                                         'search' => in_array($field_name, $cfgSources[$addressbook]['search']));
        }
    }

    return $fields;
}

?>
