<?php
// $Horde: turba/lib/Turba.php,v 1.15.2.5 2002/04/12 16:10:08 jan Exp $

// Search types
/** @const TURBA_SEARCH_AND. Boolean 'and' search. */ define('TURBA_SEARCH_AND', 1);
/** @const TURBA_SEARCH_OR Boolean 'or' search.    */ define('TURBA_SEARCH_OR', 2);

/**
 * Turba Base Class.
 *
 * @author Chuck Hagenbuch <chuck@horde.org>
 * @author Jon Parise <jon@horde.org>
 * @version $Revision: 1.15.2.5 $
 * @package turba
 */
class Turba {

    function string2Columns($string)
    {
        $ret = array();
        $lines = explode("\n", $string);
        foreach ($lines as $line) {
            $line = trim($line);
            if (!empty($line)) {
                $columns = explode("\t", $line);
                if (count($columns) > 1) {
                    $source = array_splice($columns, 0, 1);
                    $ret[$source[0]] = $columns;
                }
            }
        }

        return $ret;
    }

    function columns2String($hash)
    {
        foreach ($hash as $source => $columns) {
            if (isset($string)) {
                $string .= "\n";
            } else {
                $string = '';
            }
            $line = '';
            foreach ($columns as $column) {
                if (!empty($line)) {
                    $line .= "\t";
                }
                $line .= $column;
            }
        }

        return $string;
    }

    function wapFormat($phoneNumber)
    {
        $phoneNumber = preg_replace('|[ .()-]|', '', $phoneNumber);
        $phoneNumber = preg_replace('|ext(.)*|', '', $phoneNumber);

        return $phoneNumber;
    }

}
?>
