<?php
// $Horde: turba/lib/Group.php,v 1.9.2.1 2002/04/12 16:10:07 jan Exp $

require_once './lib/AbstractObject.php';

/**
 * The Turba_Group:: class provides a set of methods for dealing with
 * contact groups.
 *
 * @author  Chuck Hagenbuch <chuck@horde.org>
 * @author  jon Parise <jon@csh.rit.edu>
 * @version $Revision: 1.9.2.1 $
 * @since   Turba 0.0.1
 * @package turba
 */
class Turba_Group extends Turba_AbstractObject {

    /**
     * Constructs a new Turba_Group object.
     *
     * @param Turba_Source $source   The source object that this group comes from
     * @param array $attributes      (optional) Hash of attributes for this group.
     */
    function Turba_Group(&$source, $attributes = array())
    {
        $this->Turba_AbstractObject($source, $attributes);
    }

    /**
     * Returns true if this object is a group of multiple contacts.
     *
     * @return          True if this a group of multiple contacts.
     */
    function isGroup()
    {
        return true;
    }

    /**
     * Adds a new contact entry to this group.
     *
     * @param Turba_AbstractObject $object   The object to add to the Group
     */
    function addMember($object)
    {
        // TODO: implementation
    }

    /**
     * Deletes a contact entry from this group.
     *
     * @param Turba_AbstractObject $object   The object to remove from the Group
     */
    function removeMember($object)
    {
        // TODO: implementation
    }

}
?>
