// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "unix.h"
#include "tgws.h"
#include "tempfile.h"
#include <map>
#include <fstream>

void
tty_grin_newsgroup__set_flag(tgws::ctree_node *n) {
  message_descriptor *d=(message_descriptor *)(n->get_user_data(0));
  n->set_tag_expanded(d->status());
}

unsigned char
tty_grin_newsgroup__recurse_flag(tgws::ctree_node *n) {
  unsigned char flags=0;
  for(tgws::ctree_node *x=n->get_first();x;x=x->get_next())
    flags|=tty_grin_newsgroup__recurse_flag(x);
  flags|=(((message_descriptor *)(n->get_user_data(0)))->get_flags()^
	  message_descriptor::READ);
  n->set_tag_collapsed(message_descriptor::flags_to_status
		       (flags^message_descriptor::READ));
  return flags;
}

void
tty_grin_newsgroup__refresh_flag(tgws::ctree_node *n) {
  tty_grin_newsgroup__set_flag(n);
  while(n->get_owner()) n=n->get_owner();
  tty_grin_newsgroup__recurse_flag(n);
}

void
tty_grin_newsgroup__mark_as_read(tgws::ctree_node *n) {
  message_descriptor *d=(message_descriptor *)(n->get_user_data(0));
  d->set_flag(message_descriptor::READ);
  tty_grin_newsgroup__refresh_flag(n);
  for(tgws::ctree_node *c=n->get_first();c;c=c->get_next())
    tty_grin_newsgroup__mark_as_read(c);
}

void
tty_grin_newsgroup(newsgroup& group) {
  tgws::active_screen->push();

  {
    tgws::title *t=new tgws::title(group.get_group_name());
    t->size(1, COLS);
    t->position(0, 0);
    t->show();

    tgws::keyblock *k=new tgws::keyblock;
    k->add("<", _("Back"));
    k->add("D", _("(Un)Delete"));
    k->add("M", _("(Un)Mark"));
    k->add("R", _("Make (un)read"));
    k->add("^A", _("Make all read"));
    k->add("^P", _("Post"));
    k->size(2, COLS);
    k->position(LINES-2, 0);
    k->show();
  }

  if(group.size()) {
    tgws::ctree *g=new tgws::ctree(2);
    
    {
      map<newsgroup_message *, tgws::ctree_node *> threadme;

      for(int i=0;i<group.size();i++) {
	newsgroup_message& msg=group[i];
	map<newsgroup_message *, tgws::ctree_node *>::iterator
	  f=threadme.end();
	
	if(msg.get_parent()) f=threadme.find(msg.get_parent());
	tgws::ctree_node *n=g->insert(f==threadme.end()?0:(*f).second, 0);
	n->set_user_data(0, &msg);
	tty_grin_newsgroup__set_flag(n);
	n->set_text(0, msg.get_from());
	n->set_text(1, msg.get_subject());
	threadme[&msg]=n;
      }
    }

    for(tgws::ctree_node *n=g->get_first();n;n=n->get_next())
      tty_grin_newsgroup__recurse_flag(n);

    g->set_headings(true);
    g->set_title(0, _("From"));
    g->set_title(1, _("Subject"));
    g->set_width(0, COLS/2);
    g->set_width(1, COLS/2);
    if(config_get_bool("AUTO-EXPAND")) g->expand_all(true);
    g->size(LINES-5, COLS);
    g->position(2, 0);
    g->show();
    
    int key=0;
    do {
      if(isupper(key=g->run())) key+=32;
      switch(key) {
      case ' ':
      case '\n':
      case KEY_RIGHT:
	{
	  newsgroup_message& m=
	    *(newsgroup_message *)(g->get_cursor()->get_user_data(0));
	  tempfile t;
	  ofstream out(t.filename());
	  m.extract(out);
	  out.close();
	  message msg(t.filename());
	  tty_grin_message(msg, m);
	  tty_grin_newsgroup__refresh_flag(g->get_cursor());
	}
	break;
      case 16:
	{
	  composition c;
	  try {
	    ifstream signature(config_get_string("SIGNATURE"));
	    if(signature.good()) {
	      c.append("\n\n--\n");
	      c.append(signature);
	      signature.close();
	    }
	  }
	  catch(config_error e) { }
	  c.set_header(_("Posting server"), group.get_server_name());
	  c.set_header(_("Newsgroups"), group.get_group_name());
	  tty_grin_composition(c, "New message");
	}
	break;
      case 'd':
	((message_descriptor *)(g->get_cursor()->get_user_data(0)))->
	  toggle_flag(message_descriptor::DELETED);
	tty_grin_newsgroup__refresh_flag(g->get_cursor());
	g->go_down();
	break;
      case 'm':
	((message_descriptor *)(g->get_cursor()->get_user_data(0)))->
	  toggle_flag(message_descriptor::MARKED);
	tty_grin_newsgroup__refresh_flag(g->get_cursor());
	g->go_down();
	break;
      case 'r':
	((message_descriptor *)(g->get_cursor()->get_user_data(0)))->
	  toggle_flag(message_descriptor::READ);
	tty_grin_newsgroup__refresh_flag(g->get_cursor());
	g->go_down();
	break;
      case 1:
	if(tgws::yes_or_no
	   (_("Mark all articles as being read (yes or no)?"))) {
	  for(tgws::ctree_node *n=g->get_first();n;n=n->get_next())
	    tty_grin_newsgroup__mark_as_read(n);
	}
	break;
      }
    } while(key!='<'&&key!=','&&key!=KEY_LEFT);

    int i;
    for(i=0;i<group.size()&&
	  !(group[i].get_flags()&message_descriptor::DELETED);i++);
    if(i<group.size()&&
       tgws::yes_or_no(_("Expunge deleted articles (yes or no)?")))
      group.expunge();
  } else tgws::error_message(_("Newsgroup is empty."));

  tgws::active_screen->pop();
}
