// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "tgws.h"
#include "unix.h"
#include "tempfile.h"
#include <fstream>

void
tty_grin_mailbox__refresh_flag(tgws::clist_node *n) {
  message_descriptor *d=(message_descriptor *)(n->get_user_data(0));
  char tmp[]={d->status(), 0};
  n->set_text(0, tmp);
}

void
tty_grin_mailbox(mailbox& box, const char *comment) {
  tgws::active_screen->push();
  {
    tgws::title *t=new tgws::title(comment);
    t->size(1, COLS);
    t->position(0, 0);
    t->show();

    tgws::keyblock *k=new tgws::keyblock;
    k->add("<", _("Back"));
    k->add("D", _("(Un)Delete"));
    k->add("M", _("(Un)Mark"));
    k->add("R", _("Make (un)read"));
    k->add("^A", _("Make all read"));
    k->size(2, COLS);
    k->position(LINES-2, 0);
    k->show();
  }

  if(box.size()) {
    tgws::clist *l=new tgws::clist(3);
    for(int i=0;i<box.size();i++) {
      tgws::clist_node *n=l->insert(0);
      char tmp[]={box[i].status(), 0};
      n->set_user_data(0, &box[i]);
      n->set_text(0, tmp);
      n->set_text(1, box[i].get_from());
      n->set_text(2, box[i].get_subject());
    }
    l->set_headings(true);
    l->set_title(1, _("From"));
    l->set_title(2, _("Subject"));
    l->set_width(0, 2);
    l->set_width(1, (COLS-1)/2);
    l->set_width(2, (COLS-1)/2);
    l->size(LINES-5, COLS);
    l->position(2, 0);
    l->show();
    
    int key;
    do {
      if(isupper(key=l->run())) key+=32;
      switch(key) {
      case ' ':
      case '\n':
      case KEY_RIGHT:
	{
	  message_descriptor& m=
	    *(message_descriptor *)(l->get_cursor()->get_user_data(0));
	  tempfile t;
	  ofstream out(t.filename());
	  if(m.extract(out)) {
	    out.close();
	    message msg(t.filename());
	    tty_grin_message(msg, m);
	    tty_grin_mailbox__refresh_flag(l->get_cursor());
	  } else {
	    out.close();
	    tgws::error_message(_("Unable to view message."));
	  }
	}
	break;
      case 'd':
	((message_descriptor *)(l->get_cursor()->get_user_data(0)))->
	  toggle_flag(message_descriptor::DELETED);
	tty_grin_mailbox__refresh_flag(l->get_cursor());
	l->go_down();
	break;
      case 'm':
	((message_descriptor *)(l->get_cursor()->get_user_data(0)))->
	  toggle_flag(message_descriptor::MARKED);
	tty_grin_mailbox__refresh_flag(l->get_cursor());
	l->go_down();
	break;
      case 'r':
	((message_descriptor *)(l->get_cursor()->get_user_data(0)))->
	  toggle_flag(message_descriptor::READ);
	tty_grin_mailbox__refresh_flag(l->get_cursor());
	l->go_down();
	break;
      case 1:
	if(tgws::yes_or_no
	   (_("Mark all messages as being read (yes or no)?"))) {
	  for(tgws::clist_node *n=l->get_first();n;n=n->get_next()) {
	    ((message_descriptor *)(n->get_user_data(0)))->
	      set_flag(message_descriptor::READ);
	    tty_grin_mailbox__refresh_flag(n);
	  }
	}
	break;
      case 12: tgws::active_screen->redraw(); break;
      }
    } while(key!=','&&key!='<'&&key!=KEY_LEFT);

    int i;
    for(i=0;i<box.size()&&
	  !(box[i].get_flags()&message_descriptor::DELETED);i++);
    if(i<box.size()&&tgws::yes_or_no
       (_("Expunge deleted messages (yes or no)?")))
      box.expunge();
  } else tgws::error_message(_("Mailbox is empty."));
    
  tgws::active_screen->pop();
}
