// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <stdlib.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <dirent.h>
#include <errno.h>
#include <string.h>
#include <fstream>
#include "unix.h"
#include "tgws.h"
#include "localboxlist.h"
#include "localmailbox.h"
#include "imap4boxlist.h"

mailbox *
tty_grin_mail_choose(void) {
  try {
    tgws::menu m;
    m.add_item(_("Inbox"));
    m.add_item(_("Local folders..."));
    m.add_item(_("IMAP4 profiles..."));
    m.size(5, 25);
    m.position(LINES/3, COLS/4);
    m.show();
    
    int key;
    while((key=m.run())!='\n') if(key==3) return 0;

    switch(m.get_cursor_number()) {
    case 0: // Return pointer to object referencing INBOX
      {
	mailbox *m=new localmailbox(config_get_string("INBOX"));
	if(!m) tgws::error_message("Unable to open inbox.");
	return m;
      }
    case 1: // Browse local mailboxes
      {
	localboxlist local(config_get_string("LOCAL-MAIL"));
	if(local.size()) {
	  tgws::menu m2;
	  for(int i=0;i<local.size();i++) m2.add_item(local[i]);
	  m2.size(LINES/3, COLS/4);
	  m2.position(LINES/3, COLS/2);
	  m2.show();
	  while((key=m2.run())!='\n') if(key==3) return 0;
	  mailbox *lmb=local.openbox(m2.get_cursor_name());
	  if(!lmb) tgws::error_message(_("Unable to open local mailbox."));
	  return lmb;
	} else {
	  tgws::error_message(_("No local mailboxes available."));
	  return 0;
	}
      }
    case 2: // IMAP4 profiles
      {
	string profile_path(getenv("HOME"));
	profile_path+="/.ttygrin/imap4";
	ifstream profiles(profile_path.c_str());
	if(profiles.bad()) {
	  tgws::error_message(_("No profiles available."));
	  return 0;
	}
	char buf[1024];
	profiles.getline(buf, sizeof(buf));

	if(!profiles.fail()) {
	  tgws::menu m2;
	  while(!profiles.fail()) {
	    char *host=strtok(buf, "\t"),
	      *user=strtok(0, "\t"), *prefix=strtok(0, "\t");
	    if(host&&user&&prefix) {
	      string display(user);
	      display+='@';
	      display+=host;
	      display+=' ';
	      display+=prefix;
	      m2.add_item(display.c_str());
	    }
	    profiles.getline(buf, sizeof(buf));
	  }
	  profiles.close();

	  m2.size(LINES/3, COLS/4);
	  m2.position(LINES/3, COLS/2);
	  m2.show();
	  while((key=m2.run())!='\n') if(key==3) return 0;

	  { // We'll assume the profiles list is still good
	    ifstream profiles2(profile_path.c_str());
	    for(int i=0;i<=m2.get_cursor_number();i++)
	      profiles2.getline(buf, sizeof(buf));
	    profiles2.close();
	  }

	  char *host=strtok(buf, "\t"), *user=strtok(0, "\t"),
	    *prefix=strtok(0, "\t"), *password=strtok(0, "\t");
	  imap4boxlist imap4(host, user, prefix, password);

	  tgws::menu m3;
	  for(int i=0;i<imap4.size();i++) m3.add_item(imap4[i]);
	  m3.size(LINES/3, COLS/4);
	  m3.position(LINES/2, COLS*2/3);
	  m3.show();
	  while((key=m3.run())!='\n') if(key==3) return 0;
	  mailbox *imb=imap4.openbox(m3.get_cursor_name());
	  if(!imb) tgws::error_message(_("Unable to open IMAP4 mailbox."));
	  return imb;
	} else {
	  tgws::error_message(_("No profiles available."));
	  return 0;
	}
      }
    }
  }
  catch(config_error e) { }
  return 0;
}

void
tty_grin_mail(boxlist& blist, const char *comment) {
  tgws::active_screen->push();

  {
    tgws::title *t=new tgws::title(comment);
    t->size(1, COLS);
    t->position(0, 0);
    t->show();
    tgws::keyblock *k=new tgws::keyblock;
    k->add("<", _("Back"));
    k->add("^N", _("New"));
    k->add("^K", _("Delete"));
    k->add("^R", _("Rename"));
    k->size(1, COLS);
    k->position(LINES-1, 0);
    k->show();
  }

  tgws::clist *m=new tgws::clist(1);
  for(int i=0;i<blist.size();i++) m->insert(0)->set_text(0, blist[i]);
  m->set_width(0, COLS);
  m->size(LINES-4, COLS);
  m->position(2, 0);
  m->show();

  int key;
  do {
    switch(key=m->run()) {
    case 14:
      {
	string name;
	if(tgws::get_line(_("Folder name:"), name)) {
	  if(blist.create(name.c_str()))
	    m->insert(0)->set_text(0, name.c_str());
	  else tgws::error_message(_("Unable to create folder."));
	}
      }
      break;
    case 18:
      if(m->get_cursor()) {
	string name;
	if(tgws::get_line(_("New name for folder:"), name)) {
	  if(blist.move(m->get_cursor()->get_text(0), name.c_str()))
	    m->get_cursor()->set_text(0, name.c_str());
	  else tgws::error_message(_("Unable to rename folder."));
	}
      }
      break;
    case 11:
      if(m->get_cursor()&&
	 tgws::yes_or_no(_("Delete this folder (yes or no)?"))) {
	if(blist.remove(m->get_cursor()->get_text(0)))
	  delete m->get_cursor();
	else tgws::error_message(_("Unable to delete folder."));
      }
      break;
    case '>':
    case '.':
    case KEY_RIGHT:
    case ' ':
    case '\n':
      if(m->get_cursor()) {
	mailbox *box=blist.openbox(m->get_cursor()->get_text(0));
	if(box) {
	  tty_grin_mailbox(*box, m->get_cursor()->get_text(0));
	  delete box;
	} else tgws::error_message(_("Unable to open folder."));
      }
      break;
    }
  } while(key!='<'&&key!=','&&key!=KEY_LEFT);
  
  tgws::active_screen->pop();
}
