// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "tgws.h"

void
tgws::menu::draw(bool running) {
  wbkgdset(win, look->get_attr(MENU));
  werase(win);

  if(cursor_number<scr_number||
     cursor_number>=scr_number+(unsigned)height-2) {
    scr_number=cursor_number;
    scr=cursor;
    for(int i=0;i<height&&scr_number;i+=2) {
      --scr;
      --scr_number;
    }
  }

  int lines;
  menu_t::iterator l=scr;
  for(lines=1;lines<height-1&&l!=items.end();lines++) {
    if((*l).empty()) {
      wattrset(win, look->get_attr(FRAME));
      for(int i=1;i<width-1;i++) mvwaddch(win, lines, i, ACS_HLINE);
    } else {
      wattrset(win, look->get_attr(running&&l==cursor?SELECTION:MENU));
      mvwaddch(win, lines, 1, ' ');
      waddnstr(win, (*l).c_str(), width-4);
      for(int i=(*l).size();i<width-3;i++) waddch(win, ' ');
    }
    ++l;
  }

  wattrset(win, look->get_attr(FRAME));
  int i;
  for(i=1;i<width-1;i++) {
    mvwaddch(win, 0, i, ACS_HLINE);
    mvwaddch(win, height-1, i, ACS_HLINE);
  }
  for(i=1;i<height-1;i++) {
    mvwaddch(win, i, 0, ACS_VLINE);
    mvwaddch(win, i, width-1, ACS_VLINE);
  }
  mvwaddch(win, 0, 0, ACS_ULCORNER);
  mvwaddch(win, 0, width-1, ACS_URCORNER);
  mvwaddch(win, height-1, 0, ACS_LLCORNER);
  mvwaddch(win, height-1, width-1, ACS_LRCORNER);
  input::draw();
}

int
tgws::menu::run(void) {
  for(;;) {
    draw(true);
    doupdate();
    switch(int key=wgetch(win)) {
    case KEY_UP:
      {
	unsigned int old=cursor_number;
	do {
	  if(!(cursor_number--)) {
	    cursor_number=items.size()-1;
	    --(cursor=items.end());
	  } else --cursor;
	} while((*cursor).empty()&&cursor_number!=old);
	break;
      }
    case KEY_DOWN:
      {
	unsigned int old=cursor_number;
	do {
	  if(++cursor_number>=items.size()) {
	    cursor_number=0;
	    cursor=items.begin();
	  } else ++cursor;
	} while((*cursor).empty()&&cursor_number!=old);
	break;
      }
    default:
      draw();
      return key;
    }
  }
}

int
tgws::menu::add_item(const char *name) {
  string s(name);

  items.push_back(s);
  if(items.size()==1) {
    scr=cursor=items.begin();
    scr_number=cursor_number=0;
  }
  int h=items.size()+2, w=width;
  if(w<(signed)s.size()+4) w=(signed)s.size()+4;
  if(h>LINES) h=LINES;
  if(w>COLS) w=COLS;
  if(w!=width||h!=height) size(h, w);
  return items.size()-1;
}
