// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "tgws.h"

tgws::keyblock::~keyblock(void) {
  for(vector<keylabel *>::iterator i=labels.begin();i!=labels.end();++i)
    delete *i;
}

void
tgws::keyblock::size(int h, int w) {
  widget::size(h, w);
  rehash();
}

void
tgws::keyblock::position(int l, int c) {
  widget::position(l, c);
  rehash();
}

void
tgws::keyblock::draw(bool r) {
  wbkgdset(win, look->get_attr(TEXT));
  werase(win);
  for(vector<keylabel *>::iterator i=labels.begin();i!=labels.end();++i)
    (*i)->draw(r);
}

void
tgws::keyblock::show(void) {
  for(vector<keylabel *>::iterator i=labels.begin();i!=labels.end();++i)
    (*i)->show();
}

void
tgws::keyblock::hide(void) {
  for(vector<keylabel *>::iterator i=labels.begin();i!=labels.end();++i)
    (*i)->hide();
}

void
tgws::keyblock::add(const char *key, const char *label) {
  int l=strlen(label)+5;
  if(l>max) max=l;
  labels.push_back(new keylabel(key, label));
  rehash();
}

void
tgws::keyblock::rehash(void) {
  int npr=width/max, l=0, c=0;

  for(vector<keylabel *>::iterator i=labels.begin();
      i!=labels.end();++i) {
    (*i)->size(1, max);
    (*i)->position(line+l, column+c*max);
    if(++c>=npr) {
      c=0;
      if(++l>=height) l=0;
    }
  }
}
