// -*-Mode: C++;-*-

// TTY-Grin Widget Set
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace tgws {
  class ctree;

  class ctree_node {
    friend ctree;

  public:
    ctree_node(ctree *);
    ~ctree_node(void);

    ctree_node *up(void) const;
    ctree_node *down(void) const;

    bool get_expanded(void) const { return expanded; }
    void set_expanded(bool what) { expanded=what; }
    const char *get_text(int which) const { return text[which].c_str(); }
    void set_text(int which, const char *what) { text[which]=what; }
    void *get_user_data(int which) const { return user_data[which]; }
    void set_user_data(int which, void *what) { user_data[which]=what; }
    ctree_node *get_next(void) { return next; }
    ctree_node *get_prev(void) { return prev; }
    ctree_node *get_first(void) { return first; }
    ctree_node *get_last(void) { return last; }
    ctree_node *get_owner(void) { return owner; }
    void expand_all(bool);
    ctree_node *up_expand(void) const;
    ctree_node *down_expand(void) const;

    unsigned char get_tag_collapsed(void) const { return tag_collapsed; }
    void set_tag_collapsed(unsigned char x) { tag_collapsed=x; }
    unsigned char get_tag_expanded(void) const { return tag_expanded; }
    void set_tag_expanded(unsigned char x) { tag_expanded=x; }

  private:
    ctree *parent;
    ctree_node *prev, *next, *first, *last, *owner;
    string *text;
    bool expanded;
    int indent;
    void **user_data;
    unsigned char tag_collapsed, tag_expanded;
  };

  class ctree : public input {
    friend ctree_node;

  public:
    ctree(int);
    virtual ~ctree(void);

    virtual int run(void);
    virtual void draw(bool=false);

    ctree_node *get_first(void) { return first; }
    ctree_node *get_last(void) { return last; }
    ctree_node *get_cursor(void) { return cursor; }
    ctree_node *insert(ctree_node *, ctree_node *);

    bool empty(void) const { return first==0; }
    int get_count(void) const { return count; }
    bool get_headings(void) const { return headings; }
    void set_headings(bool what) { headings=what; }
    int get_num(void) const { return num; }
    const char *get_title(int which) const { return title[which].c_str(); }
    void set_title(int which, const char *what) { title[which]=what; }
    int get_width(int which) const { return columns[which]; }
    void set_width(int which, int what) { columns[which]=what; }

    void expand_all(bool);
    void go_up(void) { if(cursor->up()) cursor=cursor->up(); }
    void go_down(void) { if(cursor->down()) cursor=cursor->down(); }

  protected:
    int num, count, indent;
    bool headings;
    string *title;
    int *columns;
    ctree_node *cursor, *scr, *first, *last;
    string last_pattern;

  private:
    void draw_line(const string *, int=0, char=' ', unsigned char=' ');
  };
};
