// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  typedef object (*system_function_t)(library&, int, object *);

  class system_function : public function {
  public:
    system_function(system_function_t c) : code(c) { }
    virtual string print(void) const;
    virtual bool equal(object) const;
    virtual int recursive_mark(void);
    virtual object funcall(library&, int, object *);

  private:
    system_function_t code;
  };

  inline bool is_system_function(const object x) {
    return dynamic_cast<const system_function *>(x.get_const_data())!=0;
  }

  inline system_function& assume_system_function(object x) {
    return *(system_function *)x.get_data();
  }

  inline system_function& as_system_function(object x) {
    system_function *s=dynamic_cast<system_function *>(x.get_data());
    if(s) return *s;
    throw error(x, _("Type mismatch"));
  }
};
