// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <stdio.h>
#include "lisp.h"

lisp::object
lisp::system_function::funcall(library& l, int argc, object *argv) {
  return code(l, argc, argv);
}

bool
lisp::system_function::equal(object x) const {
  return is_system_function(x)&&assume_system_function(x).code==code;
}

string
lisp::system_function::print(void) const {
  char tmp[64];

  sprintf(tmp, "#<SYSTEM-FUNCTION %p>", code);
  return string(tmp);
}

int
lisp::system_function::recursive_mark(void) {
  if(get_mark()) return 0;
  set_mark(true);
  return 1;
}
