// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class structure : public variable {
  public:
    structure(const char *, const structdef *);
    virtual ~structure(void);

    virtual bool equal(object) const;
    virtual string print(void) const;
    virtual int recursive_mark(void);
    virtual const char *get_typeof(void) const;

    const char *get_type(void) const { return type.c_str(); }
    int size(void) const { return num; }
    weak_object& operator[](int x) {
      if(x<0||x>=num) throw error(object(this), _("Out of bounds"));
      return elements[x];
    }

  private:
    class lt_string {
    public:
      bool operator()(const string& a, const string& b) const { return a<b; }
    };

    string type;
    const structdef *definition;
    int num;
    weak_object *elements;
  };

  inline bool is_structure(const object x) {
    return dynamic_cast<const structure *>(x.get_const_data())!=0;
  }

  inline structure& assume_structure(object x) {
    return *(structure *)x.get_data();
  }

  inline structure& as_structure(object x) {
    structure *s=dynamic_cast<structure *>(x.get_data());
    if(s) return *s;
    throw error(x, _("Type mismatch"));
  }
};
