// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <stdio.h>
#include "lisp.h"

string
lisp::integer::print(void) const {
  char tmp[64];

  sprintf(tmp, "%d", value);
  return string(tmp);
}

bool
lisp::integer::equal(object x) const {
  return is_integer(x)&&assume_integer(x).value==value;
}

lisp::object
lisp::integer::convert(enum contagion_level l) const {
  switch(l) {
  case INTEGER: return object(new integer(value));
  case REAL: return object(new real((float)value));
  }
  return nil;
}

lisp::object
lisp::integer::unary(enum unary_op o) const {
  return nil;
}

lisp::object
lisp::integer::binary(enum binary_op o, object p) const {
  {
    enum contagion_level l=as_number(p).get_level();
    if(l>get_level()) {
      object m=convert(l);
      return assume_number(m).binary(o, p);
    }
    if(l<get_level()) p=assume_number(p).convert(get_level());
  }

  int v=assume_integer(p).get_value(), r=0;

  switch(o) {
  case ADD: r=value+v; break;
  case SUBTRACT: r=value-v; break;
  case MULTIPLY: r=value*v; break;
  case DIVIDE:
    if(!v) throw error(object(new integer(value)), _("Division by zero"));
    if(value%v) return object(new real((float)value/(float)v));
    r=value/v;
    break;

  case LT: return (value<v)?t:nil;
  case LTEQ: return (value<=v)?t:nil;
  case GT: return (value>v)?t:nil;
  case GTEQ: return (value>=v)?t:nil;
  case EQ: return (value==v)?t:nil;
  }

  return object(new integer(r));
}

const char *
lisp::integer::get_typeof(void) const {
  return "INTEGER";
}
