// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class hash_table : public variable {
  public:
    hash_table(object);

    virtual string print(void) const;
    virtual bool equal(object) const;
    virtual int recursive_mark(void);
    virtual const char *get_typeof(void) const;

    object get_test(void) const { return test_function; }
    void clear(void) { data.clear(); }
    int size(void) const { return data.size(); }
    object readhash(library&, object);
    weak_object *gethash(library&, object);

  private:
    weak_object test_function;
    vector<pair<weak_object, weak_object> > data;
  };

  inline bool is_hash_table(const object o) {
    return dynamic_cast<const hash_table *>(o.get_const_data())!=0;
  }

  inline hash_table& assume_hash_table(object o) {
    return *(hash_table *)o.get_data();
  }

  inline hash_table& as_hash_table(object o) {
    hash_table *h=dynamic_cast<hash_table *>(o.get_data());
    if(h) return *h;
    throw error(o, _("Type mismatch"));
  }
};
