// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "lisp.h"

list<lisp::variable *> lisp::catalog;

int
lisp::gc_mark(void) {
  for(list<variable *>::iterator i=catalog.begin();i!=catalog.end();i++)
    (*i)->set_mark(false);
  
  int total=0;
  for(list<variable *>::iterator i=catalog.begin();i!=catalog.end();i++)
    if((*i)->get_references()) total+=(*i)->recursive_mark();

  return total;
}

int
lisp::gc_sweep(void) {
  int total=0;

  for(list<variable *>::iterator i=catalog.begin();i!=catalog.end();i++)
    if(!(*i)->get_mark()) {
      delete (*i);
      --(i=catalog.erase(i));
      total++;
    }

  return total;
}
