// -*-Mode: C++;-*-

// Grin LISP
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

namespace lisp {
  class array : public variable {
  public:
    array(int n) : numd(n), dimensions(new int[n]) { }
    array(const array&);
    virtual ~array(void);

    void set_dim(int which, int what) {
      if((dimensions[which]=what)<0)
	throw error(object(this), _("Out of bounds"));
    }
    int get_dim(int which) const { return dimensions[which]; }
    int num_dim(void) const { return numd; }
    int num_data(void) const { return totalsize; }
    void allocate(void);
    weak_object& operator[](int x) { return data[x]; }

    virtual string print(void) const;
    virtual bool equal(object) const;
    virtual int recursive_mark(void);
    virtual const char *get_typeof(void) const;

  private:
    int numd, *dimensions, totalsize;
    weak_object *data;

    void printhelp(string&, int, int, int) const;
  };

  inline bool is_array(const object x) {
    return dynamic_cast<const array *>(x.get_const_data())!=0;
  }

  inline array& assume_array(object x) {
    return *(array *)x.get_data();
  }

  inline array& as_array(object x) {
    array *a=dynamic_cast<array *>(x.get_data());
    if(a) return *a;
    throw error(x, _("Type mismatch"));
  }
};
