// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include "message_descriptor.h"

unsigned char message_descriptor::status_flags[]={
  message_descriptor::READ,        ' ',
  message_descriptor::ANSWERED,    'A',
  message_descriptor::MARKED,      '*',
  message_descriptor::DELETED,     'D',
  0
};

message_descriptor::~message_descriptor(void) {
}

unsigned char
message_descriptor::flags_to_status(unsigned char flags) {
  unsigned char s('N'), *f;

  for(f=status_flags;*f;f+=2) if(flags&*f) s=f[1];
  return s;
}

void
message_descriptor::set_flags(unsigned char x) {
  flags=x;
}
