// TTY-Grin
// Copyright (C) 2001 Daniel Beer
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software

#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <algorithm>
#include "localboxlist.h"
#include "localmailbox.h"

boxlist::~boxlist(void) {
}

localboxlist::~localboxlist(void) {
}

localboxlist::localboxlist(const char *p) : path(p) {
  DIR *d=opendir(p);
  if(d) {
    struct dirent *ent;
    while((ent=readdir(d))) {
      if(*ent->d_name!='.') {
	string s(ent->d_name);
	names.push_back(s);
      }
    }
    closedir(d);
  }
  sort(names.begin(), names.end());
}

bool
localboxlist::move(const char *from, const char *to) const {
  int fd=open(".", O_RDONLY);
  if(chdir(path.c_str())<0) {
    close(fd);
    return false;
  }
  if(!access(to, F_OK)||rename(from, to)) {
    fchdir(fd);
    close(fd);
    return false;
  }
  fchdir(fd);
  close(fd);
  return true;
}

bool
localboxlist::remove(const char *name) const {
  int fd=open(".", O_RDONLY);
  if(chdir(path.c_str())<0) {
    close(fd);
    return false;
  }
  if(unlink(name)) {
    fchdir(fd);
    close(fd);
    return false;
  }
  fchdir(fd);
  close(fd);
  return true;
}

bool
localboxlist::create(const char *name) const {
  int fd=open(".", O_RDONLY);
  if(chdir(path.c_str())<0) {
    mkdir(path.c_str(), 0700);
    if(chdir(path.c_str())<0) {
      close(fd);
      return false;
    }
  }
  int touch=open(name, O_WRONLY|O_CREAT|O_EXCL, 0600);
  if(touch<0) {
    fchdir(fd);
    close(fd);
    return false;
  }
  close(touch);
  fchdir(fd);
  close(fd);
  return true;
}

mailbox *
localboxlist::openbox(const char *name) const {
  string fullpath(path);
  fullpath+='/';
  fullpath+=name;
  return new localmailbox(fullpath.c_str());
}
